<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2023 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CBLib\Registry\GetterInterface;
use CBLib\Language\CBTxt;
use CB\Database\Table\UserTable;

// ensure this file is being included by a parent file
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

class CBController_users {

	/**
	 * Outputs legacy user mass mailer and user reconfirm email display
	 *
	 * @param  string  $option
	 * @param  string  $task
	 * @param  int[]   $cid
	 * @return void
	 * @deprecated 2.0
	 */
	public function showUsers( $option, $task, $cid ) {
		global $_CB_framework, $_CB_database, $ueConfig, $_PLUGINS;

		cbimport( 'language.all' );
		cbimport( 'cb.tabs' );
		cbimport( 'cb.params' );
		cbimport( 'cb.pagination' );
		cbimport( 'cb.lists' );

		// We just need the user rows as we've already filtered down the IDs in user management:
		$rows								=	array();

		if ( $cid ) {
			$query							=	'SELECT *'
											.	"\n FROM " . $_CB_database->NameQuote( '#__comprofiler' ) . " AS c"
											.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__users' ) . " AS u"
											.	' ON u.' . $_CB_database->NameQuote( 'id' ) . ' = c.' . $_CB_database->NameQuote( 'id' )
											.	"\n WHERE u." . $_CB_database->NameQuote( 'id' ) . " IN " . $_CB_database->safeArrayOfIntegers( $cid );
			$_CB_database->setQuery( $query );
			$rows							=	$_CB_database->loadObjectList( null, '\CB\Database\Table\UserTable', array( $_CB_database ) );
		}

		if ( $task == 'resendconfirmationemails' ) {
			if ( ! $rows ) {
				cbRedirect( $_CB_framework->backendViewUrl( 'showusers', false ), CBTxt::T( 'SELECT_A_ROW_TO_TASK', 'Select a row to [task]', array( '[task]' => $task ) ), 'error' );
			}

			$count							=	0;

			/** @var UserTable[] $rows */
			foreach ( $rows as $row ) {
				if ( $row->confirmed == 0 ) {
					if ( $row->cbactivation == '' ) {
						// Generate a new confirmation code if the user doesn't have one (requires email confirmation to be enabled):
						$row->store();
					}

					$cbNotification			=	new cbNotification();

					$cbNotification->sendFromSystem( $row->id, CBTxt::T( $ueConfig['reg_pend_appr_sub'] ), CBTxt::T( $ueConfig['reg_pend_appr_msg'] ), true, ( isset( $ueConfig['reg_email_html'] ) ? (int) $ueConfig['reg_email_html']  : 0 ) );
					++$count;
				}
			}

			cbRedirect( $_CB_framework->backendViewUrl( 'showusers', false ), CBTxt::T( 'SENT_CONFIRMATION_EMAILS_TO_NUM_USERS_USERS', 'Sent confirmation emails to [NUM_USERS] users', array( '[NUM_USERS]' => $count ) ) );
		} else {
			$emailTo						=	Application::Input()->get( 'post/emailto', '', GetterInterface::STRING );
			$emailSubject					=	Application::Input()->get( 'post/emailsubject', '', GetterInterface::STRING );
			$emailBody						=	Application::Input()->get( 'post/emailbody', '', GetterInterface::HTML );
			$emailAttach					=	Application::Input()->get( 'post/emailattach', '', GetterInterface::STRING );
			$emailCC						=	Application::Input()->get( 'post/emailcc', '', GetterInterface::STRING );
			$emailBCC						=	Application::Input()->get( 'post/emailbcc', '', GetterInterface::STRING );
			$emailsPerBatch					=	Application::Input()->get( 'post/emailsperbatch', 50, GetterInterface::UINT );
			$emailsBatch					=	Application::Input()->get( 'post/emailsbatch', 0, GetterInterface::UINT );
			$emailFromName					=	Application::Input()->get( 'post/emailfromname', '', GetterInterface::STRING );
			$emailFromAddr					=	Application::Input()->get( 'post/emailfromaddr', '', GetterInterface::STRING );
			$emailReplyName					=	Application::Input()->get( 'post/emailreplyname', '', GetterInterface::STRING );
			$emailReplyAddr					=	Application::Input()->get( 'post/emailreplyaddr', '', GetterInterface::STRING );
			$emailPause						=	Application::Input()->get( 'post/emailpause', 30, GetterInterface::UINT );
			$simulationMode					=	Application::Input()->get( 'post/simulationmode', '', GetterInterface::STRING );

			if ( $emailTo ) {
				$Tos						=	preg_split( '/ *, */', $emailTo );

				foreach ( $Tos as $To ) {
					$rowTo					=	new UserTable();
					$rowTo->name			=	$To;
					$rowTo->username		=	$To;
					$rowTo->email			=	$To;

					$rows[]					=	$rowTo;
				}
			}

			$total							=	count( $rows );

			$pageNav						=	new cbPageNav( $total, 0, 10 );
			$search							=	'';
			$lists							=	array();
			$inputTextExtras				=	null;
			$select_tag_attribs				=	null;

			if ( $task == 'emailusers' ) {
				if ( ! $rows ) {
					cbRedirect( $_CB_framework->backendViewUrl( 'showusers', false ), CBTxt::T( 'SELECT_A_ROW_TO_TASK', 'Select a row to [task]', array( '[task]' => $task ) ), 'error' );
				}

				$pluginRows					=	$_PLUGINS->trigger( 'onBeforeBackendUsersEmailForm', array( &$rows, &$pageNav, &$search, &$lists, &$cid, &$emailSubject, &$emailBody, &$inputTextExtras, &$select_tag_attribs, $simulationMode, $option, &$emailAttach, &$emailFromName, &$emailFromAddr, &$emailReplyName, &$emailReplyAddr, &$emailTo, &$emailCC, &$emailBCC ) );
				$usersView					=	_CBloadView( 'users' );

				/** @var CBView_users $usersView */
				$usersView->emailUsers( $rows, $emailTo, $emailSubject, $emailBody, $emailAttach, $emailCC, $emailBCC, $emailFromName, $emailFromAddr, $emailReplyName, $emailReplyAddr, $emailsPerBatch, $emailsBatch, $emailPause, $simulationMode, $pluginRows );
			} elseif ( $task == 'startemailusers' ) {
				$pluginRows					=	$_PLUGINS->trigger( 'onBeforeBackendUsersEmailStart', array( &$rows, $total, $search, $lists, $cid, &$emailSubject, &$emailBody, &$inputTextExtras, $simulationMode, $option, &$emailAttach, &$emailFromName, &$emailFromAddr, &$emailReplyName, &$emailReplyAddr, &$emailTo, &$emailCC, &$emailBCC ) );
				$usersView					=	_CBloadView( 'users' );

				/** @var CBView_users $usersView */
				$usersView->startEmailUsers( $rows, $emailTo, $emailSubject, $emailBody, $emailAttach, $emailCC, $emailBCC, $emailFromName, $emailFromAddr, $emailReplyName, $emailReplyAddr, $emailsPerBatch, $emailsBatch, $emailPause, $simulationMode, $pluginRows );
			} elseif ( $task == 'ajaxemailusers' ) {
				if ( ! Application::Session()->checkFormToken( 'post', 0 ) ) {
					echo json_encode( [ 'result' => 0, 'htmlcontent' => CBTxt::Th( 'UE_SESSION_EXPIRED', 'The most recent request was denied because it had an invalid security token. Please go back or refresh the page and try again.' ) ] );
					return;
				}

				$cbNotification				=	new cbNotification( [ 'convertLinebreaks' => false ] );
				$mode						=	1; // html
				$errors						=	0;
				$success					=	array();
				$failed						=	array();

				$users						=	array_slice( $rows, $emailsBatch, $emailsPerBatch );

				if ( $simulationMode ) {
					$success				=	array( '<div class="alert alert-info">' . CBTxt::T( 'Emails do not send in simulation mode' ) . '</div>' );
				} else {
					foreach ( $users as $user ) {
						$extraStrings		=	array();

						$_PLUGINS->trigger( 'onBeforeBackendUserEmail', array( &$user, &$emailSubject, &$emailBody, $mode, &$extraStrings, $simulationMode, &$emailAttach, &$emailFromName, &$emailFromAddr, &$emailReplyName, &$emailReplyAddr, &$emailTo, &$emailCC, &$emailBCC ) );

						$attachments		=	cbReplaceVars( $emailAttach, $user, $mode, true, $extraStrings );

						if ( $attachments ) {
							$attachments	=	preg_split( '/ *, */', $attachments );
						} else {
							$attachments	=	null;
						}

						$CCs				=	cbReplaceVars( $emailCC, $user, $mode, true, $extraStrings );

						if ( $CCs ) {
							$CCs			=	preg_split( '/ *, */', $CCs );
						} else {
							$CCs			=	null;
						}

						$BCCs				=	cbReplaceVars( $emailBCC, $user, $mode, true, $extraStrings );

						if ( $BCCs ) {
							$BCCs			=	preg_split( '/ *, */', $BCCs );
						} else {
							$BCCs			=	null;
						}

						if ( ! $cbNotification->sendFromSystem( $user, $emailSubject, $this->makeLinksAbsolute( $emailBody ), true, $mode, $CCs, $BCCs, $attachments, $extraStrings, false, $emailFromName, $emailFromAddr, $emailReplyName, $emailReplyAddr ) ) {
							$failed[]		=	'<div class="alert alert-danger">' . '<strong>' . htmlspecialchars( $user->name . ' <' . $user->email . '>' ) . '</strong>: ' . CBTxt::Th( 'ERROR_SENDING_EMAIL_ERRORMSG', 'Error sending email: [ERROR_MSG]', array( '[ERROR_MSG]' => $cbNotification->errorMSG ) ) . '</div>';
							++$errors;
						} else {
							$success[]		=	htmlspecialchars( $user->name . ' <' . $user->email . '>' );
						}
					}
				}

				$usernames					=	implode( ', ', $success ) . implode( '', $failed );

				if ( $total < $emailsPerBatch ) {
					$limit					=	$total;
				} else {
					$limit					=	$emailsPerBatch;
				}

				ob_start();
				$usersView					=	_CBloadView( 'users' );
				/** @var CBView_users $usersView */
				$usersView->ajaxResults( $usernames, $emailSubject, $this->makeLinksAbsolute( $emailBody ), $emailAttach, $emailCC, $emailBCC, $emailFromName, $emailFromAddr, $emailReplyName, $emailReplyAddr, $emailsBatch, $limit, $total, $errors );
				$html						=	ob_get_contents();
				ob_end_clean();

				$reply						=	array(	'result' => 1,
														'htmlcontent' => $html
													);

				if ( ! ( $total - ( (int) $emailsBatch + (int) $emailsPerBatch ) > 0 ) ) {
					$reply['result']		=	2;
				}

				echo json_encode( $reply );
			}
		}
	}

	/**      
	 * Replaces relative URLs with absolute URLs
	 * 
	 * @param  string $text
	 * @return string
	 * @deprecated 2.0
	 */
	public function makeLinksAbsolute( $text ) {
		// replace <a> links:
		$text		=	preg_replace_callback( '/<a ((?:[^>]* )*)href="(.*)"([^>]*)>/iUs', array( $this, 'parseLinkURL' ), $text );

		// replace <img> links:
		$text		=	preg_replace_callback( '/<img ((?:[^>]* )*)src="(.*)"([^>]*)>/iUs', array( $this, 'parseImgURL' ), $text );

		return $text;
	}

	/**
	 * Replace relative non-sefed link with absolute sefed links
	 *
	 * @param array $matches
	 * @return string
	 * @deprecated 2.0
	 */
	public function parseLinkURL( $matches ) {
		$url		=	cbUnHtmlspecialchars( $matches[2] );

		if ( ( substr( $url, 0, 6 ) == 'mailto' ) || ( substr( $url, 0, 1 ) == '#' ) || ( substr( $url, 0, 4 ) == 'http' ) || ( substr( $url, 0, 1 ) == '[' ) ) {
			//mailto link or anchor inside mail or already absolute URL, do nothing..
			return $matches[0];
		}

		// find $url (remove absolute link case from above exception) in known links for id, otherwise insert
		// find linkid + mailing id in links_stats table, otherwise create, and re-create a specific url

		$url		=	cbSef( $url, true );

		return '<a ' . $matches[1] . 'href="' . $url . '"' . $matches[3] . '>';
	}

	/**
	 * Replace relative image src links with absolute links
	 *
	 * @param array $matches
	 * @return string
	 * @deprecated 2.0
	 */
	public function parseImgURL($matches){
		global $_CB_framework;

		$image		=	cbUnHtmlspecialchars( $matches[2] );

		if ( ( substr( $image, 0, 4 ) == 'http' ) || ( substr( $image, 0, 1 ) == '[' ) ) {
			// already absolute URL, do nothing..
			return $matches[0];
		}

		if ( substr( $image, 0, 1 ) != '/' ) {
			$image	=	'/' . $image;
		}

		$image		=	$_CB_framework->getCfg( 'live_site' ) . $image;

		return '<img ' . $matches[1] . 'src="' . $image . '"' . $matches[3] . '>';
	}
}
