<?php
/**
 * @package         Snippets
 * @version         8.4.7
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

namespace RegularLabs\Component\Snippets\Administrator\Table;

use Exception;
use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

defined('_JEXEC') or die;

class ItemTable extends Table
{
    /**
     * @param DatabaseDriver $db Database object.
     */
    public function __construct(DatabaseDriver $db)
    {
        parent::__construct('#__snippets', 'id', $db);
    }

    /**
     * @return  boolean
     */
    public function check()
    {
        try
        {
            parent::check();
        }
        catch (Exception $e)
        {
            $this->setError($e->getMessage());

            return false;
        }

        $this->name  = trim($this->name);
        $this->alias = trim($this->alias);

        return true;
    }
}
