<?php
/**
 * @package         Snippets
 * @version         8.4.7
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\HTML\HTMLHelper as JHtml;
use Joomla\CMS\Language\Text as JText;
use Joomla\CMS\Layout\LayoutHelper as JLayout;
use Joomla\CMS\Router\Route as JRoute;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\RegEx as RL_RegEx;
use RegularLabs\Library\StringHelper as RL_String;

defined('_JEXEC') or die;

RL_Document::style('regularlabs.admin-form');

$listOrder = RL_String::escape($this->state->get('list.ordering'));
$listDirn  = RL_String::escape($this->state->get('list.direction'));
$ordering  = ($listOrder == 'a.ordering');

$editor_name = JFactory::getApplication()->input->getString('editor', 'text');
// Remove any dangerous character to prevent cross site scripting
$editor_name = RL_RegEx::replace('[\'\";\s]', '', $editor_name);

$has_descriptions = false;
$has_categories   = false;

foreach ($this->items as $i => $item)
{
    if ($item->description)
    {
        $has_descriptions = true;
    }

    if ($item->category)
    {
        $has_categories = true;
    }

    if ($has_descriptions && $has_categories)
    {
        break;
    }
}
$cols = 6;
$cols += ($has_descriptions ? 1 : 0);
$cols += ($has_categories ? 1 : 0);
?>

<form action="<?php echo JRoute::_('index.php?option=com_snippets&view=items'); ?>"
      method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
    <?php
    // Search tools bar
    echo JLayout::render('joomla.searchtools.default', ['view' => $this]);
    ?>
    <table class="table table-striped" id="itemList">
        <thead>
            <tr>
                <th scope="col" class="w-1 text-nowrap text-center d-none d-md-table-cell">
                    <?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" class="w-20">
                    <?php echo JHtml::_('searchtools.sort', 'JFIELD_ALIAS_LABEL', 'a.alias', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" class="w-20">
                    <?php echo JHtml::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.name', $listDirn, $listOrder); ?>
                </th>
                <?php if ($has_descriptions) : ?>
                    <th scope="col" class="d-none d-md-table-cell">
                        <?php echo JHtml::_('searchtools.sort', 'JGLOBAL_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?>
                    </th>
                <?php endif; ?>
                <?php if ($has_categories) : ?>
                    <th scope="col" class="w-3 text-nowrap d-none d-md-table-cell">
                        <?php echo JHtml::_('searchtools.sort', 'JCATEGORY', 'a.category', $listDirn, $listOrder); ?>
                    </th>
                <?php endif; ?>
                <th scope="col" class="w-1 text-nowrap text-center">
                    <?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'a.published', $listDirn, $listOrder); ?>
                </th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($this->items)): ?>
                <tr>
                    <td colspan="<?php echo $cols; ?>">
                        <?php echo JText::_('RL_NO_ITEMS_FOUND'); ?>
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($this->items as $i => $item) : ?>
                    <?php

                    $vars = '[]';
                    ?>
                    <tr class="row<?php echo $i % 2; ?>">
                        <td class="text-center text-nowrap d-none d-md-table-cell">
                            <button onclick="parent.RegularLabs.SnippetsButton.insertById('<?php echo $editor_name; ?>', <?php echo (int) $item->id; ?>, <?php echo $vars; ?>);"
                                    type="button" class="btn btn-secondary btn-sm text-left">
                                <span class="fa fa-file-code me-1" aria-hidden="true"></span>
                                <?php echo (int) $item->id; ?>
                            </button>
                        </td>
                        <td class="text-nowrap">
                            <button onclick="parent.RegularLabs.SnippetsButton.insertByAlias('<?php echo $editor_name; ?>', '<?php echo RL_String::escape($item->alias); ?>', <?php echo $vars; ?>);"
                                    type="button" class="btn btn-secondary btn-sm text-left">
                                <span class="fa fa-file-code me-1" aria-hidden="true"></span>
                                <?php echo RL_String::escape($item->alias); ?>
                            </button>
                        </td>
                        <td>
                            <button onclick="parent.RegularLabs.SnippetsButton.insertByTitle('<?php echo $editor_name; ?>', '<?php echo RL_String::escape($item->name); ?>', <?php echo $vars; ?>);"
                                    type="button" class="btn btn-secondary btn-sm text-left">
                                <span class="fa fa-file-code me-1" aria-hidden="true"></span>
                                <?php echo RL_String::escape($item->name); ?>
                            </button>
                        </td>
                        <?php if ($has_descriptions) : ?>
                            <?php
                            $description = explode('---', $item->description);
                            ?>
                            <td class="d-none d-md-table-cell">
                                <span><?php echo nl2br(RL_String::escape(trim($description[0]))); ?></span>
                                <?php if ( ! empty($description[1])) : ?>
                                    <div role="tooltip"><?php echo nl2br(RL_String::escape(trim($description[1]))); ?></div>
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                        <?php if ($has_categories) : ?>
                            <td class="d-none d-md-table-cell">
                                <?php echo $item->category ? '<span class="label label-default">' . $item->category . '</span>' : ''; ?>
                            </td>
                        <?php endif; ?>
                        <td class="text-center">
                            <?php
                            echo $item->published
                                ? '<span class="icon-publish text-success" aria-hidden="true"></span><div role="tooltip">' . JText::_('JPUBLISHED') . '</div>'
                                : '<span class="icon-unpublish text-muted" aria-hidden="true"></span><div role="tooltip">' . JText::_('JUNPUBLISHED') . '</div>';
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>

    <?php // load the pagination. ?>
    <?php echo $this->pagination->getListFooter(); ?>

    <input type="hidden" name="task" value="">
    <input type="hidden" name="editor" value="<?php echo $editor_name; ?>">
    <input type="hidden" name="layout" value="popup">
    <input type="hidden" name="tmpl" value="component">
    <?php echo JHtml::_('form.token'); ?>
</form>
