<?php
/**
* @version $Id: admin.cbpaidsubscriptions.php 1608 2012-12-29 04:12:52Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Plugin for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\PluginTable;
use CB\Database\Table\UserTable;
use CBLib\Language\CBTxt;

/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;
$_PLUGINS->registerFunction( 'onBeforeBackendUsersListBuildQuery',	'onBeforeBackendUsersListBuildQuery',	'cbpaidAdminEvents' );
$_PLUGINS->registerFunction( 'onAfterBackendUsersList',				'onAfterBackendUsersList',				'cbpaidAdminEvents' );
$_PLUGINS->registerFunction( 'onBeforeBackendUsersEmailForm',		'onBeforeBackendUsersEmailForm',		'cbpaidAdminEvents' );
// $_PLUGINS->registerFunction( 'onBeforeBackendUsersEmailStart',		'onBeforeBackendUsersEmailStart',		'cbpaidAdminEvents' );
$_PLUGINS->registerFunction( 'onBeforeBackendUserEmail',			'onBeforeBackendUserEmail',				'cbpaidAdminEvents' );
$_PLUGINS->registerFunction( 'mod_onCBAdminMenu',					'onCBAdminMenu',					'cbpaidAdminEvents' );

global $_CB_framework;
if ( $_CB_framework->getCfg( 'debug' ) ) {
	ini_set('display_errors',true);
	error_reporting(E_ALL);
}

/** @noinspection PhpIncludeInspection */
include_once( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/cbpaidsubscriptions.class.php');

cbpaidErrorHandler::install();
cbpaidErrorHandler::on();

/**
 * Controller class for the admin interface
 */
class cbpaidAdminEvents extends cbpaidApp {		// getcbpaidsubscriptionsTab {
	protected $filter_cbpaidplan;
	protected $filter_cbpaidsubstate;
	protected $filter_cbpaidsubexpdate;

	/**
	 * Displays backend admin module menu items
	 *
	 * @param array $menu
	 * @param bool  $disabled
	 */
	public function onCBAdminMenu( &$menu, $disabled )
	{
		global $_CB_framework;

		$prevStateBase				=	'option=com_comprofiler&view=editPlugin&pluginid=' . $this->getPluginId();

		$cbsubsMenu					=	array();

		$cbsubsMenu['component']	=	array(	'title' => CBTxt::Th( 'Paid Subscriptions' ) );
		$cbsubsMenu['menu']			=	array(	array(	'title' => CBTxt::Th( 'Payments Center' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId() ) ), 'icon' => 'cbsubs-payments_center' ),
												array(	'title' => CBTxt::Th( 'Settings' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showparams', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( 'cbsubs.settings', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-settings' ),
												array(	'title' => CBTxt::Th( 'Gateways' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'gateways', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( 'cbsubs.gateways', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-gateways',
														'submenu' => array( array( 'title' => CBTxt::Th( 'Add New Gateway' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'editrow', 'table' => 'gatewaysbrowser', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showtable&table=gateways' ) ) ), 'access' => array( 'cbsubs.gateways', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cb-new' ) )
												),
												array(	'title' => CBTxt::Th( 'Plans' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'plans', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-plans',
														'submenu' => array( array( 'title' => CBTxt::Th( 'Add New Plan' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'editrow', 'table' => 'plansbrowser', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showtable&table=plans' ) ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cb-new' ) )
												),
												array(	'title' => CBTxt::Th( 'Subscriptions' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'subscriptions', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( 'cbsubs.usersubscriptionview', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-subscriptions' ),
												array(	'title' => CBTxt::Th( 'Baskets' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'paymentbaskets', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( array( 'cbsubs.sales', 'cbsubs.financial' ), 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-baskets' ),
												array(	'title' => CBTxt::Th( 'Payments' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'payments', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( array( 'cbsubs.sales', 'cbsubs.financial' ), 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-payments' ),
												array(	'title' => CBTxt::Th( 'Notifications' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'notifications', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( array( 'cbsubs.settings', 'cbsubs.gateways', 'cbsubs.sales' ), 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-notifications' ),
												array(	'title' => CBTxt::Th( 'Currencies' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'currencies', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( array( 'cbsubs.marketing', 'cbsubs.financial' ), 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-currencies' ),
												array(	'title' => CBTxt::Th( 'Statistics' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstats', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics',
														'submenu' => array(	array( 'title' => CBTxt::Th( 'Payments Monthly' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstatsmonthly', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showstats' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics_payments_monthly' ),
																			array( 'title' => CBTxt::Th( 'Payments Weekly' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstatsweekly', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showstats' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics_payments_weekly' ),
																			array( 'title' => CBTxt::Th( 'Payments by Weekday' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstatsdayofweek', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showstats' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics_payments_weekday' ),
																			array( 'title' => CBTxt::Th( 'Payments by Hour' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstatshourofday', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showstats' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics_payments_hourly' ),
																			array( 'title' => CBTxt::Th( 'Payments by Country' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstatscountrypayments', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showstats' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics_payments_country' ),
																			array( 'title' => CBTxt::Th( 'Payments Free Query' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstatsfreequery', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showstats' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics_payments_query' ),
																			array( 'title' => CBTxt::Th( 'Sales Monthly' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstatsitemsmonthly', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showstats' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics_sales_monthly' ),
																			array( 'title' => CBTxt::Th( 'Sales Weekly' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstatsitemsweekly', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showstats' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics_sales_weekly' ),
																			array( 'title' => CBTxt::Th( 'Sales by Weekday' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showstatsitemsdayofweek', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showstats' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-statistics_sales_weekday' )
																		)
												),
												array(	'title' => CBTxt::Th( 'Merchandise' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'merchandises', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( 'cbsubs.merchandisemanage', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-merchandise' ),
												array(	'title' => CBTxt::Th( 'Donations' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'donations', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( 'cbsubs.donationview', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-donations' ),
												array(	'title' => CBTxt::Th( 'Import' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'import', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( array( 'cbsubs.settings', 'cbsubs.recordpayments' ), 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-import' ),
												array(	'title' => CBTxt::Th( 'History Logs' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'history', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( array( 'cbsubs.settings', 'cbsubs.gateways' ), 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-history_logs' )
											);

		if ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/plugin/cbsubstax' ) ) {
			$cbsubsMenu['menu'][]	=	array(	'title' => CBTxt::Th( 'Taxes' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtaxsettings', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-taxes',
												'submenu' => array(	//array( 'title' => CBTxt::Th( 'Tax Rates' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'taxrules' ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-taxes_rules' ),
																	//array( 'title' => CBTxt::Th( 'Tax Rules' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'taxrates' ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-taxes_rates' ),
																	//array( 'title' => CBTxt::Th( 'Geographic Zones' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'geozones' ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-taxes_zones' ),
																	//array( 'title' => CBTxt::Th( 'Countries' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'countries' ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-taxes_countries' ),
																	//array( 'title' => CBTxt::Th( 'States / Provinces' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'provinces' ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-taxes_states' ),
																	array( 'title' => CBTxt::Th( 'Sales Tax / VAT Report' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'taxreportmonthly', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showtaxsettings' ) ) ), 'access' => array( 'cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-taxes_report' )
																)
											);
		}

		if ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/plugin/cbsubspromotion' ) ) {
			$cbsubsMenu['menu'][]	=	array(	'title' => CBTxt::Th( 'Promotions' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showpromotionssettings', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-promotions',
												'submenu' => array(	array( 'title' => CBTxt::Th( 'Promotions Settings' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'promotions' ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-promotions_settings' ),
																	array( 'title' => CBTxt::Th( 'Add New Promotion' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'editrow', 'table' => 'promotionsbrowser' ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cb-new' ),
																	array( 'title' => CBTxt::Th( 'Promotions Used' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'promotionsuses', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showpromotionssettings' ) ) ), 'access' => array( 'cbsubs.marketing and cbsubs.financial', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-promotions_uses' ),
																	array( 'title' => CBTxt::Th( 'Promotions Statistics' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'promotionsstats', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showpromotionssettings' ) ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-promotions_statistics' )
																)
											);
		}

		if ( file_exists( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/plugin/cbsubsmailer' ) ) {
			$cbsubsMenu['menu'][]	=	array(	'title' => CBTxt::Th( 'Mailer' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showmailersettings', 'cbprevstate' => base64_encode( $prevStateBase ) ) ), 'access' => array( array( 'core.admin', 'cbsubs.marketing' ), 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-mailer',
												'submenu' => array(	array( 'title' => CBTxt::Th( 'Mailers Settings' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'mailers', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showmailersettings' ) ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-mailer_settings' ),
																	array( 'title' => CBTxt::Th( 'Add New Mailer' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'editrow', 'table' => 'mailersbrowser', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showmailersettings' ) ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cb-new' ),
																	array( 'title' => CBTxt::Th( 'Automation settings' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'mailersendmail', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showmailersettings' ) ) ), 'access' => array( 'core.admin or cbsubs.settings or cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-mailer_automation' ),
																	array( 'title' => CBTxt::Th( 'Messages Queue' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'mailermailqueue', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showmailersettings' ) ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-mailer_queue' ),
																	array( 'title' => CBTxt::Th( 'Sent Messages' ), 'link' => $_CB_framework->backendViewUrl( 'editPlugin', true, array( 'cid' => $this->getPluginId(), 'action' => 'showtable', 'table' => 'mailersentmessages', 'cbprevstate' => base64_encode( $prevStateBase . '&action=showmailersettings' ) ) ), 'access' => array( 'cbsubs.marketing', 'com_comprofiler.plugin.cbsubs' ), 'icon' => 'cbsubs-mailer_sent' )
																)
											);
		}

		$menu['cbsubs']				=	$cbsubsMenu;
	}

	/**
	 * Intercepts CB User Manager list controller to add filters evaluation
	 *
	 * @param  array   $tablesSQL
	 * @param  array   $joinsSQL
	 * @param  array   $tablesWhereSQL
	 * @param  string  $option
	 * @return void
	 */
	public function onBeforeBackendUsersListBuildQuery( /** @noinspection PhpUnusedParameterInspection */ &$tablesSQL, &$joinsSQL, &$tablesWhereSQL, $option ) {
		global $_CB_framework, $_CB_database;

		if ( cbpaidApp::authoriseAction( 'cbsubs.usersubscriptionview' ) ) {

			$this->filter_cbpaidplan		=	(int) $_CB_framework->getUserStateFromRequest( "filter_cbpaidplan{$option}", 'filter_cbpaidplan', 0 );
			$this->filter_cbpaidsubstate	=	$_CB_framework->getUserStateFromRequest( "filter_cbpaidsubstate{$option}", 'filter_cbpaidsubstate', 'A' );
			if ( ! in_array( $this->filter_cbpaidsubstate, array( 'A', 'X', 'C', 'U' ) ) ) {
				$this->filter_cbpaidsubstate	=	'A';
			}
			$this->filter_cbpaidsubexpdate	=	$_CB_framework->getUserStateFromRequest( "filter_cbpaidsubexpdate{$option}", 'filter_cbpaidsubexpdate', '' );
			if ( ! preg_match( '/^(|-?\d+ (DAY|WEEK|MONTH))$/', $this->filter_cbpaidsubexpdate ) ) {
				$this->filter_cbpaidsubexpdate	=	'';
			}

			if ( ( $this->filter_cbpaidplan )
				&& ( ( $this->filter_cbpaidplan == -2 )
					|| ( ( in_array( $this->filter_cbpaidsubstate, array( 'A', 'X', 'C', 'U' ) ) )
						&& preg_match( '/^(|-?\d+ (DAY|WEEK|MONTH))$/', $this->filter_cbpaidsubexpdate )
			) ) ) {
				if ( $this->filter_cbpaidsubexpdate ) {
					if ( $this->filter_cbpaidsubexpdate[0] == '-' ) {
						$andExpDate		=	' AND subs.expiry_date > date_sub(UTC_TIMESTAMP(), INTERVAL ' . substr( $this->filter_cbpaidsubexpdate, 1 ) . ')';
					} else {
						$andExpDate		=	' AND subs.expiry_date < date_add(UTC_TIMESTAMP(), INTERVAL ' . $this->filter_cbpaidsubexpdate . ')';
					}
				} else {
					$andExpDate			=	'';
				}

				if ( $this->filter_cbpaidplan == -1 ) {
					// any plan:
					$joinsSQL[]			=	'INNER JOIN #__cbsubs_subscriptions AS subs ON (subs.user_id = u.id AND subs.status =' . $_CB_database->Quote( $this->filter_cbpaidsubstate )
										.	$andExpDate
										.	')';
				} elseif ( $this->filter_cbpaidplan == -2 ) {
					// no plan:
					$joinsSQL[]			=	"LEFT JOIN #__cbsubs_subscriptions AS subs ON (subs.user_id = u.id AND subs.status ='A')";
					$tablesWhereSQL[]	=	"subs.plan_id IS NULL";
				} else {
					// specific plan:
					$joinsSQL[]			=	'INNER JOIN #__cbsubs_subscriptions AS subs ON (subs.user_id = u.id AND subs.status =' . $_CB_database->Quote( $this->filter_cbpaidsubstate )
										.	' AND subs.plan_id = ' . (int) $this->filter_cbpaidplan
										.	$andExpDate
										.	')';
				}
			}

		}
	}

	/**
	 * Intercepts CB User Manager list Viewer to add filters
	 *
	 * @param  int        $listId
	 * @param  UserTable  $rows
	 * @param  cbPageNav  $pageNav
	 * @param  string     $search
	 * @param  string[]   $lists
	 * @param  string     $option
	 * @param  string     $select_tag_attribs
	 * @return array
	 */
	public function onAfterBackendUsersList( /** @noinspection PhpUnusedParameterInspection */ $listId, &$rows, /** @noinspection PhpUnusedParameterInspection */ &$pageNav, /** @noinspection PhpUnusedParameterInspection */ &$search, &$lists, /** @noinspection PhpUnusedParameterInspection */ $option, $select_tag_attribs ) {
		if ( ! cbpaidApp::authoriseAction( 'cbsubs.usersubscriptionview' ) ) {
			return array();
		}

		$this->outputRegTemplate();

		// 1. Filters:
		// 1.a. prepare dropdown selector filter with the list of published plans:
		$plansMgr					=	cbpaidPlansMgr::getInstance();
		$plans						=	$plansMgr->loadPublishedPlans( CBuser::getMyUserDataInstance(), true, 'any', null );

		$plansList					=	array();
		$plansList[]				=	moscomprofilerHTML::makeOption( 0, CBTxt::T('- Select Subscription Plan - ') );

		foreach ( $plans as $k => $plan ) {
			$plansList[]			=	moscomprofilerHTML::makeOption( $k, $plan->get( 'alias' ) );
		}
		if ( count( $plans ) > 0 ) {
			$plansList[]			=	moscomprofilerHTML::makeOption( -1, CBTxt::T('ANY PLAN ACTIVE') );
			$plansList[]			=	moscomprofilerHTML::makeOption( -2, CBTxt::T('NO PLAN ACTIVE') );
		}
		$lists['cbpaidplan']		=	moscomprofilerHTML::selectList( $plansList, 'filter_cbpaidplan', $select_tag_attribs, 'value', 'text', $this->filter_cbpaidplan, 2 );

		// 1.b. prepare additional selector filter for status of subscriptions:
		if ( $this->filter_cbpaidplan && ( $this->filter_cbpaidplan != -2 ) ) {
			// any plan or specific plan:		// no plan: nothing for now to do
			$statesList				=	array();
			$statesList[]			=	moscomprofilerHTML::makeOption( 'A', CBTxt::T('Active') );
			$statesList[]			=	moscomprofilerHTML::makeOption( 'X', CBTxt::T('Expired') );
			$statesList[]			=	moscomprofilerHTML::makeOption( 'C', CBTxt::T('Cancelled') );
			$statesList[]			=	moscomprofilerHTML::makeOption( 'U', CBTxt::T('Upgraded') );
			$lists['cbpaidsubstate'] =	moscomprofilerHTML::selectList( $statesList, 'filter_cbpaidsubstate', $select_tag_attribs, 'value', 'text', $this->filter_cbpaidsubstate, 1 );

			$datesList				=	array();
			$datesList[]			=	moscomprofilerHTML::makeOption( '', CBTxt::T('- Select expiry date -') );
			if ( $this->filter_cbpaidsubstate == 'A' ) {
				$datesList[]		=	moscomprofilerHTML::makeOption( '1 DAY', sprintf( CBTxt::T('Expiring within %s hours'), 24 ) );
				foreach ( array( 2, 3, 4, 5, 6, 7 ) as $v ) {
					$datesList[]	=	moscomprofilerHTML::makeOption( $v . ' DAY', sprintf( CBTxt::T('Expiring within %s days'), $v ) );
				}
				foreach ( array( 2, 3, 4 ) as $v ) {
					$datesList[]	=	moscomprofilerHTML::makeOption( $v . ' WEEK', sprintf( CBTxt::T('Expiring within %s weeks'), $v ) );
				}
				$datesList[]		=	moscomprofilerHTML::makeOption( '1 MONTH', CBTxt::T('Expiring within in 1 month') );
				foreach ( array( 2, 3, 4, 6, 9, 12 ) as $v ) {
					$datesList[]	=	moscomprofilerHTML::makeOption( $v . ' MONTH', sprintf( CBTxt::T('Expiring within %s months'), $v ) );
				}
			} else {
				$datesList[]		=	moscomprofilerHTML::makeOption( '-1 DAY', sprintf( CBTxt::T('Expired last %s hours'), 24 ) );
				foreach ( array( 2, 3, 4, 5, 6, 7 ) as $v ) {
					$datesList[]	=	moscomprofilerHTML::makeOption( '-' . $v . ' DAY', sprintf( CBTxt::T('Expired last %s days'), $v ) );
				}
				foreach ( array( 2, 3, 4 ) as $v ) {
					$datesList[]	=	moscomprofilerHTML::makeOption( '-' . $v . ' WEEK', sprintf( CBTxt::T('Expired last %s weeks'), $v ) );
				}
				$datesList[]		=	moscomprofilerHTML::makeOption( '-1 MONTH', CBTxt::T('Expired last month') );
				foreach ( array( 2, 3, 4, 6, 9, 12 ) as $v ) {
					$datesList[]	=	moscomprofilerHTML::makeOption( '-' . $v . ' MONTH', sprintf( CBTxt::T('Expired last %s months'), $v ) );
				}
			}
			$lists['cbpaidsubexpdate'] =	moscomprofilerHTML::selectList( $datesList, 'filter_cbpaidsubexpdate', $select_tag_attribs, 'value', 'text', $this->filter_cbpaidsubexpdate, 1 );
		}

		// 2. add subscriptions colum to backend users-lists:
		$pluginColumns				=	array();
		foreach ( $rows as $row ) {
			$paidUserExtension		=	cbpaidUserExtension::getInstance( (int) $row->id );
			$subscriptions			=	$paidUserExtension->getUserSubscriptions( 'A', true );
			$displayPlans			=	array();
			foreach ( $subscriptions as $sub ) {
				$plan				=	$sub->getPlan();
				if ( $plan ) {
					$cssclass		=	$plan->get( 'cssclass' );
					$aliasHtml		=	htmlspecialchars( $plan->get( 'alias' ) );
				} else {
					$cssclass		=	null;
					$aliasHtml		=	CBTxt::Th("PLAN OF SUBSCRIPTION ID [SUB_ID] IS DELETED", null, array( '[SUB_ID]' => $sub->id ) );
				}
				$displayPlans[]		=	'<span' . ( $cssclass ? ' class="' . htmlspecialchars( $cssclass ) . '"' : '' ) . '>'
									.	$aliasHtml
									.	'</span>'
									;
			}
			$pluginColumns[$row->id]	=	implode( ', ', $displayPlans );
		}
		return array( CBTxt::T('Subscriptions') =>	$pluginColumns );
	}
	/**
	 * Called just before showing the form to send email to users, allowing to add lines to the form
	 *
	 * param  array      $rows
	 * param  cbPageNav  $pageNav
	 * param  string     $search
	 * param  array      $lists
	 * param  array      $cid
	 * param  string     $emailSubject
	 * param  string     $emailBody
	 * param  string     $inputTextExtras
	 * param  string     $select_tag_attribs
	 * param  boolean    $simulationMode
	 * param  string     $option
	 * @return array      of 'title' => 'row' html code for lines to display in form
	 */
	public function onBeforeBackendUsersEmailForm( /* &$rows, &$pageNav, &$search, &$lists, &$cid, &$emailSubject, &$emailBody, &$inputTextExtras, &$select_tag_attribs, $simulationMode, $option */ ) {
		$lines			=	array();
		if ( cbpaidApp::authoriseAction( 'cbsubs.usersubscriptionview' ) ) {
			if ( $this->filter_cbpaidplan > 0 ) {
				$plansMgr	=	cbpaidPlansMgr::getInstance();
				$plan		=	$plansMgr->loadPlan( (int) $this->filter_cbpaidplan );
				$lines[CBTxt::Th('Selected plan')]	=	CBTxt::Th($plan->name);
				$lines[CBTxt::Th('More substitutions with the selected plan')]	=	'[subscription_start_date], '
				.	( $plan->isProductWithExpiration() ? '[subscription_end_date], ' : '' )
				.	'[subscription_lastrenew_date]';
			}
		}
		return $lines;
	}
	/**
	 * Called just before starting to send email to users, allowing to get the posts of the previous email form and to add lines to the form
	 *
	 * @param  array      $rows
	 * @param  int        $total
	 * @param  string     $search
	 * @param  array      $lists
	 * @param  array      $cid
	 * @param  string     $emailSubject
	 * @param  string     $emailBody
	 * @param  string     $inputTextExtras
	 * @param  boolean    $simulationMode
	 * @param  string     $option
	 * @return array      of 'title' => 'row' html code for lines to display in sending screen
	public function onBeforeBackendUsersEmailStart( &$rows, $total, $search, $lists, $cid, &$emailSubject, &$emailBody, &$inputTextExtras, $simulationMode, $option ) {
	}
	 */
	/**
	 * Called just before emailing each user from CB Users management backend
	 *
	 * @param  UserTable  $user
	 * @param  string     $emailSubject
	 * @param  string     $emailBody
	 * @param  int        $mode
	 * @param  array      $extraStrings    Entries can be filled in this function and will be used to email
	 * @param  boolean    $simulationMode
	 */
	public function onBeforeBackendUserEmail( &$user, /** @noinspection PhpUnusedParameterInspection */ &$emailSubject, /** @noinspection PhpUnusedParameterInspection */ &$emailBody, /** @noinspection PhpUnusedParameterInspection */ $mode, &$extraStrings, /** @noinspection PhpUnusedParameterInspection */ $simulationMode ) {
		if ( cbpaidApp::authoriseAction( 'cbsubs.usersubscriptionview' ) ) {
			if ( $this->filter_cbpaidplan > 0 ) {
				$plansMgr	=	cbpaidPlansMgr::getInstance();
				$plan		=	$plansMgr->loadPlan( (int) $this->filter_cbpaidplan );
				$sub		=	$plan->loadLatestSomethingOfUser( $user->id, $this->filter_cbpaidsubstate );

				$extraStrings['subscription_start_date']		=	( $sub ? cbpaidTimes::getInstance()->cbFormatDateInOfficialTz( $sub->getSubscriptionDate() ) : CBTxt::T('No subscription') );

				if ( $plan->isProductWithExpiration() ) {
					if ( $sub ) {
						$extraStrings['subscription_end_date']	=	$sub->getFormattedExpirationDateText();
					} else {
						$extraStrings['subscription_end_date']	=	CBTxt::T('No subscription');
					}
				}

				$extraStrings['subscription_lastrenew_date']	=	( $sub ? cbpaidTimes::getInstance()->cbFormatDateInOfficialTz( $sub->getLastRenewDate() ) : CBTxt::T('No subscription') );
			}
		}
	}
}

/**
 * Model Class for implementing Refunds
 */
class cbpaidPaymentManualRefund extends cbpaidPayment {
	public $refund_gross;
	public $refund_is_last;
	public $refund_reason;

	/**
	 * If table key (id) is NULL : inserts a new row
	 * otherwise updates existing row in the database table
	 *
	 * Can be overridden or overloaded by the child class
	 *
	 * @param  boolean  $updateNulls  TRUE: null object variables are also updated, FALSE: not.
	 * @return boolean                TRUE if successful otherwise FALSE
	 */
	public function store( $updateNulls = false ) {
		if ( ! cbpaidApp::authoriseAction( 'cbsubs.refunds' ) ) {
			$this->setError( CBTxt::T("Not authorized") );
			return false;
		}

		// 1) check:
		if ( ! in_array( $this->payment_status, array( 'Completed', 'Pending', 'Partially-Refunded' ) ) ) {
			$this->setError( CBTxt::T("This payment is not completed, pending or partially refunded.") );
			return false;
		}
		if ( $this->txn_id == '' ) {
			$this->txn_id			=	'None';		// needed for updatePayment to generate payment record.
		}

		$payment					=	new cbpaidPayment();
		if ( ! $payment->load( (int) $this->id ) ) {
			$this->setError( CBTxt::T("This payment does not exist.") );
			return false;
		}
		$paymentBasket				=	new cbpaidPaymentBasket();
		if ( ! $paymentBasket->load( $this->payment_basket_id ) ) {
			$this->setError( CBTxt::T("This payment has no associated payment basket and cannot be refunded from here. Maybe from your PSP online terminal ?") );
			return false;

		}

		if ( ! $this->gateway_account ) {
			$this->setError( CBTxt::T("This payment has no gateway associated so can not be refunded.") );
			return false;
		}

		$payAccount					=	cbpaidControllerPaychoices::getInstance()->getPayAccount( $this->gateway_account );
		if ( ! $payAccount ) {
			$this->setError( CBTxt::T("This payment's payment basket's associated gateway account is not active, so can not be refunded from here.") );
			return false;
		}
		$payClass					=	$payAccount->getPayMean();
		$returnText					=	null;
		$amount						=	sprintf( '%.2f', (float) $this->refund_gross );
		if ( is_callable( array( $payClass, 'refundPayment' ) ) ) {
			$success				=	$payClass->refundPayment( $paymentBasket, $payment, null, $this->refund_is_last, $amount, $this->refund_reason, $returnText );
		} else {
			$success				=	false;
		}

		$user						=	CBuser::getUserDataInstance( $paymentBasket->user_id );
		$username					=	$user ? $user->username : '?';
		$replacements				=	array( '[REFUNDAMOUNT]'		=>	$payment->mc_currency . ' ' . $amount,
												'[PAYMENTID]'		=>	$payment->id,
												'[PAYMENTAMOUNT]'	=>	$payment->mc_currency . ' ' . $payment->mc_gross,
												'[BASKETID]'		=>	$paymentBasket->id,
												'[ORDERID]'			=>	$paymentBasket->sale_id,
												'[FULLNAME]'		=>	$paymentBasket->first_name . ' ' . $paymentBasket->last_name,
												'[USERNAME]'		=>	$username,
												'[USERID]'			=>	$paymentBasket->user_id,
												'[PAYMENTMETHOD]'	=>	$payClass->getPayName(),
												'[TXNID]'			=>	$payment->txn_id,
												'[AUTHID]'			=>	$payment->auth_id,
												'[ERRORREASON]'		=>	$paymentBasket->reason_code );
		if ( $success ) {
			// Success Message ?
			// $returnText	=	CBTxt::T("Refunded [REFUNDAMOUNT] for payment id [PAYMENTID] of [PAYMENTAMOUNT] for basket id [BASKETID], Order id [ORDERID] of [FULLNAME] (username [USERNAME] - user id [USERID]) using [PAYMENTMETHOD] with txn_id [TXNID] and auth_id [AUTHID].", null, $replacements );
		} else {
			$this->setError( CBTxt::T( $payClass->getErrorMSG() ) . '. '
						   . CBTxt::T("Refund request of [REFUNDAMOUNT] for payment id [PAYMENTID] of [PAYMENTAMOUNT] for basket id [BASKETID], Order id [ORDERID] of [FULLNAME] (username [USERNAME] - user id [USERID]) using [PAYMENTMETHOD] with txn_id [TXNID] and auth_id [AUTHID] failed for reason: [ERRORREASON].", null, $replacements )
							);
			return false;
		}
		return true;
	}
}

/**
 * Administration menus handler class, probably obsolete
 */
class cbpaidsubscriptionsAdmin {
	/**
	 * This function is typically called with a plugin with menus: these must be declared with:
	 * 	<adminmenus>
	 * 		<menu action="import">Import subscriptions</menu>
	 * 	</adminmenus>
	 *
	 * @param  PluginTable               $plugin   plugin db object
	 * @param  string                    $menu     &menu=.... the value part of the URL
	 * @param  cbParamsEditorController  $params   plugin parameters
	 * @return string                              HTML to display
	 */
	public function menu( /** @noinspection PhpUnusedParameterInspection */ $plugin, $menu, $params ) {
		switch ( $menu ) {
			case 'ajversion':
				return $this->ajversion();
			case 'curconvcheck':
				return $this->currencyconvertercheck();
			default:
				break;
		}
		return null;
	}
	/**
	 * Called upon
	 * administrator/index3.php?option=com_comprofiler&view=pluginmenu&cid=566&menu=ajversion&no_html=1&format=raw
	 *
	 * @return string HTML
	 */
	protected function ajversion() {
		global $_GET;

		if ( $_GET['mode'] == 'updatesonly' ) {
			$silent		=	true;
		} else {
			$silent		=	false;
		}

		include_once( dirname( __FILE__ ) . '/cbpaidsubscriptions.php' );

		return cbpaidVersionMgr::latestVersion( $silent );
	}
	/**
	 * Called upon
	 * administrator/index3.php?option=com_comprofiler&view=pluginmenu&cid=566&menu=curconvcheck&no_html=1&format=raw
	 *
	 * @return string HTML
	 */
	protected function currencyconvertercheck()
	{
		$ret						=	null;

		$params						=	cbpaidApp::settingsParams();
		$textSecondaryCurrency		=	$params->get( 'secondary_currency_code' );

		if ( $textSecondaryCurrency ) {
			$_CBPAY_CURRENCIES		=	cbpaidApp::getCurrenciesConverter();
			$secondaryPrice    		=	$_CBPAY_CURRENCIES->convertCurrency( 'EUR', 'USD', 1.0 );
			if ( $secondaryPrice === null ) {
				$ret				=	'<div class="text-danger font-weight-bold cbDisabled">' . $_CBPAY_CURRENCIES->getError() . '</div>';
			}
		}
		return $ret;
	}
}	// class cbsubscriptionsAdmin
