<?php
/**
* @version $Id: cbpaidsubscriptions.install.php 1610 2013-01-09 23:29:17Z brunner $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Plugin for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Database\Table\Table;
use CBLib\Registry\Registry;
use CBLib\Registry\GetterInterface;

/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * Installs CBSubs, final part (ECHOs banners)
 *
 * @return void
 */
function plug_cbpaidsubscriptions_install(){
	global $_CB_framework, $_CB_database;
	
	$installedVersion	=	'4.6.1+build.2023.03.27.21.31.22.c7790254e';		//CBSUBS_VERSION_AUTOMATICALLY_SET_DO_NOT_EDIT!!!
	
?>
<div style="width:100%;text-align:center">

	<div>
		<img alt="CBSubs Logo" height="300" width="300" src="<?php echo $_CB_framework->getCfg( 'live_site' ); ?>/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/normal/cbsubs_logo_300.jpg" />
	</div>
	<h1>CBSubs <?php echo $installedVersion; ?></h1>
    <p><strong>Copyright &copy; 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved</strong></p>
    <p><strong>CBSubs is a Trademark of Lightning MultiCom SA, Switzerland, and its licensors. CB, Community Builder and Joomlapolis are also a trademark of joomlapolis.com and may not be used without permission from the trademark holders.</strong></p>
    <p>The copyright holders have spent massive time on this software and are continuing to improve it. A corresponding membership at Joomlapolis.com is required for ongoing maintenance and support.</p>
    <p>All copyright statements must be kept.</p> 
    <p><em>Official site: <a href="http://www.joomlapolis.com?pk_campaign=in-cb&amp;pk_kwd=installed-cbsubs">www.joomlapolis.com</a></em></p>
		
</div>

<?php 

	// Fix permissions asset from com_cbsubs to com_comprofiler.plugin.cbsubs:

	$sql	=	"UPDATE " . $_CB_database->NameQuote( '#__assets' )
			.	" SET " . $_CB_database->NameQuote( 'name' ) . " = " . $_CB_database->Quote( 'com_comprofiler.plugin.cbsubs' )
			.	" WHERE " . $_CB_database->NameQuote( 'name' ) . " = " . $_CB_database->Quote( 'com_cbsubs' );
	$_CB_database->setQuery( $sql );
	$_CB_database->query();

	// Temporary fix in CBSubs 1.2.2 only for CBSubs 1.2.1 bug:

	if ( ( checkJversion() >= 1 ) && ( $installedVersion == '1.2.2' ) ) {

		$sql	=	"UPDATE #__users"
				.	" SET password = concat(md5(concat(password,'12345678901234567890123456789012')),':','12345678901234567890123456789012')"
				.	" WHERE ( LENGTH(password) < 65 )"
				.	" AND ( LENGTH(password) > 3 )"
				.	" AND ( registerDate > '2011-07-13 12:00:00' )";
		$_CB_database->setQuery( $sql );
		$_CB_database->query();
	}

	// Temporary fix in CBSubs 1.3.0 for CBSubs 1.2.x bug:

	// Ogone gateway was not transfering address from basket:
	$sql		=	'UPDATE #__cbsubs_payments p'
				.	' LEFT JOIN #__cbsubs_payment_baskets b ON p.payment_basket_id = b.id'
				.	' SET '
				.	' p.`address_street` = b.`address_street`,'
				.	' p.`address_city` = b.`address_city`,'
				.	' p.`address_state` = b.`address_state`,'
				.	' p.`address_zip` = b.`address_zip`,'
				.	' p.`address_country` = b.`address_country`,'
				.	' p.`address_country_code` = b.`address_country_code`,'
				.	' p.`payer_business_name` = b.`payer_business_name`,'
				.	' p.`payer_email` = b.`payer_email`,'
				.	' p.`contact_phone` = b.`contact_phone`,'
				.	' p.`vat_number` = b.`vat_number`'
				.	" WHERE p.payment_method IN ('ogone','swisspostfinance')"
				.	' AND ISNULL(p.`address_country_code`);';
	$_CB_database->setQuery( $sql );
	$_CB_database->query();

	cbimport( 'cb.adminfilesystem' );
	$adminFS	=	cbAdminFileSystem::getInstance();
	$cbsubsDir	=	$_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions';

	// Remove old 2Checkout files if there is no 2Checkout gateway configured, as TwoCheckout is not part anymore in CBSubs 1.3:
	$sql		=	'SELECT COUNT(*) FROM #__cbsubs_gateway_accounts'
				.	' WHERE gateway_type = "processors.twocheckout";';
	$_CB_database->setQuery( $sql );
	$hasTwoCheckoutInstalled	=	$_CB_database->loadResult();
	$twocheckoutdir				=	$cbsubsDir . '/processors/twocheckout';
	if ( ( $hasTwoCheckoutInstalled == 0 ) && file_exists( $twocheckoutdir ) ) {
		$adminFS->deldir( $twocheckoutdir . '/' );
	}

	// Remove old 1.x and 2.x files:
	$oldfiles	=	array(	'admin.cbpaidsubscriptions.ctrl.php',
							'cbpaidsubscriptions.condition.php',
							'cbpaidsubscriptions.countries.php',
							'cbpaidsubscriptions.crosstotalizer.php',
							'cbpaidsubscriptions.ctrl.php',
							'cbpaidsubscriptions.currency.php',
							'cbpaidsubscriptions.gui.php',
							'cbpaidsubscriptions.guisubs.php',
							'cbpaidsubscriptions.importer.php',
							'cbpaidsubscriptions.scheduler.php',
							'cbpaidsubscriptions.sql.php',
							'cbpaidsubscriptions.userparams.php'
						 );
	foreach( $oldfiles as $file ) {
		$pathFile	=	$cbsubsDir . '/' . $file;
		if ( $file && file_exists( $pathFile ) ) {
			$adminFS->unlink( $pathFile );
		}
	}

	// Map old card type images to new:
	$cardImages				=	array(	'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_3d_paypal.png'					=>	'paypal',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_3d_swisspostfinance.png'		=>	'swisspostfinance',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_3d_twocheckout.png'				=>	'twocheckout',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_paypal.gif'					=>	'paypal',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_paypal_paynow.gif'			=>	'paypal_pay',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_paypal_subscribe.gif'		=>	'paypal_subscribe',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_stripe.gif'					=>	'stripe',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_visa_mc_pay.gif'			=>	'visa_mc_pay',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_visa_mc_subscribe.gif'		=>	'visa_mc_subscribe',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_visa_mc_amex_pay.gif'		=>	'visa_mc_amex_pay',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_visa_mc_am_subscribe.gif'	=>	'visa_mc_amex_subscribe',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_visa_mc_postfinance.gif'	=>	'visa_mc_postfinance_pay',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_orange_pay_now.gif'			=>	'cc_big_orange_pay_now',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_orange_pay_now.gif'				=>	'cc_orange_pay_now',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_orange_buy_now.gif'			=>	'cc_big_orange_buy_now',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_orange_buy_now.gif'				=>	'cc_orange_buy_now',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_orange_subscribe.gif'		=>	'cc_big_orange_subscribe',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_orange_subscribe.gif'			=>	'cc_orange_subscribe',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_orange_click_subscribe.gif'		=>	'cc_orange_click_subscribe',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_orange_free_trial.gif'			=>	'cc_orange_free_trial',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_swisspostfinance.gif'		=>	'swisspostfinance',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_free_trial.gif'				=>	'free_trial',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_confirm_order.gif'			=>	'confirm_order',
										'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/icons/cards/cc_big_offline.gif'				=>	'offline',
										'https://www.paypal.com/en_US/i/bnr/horizontal_solution_PPeCheck.gif'											=>	'https://www.paypalobjects.com/webstatic/mktg/logo/AM_mc_vs_dc_ae.jpg',
										'/processors/twocheckout/icons/horizontal_tiny_2co.jpg'															=>	'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/processors/twocheckout/icons/horizontal_tiny_2co.jpg',
										'/processors/skrill/images/plain-four-versions-rgb_168x45.gif'													=>	'components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/processors/skrill/images/plain-four-versions-rgb_168x45.gif'
									);

	// What parameters to check for outdated card images:
	$cardImageParams			=	array( 'image', 'subscribe_image', 'offline_image', 'card_checkout_image', 'single_radio_cardtypes', 'paypal_image', 'paypal_subscribe_image', 'twocheckout_image', 'twocheckout_subscribe_image' );

	// Check gateways for any param migrations:
	$query						=	'SELECT *'
								.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_gateway_accounts' );
	$_CB_database->setQuery( $query );
	$gateways					=	$_CB_database->loadObjectList( null, '\CBLib\Database\Table\Table', array( $_CB_database, '#__cbsubs_gateway_accounts', 'id' ) );

	/** @var $gateways Table[] */
	foreach ( $gateways as $gateway ) {
		$gatewayParams			=	new Registry( $gateway->params );
		$gatewayMigrated		=	false;

		foreach ( $cardImageParams as $cardImageParam ) {
			if ( ! $gatewayParams->has( $cardImageParam ) ) {
				continue;
			}

			$gatewayCardImg		=	$gatewayParams->get( $cardImageParam, null, GetterInterface::STRING );

			if ( ! $gatewayCardImg ) {
				continue;
			}

			if ( ! isset( $cardImages[$gatewayCardImg] ) ) {
				continue;
			}

			$gatewayParams->set( $cardImageParam, $cardImages[$gatewayCardImg] );

			$gatewayMigrated	=	true;
		}

		// STRIPE: Migrate old cardtypes param to card_element_recurring_filter_methods
		if ( $gateway->getString( 'gateway_type', '' ) === 'processors.stripe' ) {
			$cardtypes					=	$gatewayParams->getRaw( 'cardtypes', [] );

			if ( $cardtypes ) {
				if ( ! is_array( $cardtypes ) ) {
					$cardtypes			=	explode( '|*|', $cardtypes );
				}

				$methods				=	[];

				foreach ( $cardtypes as $cardtype ) {
					if ( in_array( $cardtype, [ 'visa', 'mastercard', 'amexco', 'discover', 'diners', 'jcb' ], true ) ) {
						$methods[]		=	'card';
					} elseif ( in_array( $cardtype, [ 'au_becs_debit', 'bancontact', 'ideal', 'sofort' ], true ) ) {
						$methods[]		=	$cardtype;
					} elseif ( $cardtype === 'sepa' ) {
						$methods[]		=	'sepa_debit';
					} elseif ( $cardtype === 'ach_debit' ) {
						$methods[]		=	'us_bank_account';
					}
				}

				if ( $methods ) {
					// This is the only parameter that requires methods to be selected as setup intents can't automate their types for now
					$gatewayParams->set( 'card_element_recurring_filter_methods', array_unique( $methods ) );
				}

				$gatewayParams->unsetEntry( 'cardtypes' );

				$gatewayMigrated		=	true;
			}
		}

		if ( $gatewayMigrated ) {
			$gateway->set( 'params', $gatewayParams->asJson() );

			$gateway->store();
		}
	}

	// What global parameters to check for outdated card images:
	$configCardImgParams		=	array( 'paybutton_single_image', 'paybutton_subscribe_image', 'order_image', 'freetrial_image' );

	// Check global config for any param migrations:
	$query						=	'SELECT *'
								.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_config' )
								.	"\n WHERE " . $_CB_database->NameQuote( 'type' ) . " = " . $_CB_database->Quote( 'config' );
	$_CB_database->setQuery( $query, 0, 1 );
	$config						=	new Table( null, '#__cbsubs_config', 'id' );

	foreach ( $_CB_database->loadAssoc() as $k => $v ) {
		$config->set( $k, $v );
	}

	if ( $config->get( 'id', 0, GetterInterface::INT ) ) {
		$configParams			=	new Registry( $config->params );
		$configMigrate			=	false;

		foreach ( $configCardImgParams as $configCardImgParam ) {
			if ( ! $configParams->has( $configCardImgParam ) ) {
				continue;
			}

			$configCardImg		=	$configParams->get( $configCardImgParam, null, GetterInterface::STRING );

			if ( ! $configCardImg ) {
				continue;
			}

			if ( ! isset( $cardImages[$configCardImg] ) ) {
				continue;
			}

			$configParams->set( $configCardImgParam, $cardImages[$configCardImg] );

			$configMigrate		=	true;
		}

		if ( $configMigrate ) {
			$config->set( 'params', $configParams->asJson() );

			$config->store();
		}
	}
}
