<?php
/**
 * @version $Id: cbpaidControllerOffer.php 1607 2012-12-29 02:47:22Z beat $
 * @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
 * @subpackage Plugin for Paid Subscriptions
 * @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CBLib\Registry\GetterInterface;
use CBLib\Language\CBTxt;

/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * CBSubs Offers Controller
 */
class cbpaidControllerOffer {
	/**
	 * Displays specific plans
	 *
	 * @param  int[]|null   $plans
	 * @param  int[]|null   $plansToPreselect
	 * @param  UserTable    $user
	 * @param  string       $introText
	 * @return null|string
	 */
	public static function displaySpecificPlans( $plans, $plansToPreselect, $user, $introText ) {
		global $_CB_framework, $_PLUGINS, $ueConfig;
		$return									=	'';

		$isGuest								=	( ( $user === null ) || ( $user->get( 'id', 0, GetterInterface::INT ) === 0 ) );
		$subscriptionsGUI						=	new cbpaidControllerUI();

		if ( is_array( $plans ) &&  count( $plans ) == 0 ) {
			$return								.=	'<div class="alert alert-info">' . CBTxt::Th( 'UE_NOT_AUTHORIZED', 'You are not authorized to view this page!' ) . ( $isGuest ? ' ' . CBTxt::Th( 'UE_DO_LOGIN', 'You need to log in.' ) : '' ) . '</div>';
		} else {
			$subscriptionsGUI->setShowOnlyPlans( $plans );
			$subscriptionsGUI->setSelectedPlans( $plansToPreselect );
			if ( $isGuest ) {
				// Show registration form:
				if ( ( ( $_CB_framework->getCfg( 'allowUserRegistration' ) == '0' )
					&& ( ( ! isset($ueConfig['reg_admin_allowcbregistration']) ) || $ueConfig['reg_admin_allowcbregistration'] != '1' ) ) )
				{
					cbNotAuth();
					return null;
				}
				if ( Application::MyUser()->getUserId() ) {
					$return						.=	'<div class="alert alert-danger">' . CBTxt::Th( 'UE_ALREADY_LOGGED_IN', 'You are already logged in' ) . '</div>';
					return self::displayWithTemplate( $return );
				}
				$fieldsQuery					=	null;

				$_PLUGINS->loadPluginGroup( 'user' );
				$_PLUGINS->loadPluginGroup('user/plug_cbpaidsubscriptions/plugin');
				$regErrorMSG					=	null;
				$results						=	$_PLUGINS->trigger( 'onBeforeRegisterForm', array( 'com_comprofiler', isset( $ueConfig['emailpass'] ) ? $ueConfig['emailpass'] : '0', &$regErrorMSG, $fieldsQuery ) );
				if( $_PLUGINS->is_errors() ) {
					$return						.=	"<script type=\"text/javascript\">alert('".addslashes($_PLUGINS->getErrorMSG(" ; "))."'); </script>\n";
					$return						.=	$_PLUGINS->getErrorMSG("<br />");
					return self::displayWithTemplate( $return );
				}
				if ( implode( '', $results ) != "" ) {
					$allResults					=	implode( "</div><div>", $results );
					$return						.=	"<div>" . $allResults . "</div>";
					return self::displayWithTemplate( $return );
				}

				$loginOrRegister				=	CBTxt::Th( cbpaidApp::settingsParams()->get( 'plansLoginOrRegisterText', "If you already have an account, please login first. Otherwise you need to register using this form." ) );

				$userComplete					=	new UserTable();
				$option							=	'com_comprofiler';
				$emailpass						=	isset( $ueConfig['emailpass'] ) ? $ueConfig['emailpass'] : '0';
				$regErrorMSG					=	$loginOrRegister . ' ' . $introText;
				ob_start();
				$null							=	null;
				HTML_comprofiler::registerForm( $option, $emailpass, $userComplete, $null, $regErrorMSG, true, 'message' );
				$return							.=	ob_get_contents();
				ob_end_clean();

			} else {
				// User logged in: Show upgrade form:
				$itsmyself						=	true;

				$params							=	cbpaidApp::settingsParams();
				$subTxt							=	CBTxt::T( $params->get( 'subscriptions_name', 'subscriptions' ) );

				$title							=	ucfirst( $subTxt );
				if ( $title ) {
					$return						.=	'<div class="mb-3 border-bottom cb-page-header" id="cbregProfileTitle"><h3 class="m-0 p-0 mb-2 cb-page-header-title">' . $title . '</h3></div>';
				}
				if ( $introText ) {
					$return						.=	'<div class="cbregProfileIntro">' . $introText . '</div>';
				}
				$return							.=	$subscriptionsGUI->getShowSubscriptionUpgrades( $user, $itsmyself );
			}
			$subscriptionsGUI->setShowOnlyPlans ( null );
		}
		return self::displayWithTemplate( $return );
	}
	/**
	 * Displays $text inside a standard CB div, and sets page title and pathway too
	 *
	 * @param  string  $text
	 * @return string
	 */
	public static function displayWithTemplate( $text ) {
		global $_CB_framework;

		$regTitle							=	strip_tags( CBTxt::T( cbpaidApp::settingsParams()->get( 'regTitle' ) ) );
		outputCbTemplate();
		$_CB_framework->setPageTitle( $regTitle );
		$_CB_framework->appendPathWay( $regTitle );
		$pre								=	'<div class="cbPageOuter"><div class="cbPageInner" id="cbregField">';
		$post								=	'</div></div><div class="clearfix"> </div>';
		return $pre . $text . $post;
	}
}