<?php
/**
 * @version $Id: cbpaidConfig.php 1541 2012-11-23 22:21:52Z beat $
 * @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
 * @subpackage Plugin for Paid Subscriptions
 * @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Database\DatabaseDriverInterface;

/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/**
 * CB paid subscriptions configuration (in sql table)
 *
 */
class cbpaidConfig extends cbpaidTable
{
	public $id;
	public $user_id;
	public $type;
	public $last_updated_date;
	public $sequencenumber			=	0;
	public $params;

	/**
	 * Constructor
	 *
	 * @param DatabaseDriverInterface  $db     CB Database object
	 */
	public function __construct( &$db = null )
	{
		parent::__construct( '#__cbsubs_config', 'id', $db );
		$this->_historySetLogger();
	}

	/**
	 * Removes history logging which is on by default
	 */
	public function noHistoryLogger( )
	{
		$this->_historySetLogger( null );
	}
}
