<?php
/**
* CBSubs (TM): Community Builder Paid Subscriptions Plugin: cbsubscbfield
* @version $Id: cbsubs.cbfield.php 1583 2012-12-24 02:48:46Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage cbsubs.cbfield.php
* @author Beat
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\FieldTable;
use CB\Database\Table\UserTable;
use CBLib\Registry\ParamsInterface;
use CBLib\Registry\GetterInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->registerFunction( 'onCPayUserStateChange', 'onCPayUserStateChange', 'getcbsubscbfieldTab' );

class getcbsubscbfieldTab extends cbTabHandler
{

	/**
	 * @param int $fieldId
	 * @return FieldTable
	 */
	protected function getField( $fieldId )
	{
		if ( ! $fieldId ) {
			return new FieldTable();
		}

		static $cache			=	array();

		if ( ! isset( $cache[$fieldId] ) ) {
			$field				=	new FieldTable();

			$field->load( (int) $fieldId );

			$cache[$fieldId]	=	$field;
		}

		return $cache[$fieldId];
	}

	/**
	 * @param UserTable  $user
	 * @param FieldTable $field
	 * @param string     $value
	 * @param int        $operator
	 */
	protected function addFieldValue( &$user, $field, $value, $operator )
	{
		global $_CB_database;

		$fieldName						=	$field->get( 'name', null, GetterInterface::STRING );

		if ( preg_match( '/multicheckbox|multiselect|tag/', $field->get( 'type', null, GetterInterface::STRING ) ) ) {
			$currentValues				=	explode( '|*|', $user->get( $fieldName, null, GetterInterface::RAW ) );

			foreach ( explode( '|*|', $value ) as $newValue ) {
				if ( ! in_array( $newValue, $currentValues ) ) {
					$currentValues[]	=	$newValue;
				}
			}

			$fieldValue					=	implode( '|*|', $currentValues );

			if ( $user->get( $fieldName, '', GetterInterface::STRING ) === $fieldValue ) {
				// We didn't add any new values so lets just stop here:
				return;
			}
		} else {
			switch ( $operator ) {
				case 1: // add
					$fieldValue			=	( $user->get( $fieldName, 0, GetterInterface::FLOAT ) + (float) $value );
					break;
				case 2: // subtract
					$fieldValue			=	( $user->get( $fieldName, 0, GetterInterface::FLOAT ) - (float) $value );
					break;
				case 3: // multiply
					$fieldValue			=	( $user->get( $fieldName, 0, GetterInterface::FLOAT ) * (float) $value );
					break;
				case 4: // divide
					$fieldValue			=	( $user->get( $fieldName, 0, GetterInterface::FLOAT ) / (float) $value );
					break;
				case 5: // prefix
					$fieldValue			=	( $value . $user->get( $fieldName, null, GetterInterface::RAW ) );
					break;
				case 6: // suffix
					$fieldValue			=	( $user->get( $fieldName, null, GetterInterface::RAW ) . $value );
					break;
				case 0: // set
				default:
					$fieldValue			=	$value;
					break;
			}
		}

		$query							=	'UPDATE ' . $_CB_database->NameQuote( $field->get( 'table', null, GetterInterface::STRING ) )
										.	"\n SET " . $_CB_database->NameQuote( $fieldName ) . " = " . $_CB_database->Quote( $fieldValue )
										.	"\n WHERE " . $_CB_database->NameQuote( 'id' ) . " = " . $user->get( 'id', 0, GetterInterface::INT );
		$_CB_database->setQuery( $query );
		$_CB_database->query();

		$user->set( $fieldName, $fieldValue );
	}

	/**
	 * @param UserTable  $user
	 * @param FieldTable $field
	 * @param string     $value
	 * @param int        $operator
	 * @param mixed      $fieldRemoveContent
	 */
	protected function removeFieldValue( &$user, $field, $value, $operator, $fieldRemoveContent )
	{
		global $_CB_database;

		$fieldName								=	$field->get( 'name', null, GetterInterface::STRING );

		if ( preg_match( '/multicheckbox|multiselect|tag/', $field->get( 'type', null, GetterInterface::STRING ) ) ) {
			$currentValues						=	explode( '|*|', $user->get( $fieldName, null, GetterInterface::RAW ) );

			foreach ( explode( '|*|', $value ) as $removeValue ) {
				if ( in_array( $removeValue, $currentValues ) ) {
					$k							=	array_search( $removeValue, $currentValues );

					unset( $currentValues[$k] );
				}
			}

			$fieldValue							=	implode( '|*|', $currentValues );

			if ( $user->get( $fieldName, '', GetterInterface::STRING ) === $fieldValue ) {
				// We didn't remove any values so there's nothing to change so lets just stop here:
				return;
			}
		} else {
			if ( ( $fieldRemoveContent !== '' ) && ( $fieldRemoveContent !== null ) ) {
				$fieldValue						=	$fieldRemoveContent;
			} else {
				$fieldValue						=	null;

				switch ( $operator ) {
					case 1: // add -> subtract
						$fieldValue				=	( $user->get( $fieldName, 0, GetterInterface::FLOAT ) - (float) $value );
						break;
					case 2: // subtract -> add
						$fieldValue				=	( $user->get( $fieldName, 0, GetterInterface::FLOAT ) + (float) $value );
						break;
					case 3: // multiply -> divide
						$fieldValue				=	( $user->get( $fieldName, 0, GetterInterface::FLOAT ) / (float) $value );
						break;
					case 4: // divide -> multiply
						$fieldValue				=	( $user->get( $fieldName, 0, GetterInterface::FLOAT ) * (float) $value );
						break;
					case 5: // prefix
						if ( cbutf8_substr( $user->get( $fieldName, null, GetterInterface::RAW ), 0, cbutf8_strlen( $value ) ) == $value ) {
							$fieldValue			=	cbutf8_substr( $user->get( $fieldName, null, GetterInterface::RAW ), cbutf8_strlen( $value ) );
						}
						break;
					case 6: // suffix
						if ( cbutf8_substr( $user->get( $fieldName, null, GetterInterface::RAW ), -cbutf8_strlen( $value ) ) == $value ) {
							$fieldValue			=	cbutf8_substr( $user->get( $fieldName, null, GetterInterface::RAW ), 0, -cbutf8_strlen( $value ) );
						}
						break;
					case 0: // set
					default:
						// Try to undo what we had set previously based off field type:
						switch ( $field->get( 'type', null, GetterInterface::STRING ) ) {
							case 'fieldgroup':
								if ( $user->get( $fieldName, null, GetterInterface::RAW ) == $value ) {
									$fieldValue	=	'[]';
								}
								break;
							case 'date':
								if ( $user->get( $fieldName, null, GetterInterface::STRING ) == $value ) {
									$fieldValue	=	'0000-00-00';
								}
								break;
							case 'datetime':
								if ( $user->get( $fieldName, null, GetterInterface::STRING ) == $value ) {
									$fieldValue	=	'0000-00-00 00:00:00';
								}
								break;
							case 'time':
								if ( $user->get( $fieldName, null, GetterInterface::STRING ) == $value ) {
									$fieldValue	=	'00:00:00';
								}
								break;
							case 'integer':
							case 'counter':
								if ( $user->get( $fieldName, 0, GetterInterface::INT ) == (int) $value ) {
									$fieldValue	=	0;
								}
								break;
							case 'float':
							case 'points':
							case 'rating':
								if ( $user->get( $fieldName, 0, GetterInterface::FLOAT ) == (float) $value ) {
									$fieldValue	=	0;
								}
								break;
							case 'checkbox':
							case 'terms':
								if ( $user->getInt( $fieldName, 0 ) === (int) $value ) {
									if ( $value ) {
										$fieldValue	=	0;
									} else {
										$fieldValue	=	1;
									}
								}
								break;
							default:
								if ( $user->get( $fieldName, null, GetterInterface::RAW ) == $value ) {
									$fieldValue	=	'';
								}
								break;
						}
						break;
				}

				if ( $fieldValue === null ) {
					// We had nothing to revert so lets just stop here:
					return;
				}
			}
		}

		$query							=	'UPDATE ' . $_CB_database->NameQuote( $field->get( 'table', null, GetterInterface::STRING ) )
			.	"\n SET " . $_CB_database->NameQuote( $fieldName ) . " = " . $_CB_database->Quote( $fieldValue )
			.	"\n WHERE " . $_CB_database->NameQuote( 'id' ) . " = " . $user->get( 'id', 0, GetterInterface::INT );
		$_CB_database->setQuery( $query );
		$_CB_database->query();

		$user->set( $fieldName, $fieldValue );
	}

	/**
	 * Called at each change of user subscription state due to a plan activation or deactivation
	 *
	 * @param  UserTable        $user
	 * @param  string           $status
	 * @param  int              $planId
	 * @param  int              $replacedPlanId
	 * @param  ParamsInterface  $integrationParams
	 * @param  string           $cause            'PaidSubscription' (first activation only), 'SubscriptionActivated' (renewals, cancellation reversals), 'SubscriptionDeactivated', 'Denied'
	 * @param  string           $reason           'N' new subscription, 'R' renewal, 'U'=update )
	 * @param  int              $now              Unix time
	 * @param  cbpaidSomething  $subscription     Subscription/Donation/Merchandise record
	 * @param  int              $autorenewed      0: not auto-renewing (manually renewed), 1: automatically renewed (if $reason == 'R')
	 */
	public function onCPayUserStateChange( &$user, $status, $planId, $replacedPlanId, &$integrationParams, $cause, $reason, $now, &$subscription, $autorenewed )
	{
		if ( ! is_object( $user ) ) {
			return;
		}

		$cbUser							=	CBuser::getInstance( $user->get( 'id', 0, GetterInterface::INT ), false );
		$extraStrings					=	$subscription->substitutionStrings( false );

		for ( $i = 1; $i <= 10; $i++ ) {
			$field						=	$this->getField( $integrationParams->get( 'cbfields_fieldid' . $i, 0, GetterInterface::INT ) );

			if ( $field->get( 'fieldid', 0, GetterInterface::INT ) ) {
				$fieldContent			=	$cbUser->replaceUserVars( $integrationParams->get( 'cbfields_contentoffield' . $i, '', GetterInterface::RAW ), false, false, $extraStrings, false );
				$fieldRemoveContent		=	$cbUser->replaceUserVars( $integrationParams->get( 'cbfields_removecontent' . $i, '', GetterInterface::RAW ), false, false, $extraStrings, false );
				$operator				=	$integrationParams->get( 'cbfields_increment' . $i, 0, GetterInterface::INT );

				if ( ( ( ! in_array( $field->get( 'type', null, GetterInterface::STRING ), array( 'text', 'integer', 'float', 'counter', 'rating', 'points' ) ) ) && in_array( $operator, array( 1, 2, 3, 4 ) ) )
					 || ( preg_match( '/multicheckbox|multiselect|tag/', $field->get( 'type', null, GetterInterface::STRING ) ) && in_array( $operator, array( 5, 6 ) ) )
				) {
					$operator			=	0; // set
				}

				if ( ( $status === 'A' ) && ( $cause === 'PaidSubscription' ) ) {
					$this->addFieldValue( $user, $field, $fieldContent, $operator );
				} elseif ( in_array( $status, array( 'X', 'C' ), true )
						   && ( $cause !== 'Pending' )
						   && $integrationParams->getBool( 'cbfields_removeondeact' . $i, true )
				) {
					$this->removeFieldValue( $user, $field, $fieldContent, $operator, $fieldRemoveContent );
				}
			}
		}
	}
}
