<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2019 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\FamilyPlans\Trigger;

use CB\Database\Table\UserTable;
use CB\Plugin\FamilyPlans\Table\FamilyTable;
use CBLib\Registry\GetterInterface;

defined('CBLIB') or die();

class UserTrigger extends \cbPluginHandler
{

	/**
	 * @param  UserTable $user
	 * @param  int       $status
	 */
	public function deleteSharedSubscriptions( $user, $status )
	{
		global $_CB_database;

		$query			=	'SELECT *'
						.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_family' )
						.	"\n WHERE ( " . $_CB_database->NameQuote( 'user_id' ) . " = " . $user->get( 'id', 0, GetterInterface::INT )
						.	" OR " . $_CB_database->NameQuote( 'user' ) . " = " . $user->get( 'id', 0, GetterInterface::INT ) . " )";
		$_CB_database->setQuery( $query );
		$subscriptions	=	$_CB_database->loadObjectList( null, '\CB\Plugin\FamilyPlans\Table\FamilyTable', array( $_CB_database ) );

		/** @var FamilyTable[] $subscriptions */
		foreach ( $subscriptions as $subscription ) {
			$subscription->delete();
		}
	}
}