<?php
/**
* CBSubs (TM): Community Builder Paid Subscriptions Plugin: cbsubsidevaf
* @version $Id: cbsubs.idevaf.php 1465 2012-07-10 17:37:13Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage cbsubs.idevaf.php
* @author Beat
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2 Commercial, right to modify for own use, no rights to redistriute
*/

use CB\Database\Table\UserTable;
use CBLib\Registry\GetterInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;

$_PLUGINS->registerFunction( 'onCPayAfterPaymentStatusUpdateEvent',	'onCPayAfterPaymentStatusUpdateEvent',	'getcbsubsidevafTab' );

/**
 * CBSubs iDevAf integration plugin
 */
class getcbsubsidevafTab extends cbTabHandler
{
	/**
	 * Event handler for onCPayAfterPaymentStatusUpdateEvent, called each time an update occurs to the payment status of the payment basket
	 *
	 * Paypal status mappings:
	 * CB Unified status				Paypal status
	 * Completed				<--		Completed
	 * Processed				<--		Processed, Canceled_Reversal
	 * Denied					<--		Denied, Expired, Failed, Voided
	 * Refunded					<--		Reversed, Refunded, Partially-Refunded
	 * Pending					<--		Pending, In-Progress
	 * RegistrationCancelled	<--		A new cb registration got cancelled by user (e.g. paypal cancel payment button)
	 *
	 * @param  UserTable           $user                   User paying the payment basket
	 * @param  cbpaidPaymentBasket $paymentBasket          Payment basket
	 * @param  cbpaidSomething[]   $subscriptions          Subscriptions in the basket
	 * @param  string              $unifiedStatus          New Unified status (see above)
	 * @param  string              $previousUnifiedStatus  Previous Unified status (see above)
	 * @param  string              $eventType              type of event (paypal type): 'web_accept', 'subscr_payment', 'subscr_signup', 'subscr_modify', 'subscr_eot', 'subscr_cancel', 'subscr_failed'
	 * @return void
	 */
	public function onCPayAfterPaymentStatusUpdateEvent( &$user, &$paymentBasket, &$subscriptions, $unifiedStatus, $previousUnifiedStatus, $eventType )
	{
		if ( ! is_object( $user ) ) {
			return;
		}

		$params							=	cbpaidApp::settingsParams();
		$path							=	$params->get( 'idevaf_install', null, GetterInterface::STRING );

		if ( ( ! $path ) || ( $path == 'http://' ) ) {
			return;
		}

		$optField1						=	$params->get( 'idevaf_optfield1', 0, GetterInterface::INT );
		$optField2						=	$params->get( 'idevaf_optfield2', 0, GetterInterface::INT );
		$pendingSales					=	$params->get( 'idevaf_PendingSales', 0, GetterInterface::INT );

		$data1							=	trim( $this->getFieldValue( $user, $optField1 ) );
		$data2							=	trim( $this->getFieldValue( $user, $optField2 ) );

		$paymentItems					=	$paymentBasket->loadPaymentItems();
		$orderId						=	$paymentBasket->get( 'item_number', null, GetterInterface::STRING );
		$coupon							=	null;

		if ( $params->get( 'idevaf_coupons', false, GetterInterface::BOOLEAN ) ) {
			if ( $params->get( 'idevaf_couponcode', 0, GetterInterface::INT ) ) {
				$coupon					=	$this->getFieldValue( $user, $params->get( 'idevaf_couponfield', 0, GetterInterface::INT ) );
			} else {
				$coupons				=	$paymentBasket->getParams( 'integrations' )->get( 'promotions_coupons', null, GetterInterface::STRING );

				if ( $coupons ) {
					$coupons			=	explode( '|*|', $coupons );
					$coupon				=	array_shift( $coupons );
				}
			}
		}

		$saleIPaddresses				=	explode( ',', $paymentBasket->get( 'ip_addresses', null, GetterInterface::STRING ) );

		foreach ( $paymentItems as $item ) {
			$price						=	$item->getPrice();

			if ( ! $price ) {
				continue;
			}

			if ( ( $unifiedStatus == 'Completed' ) || ( $unifiedStatus == 'Processed' ) || ( ( $pendingSales == 1 ) && ( $unifiedStatus == 'Pending' ) ) ) {
				$client					=	new \GuzzleHttp\Client();
				$query					=	array(	'profile'		=>	92,
													'idev_saleamt'	=>	$price,
													'idev_ordernum'	=>	$orderId,
													'idev_option_1'	=>	$data1,
													'idev_option_2'	=>	( $data2 ? $data2 : $unifiedStatus ),
													'idev_option_3'	=>	$item->get( 'plan_id', 0, GetterInterface::INT ),
													'ip_address'	=>	$saleIPaddresses[0]
												);

				if ( $coupon ) {
					// https://www.idevlibrary.com/docs/Coupon_Code_Commissioning.pdf
					$query['coupon_code']	=	$coupon;
				}

				// https://www.idevlibrary.com/docs/Vendor_Integration_Information.pdf
				$client->get( $path . '/sale.php', array( 'query' => $query, 'timeout' => 30 ) );
			}
		}
	}

	/**
	 * Render field value from field id
	 *
	 * @param  UserTable  $user
	 * @param  int		  $fieldId
	 * @return string
	 */
	protected function getFieldValue( $user, $fieldId )
	{
		if ( ! $fieldId ) {
			return '';
		}

		return cbpaidUserExtension::getInstance( $user->get( 'id', 0, GetterInterface::INT ) )->getFieldValue( $fieldId, true );
	}
}
