<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Plugin\PlanOptions\Task;
use CB\Plugin\PlanOptions\Trigger\PlanTrigger;
use CB\Plugin\PlanOptions\Trigger\BasketTrigger;
use CB\Plugin\PlanOptions\Trigger\SubscriptionTrigger;
use CBLib\Core\AutoLoader;

defined('CBLIB') or die();

AutoLoader::registerExactMap( '%^CB/Plugin/PlanOptions/(.+)%i', __DIR__ . '/library/$1.php' );

class_alias( Task::class, 'getcbsubsoptionsTab' );

global $_PLUGINS;

// Plans
$_PLUGINS->registerFunction( 'onCPayBeforeDisplayProductPeriodPrice', 'onCPayBeforeDisplayProductPeriodPrice', PlanTrigger::class );
$_PLUGINS->registerFunction( 'onCPayBeforeDrawPlan', 'onCPayBeforeDrawPlan', PlanTrigger::class );
$_PLUGINS->registerFunction( 'onCPayAfterDrawPlan', 'onCPayAfterDrawPlan', PlanTrigger::class );
$_PLUGINS->registerFunction( 'onCPayAfterPlanSelected', 'onCPayAfterPlanSelected', PlanTrigger::class );
$_PLUGINS->registerFunction( 'onCPayAfterPlanRenewalSelected', 'onCPayAfterPlanRenewalSelected', PlanTrigger::class );
$_PLUGINS->registerFunction( 'onCPayLoadSomethingPlan', 'onCPayLoadSomethingPlan', PlanTrigger::class );

// Subscriptions
$_PLUGINS->registerFunction( 'onCPayBeforeDrawSubscription', 'onCPayBeforeDrawSubscription', SubscriptionTrigger::class );
$_PLUGINS->registerFunction( 'onCPayBeforeDrawSomething', 'onCPayBeforeDrawSomething', SubscriptionTrigger::class );
$_PLUGINS->registerFunction( 'onCPaySubscriptionSubstitutionStrings', 'onCPaySubscriptionSubstitutionStrings', SubscriptionTrigger::class );

// Basket
$_PLUGINS->registerFunction( 'onCPayRenderBasketItem', 'onCPayRenderBasketItem', BasketTrigger::class );
$_PLUGINS->registerFunction( 'onCPayPaymentItemEvent', 'onCPayPaymentItemEvent', BasketTrigger::class );
$_PLUGINS->registerFunction( 'onCPayBeforePaymentStatusUpdateEvent', 'onCPayBeforePaymentStatusUpdateEvent', BasketTrigger::class );