const planOptions = {
	cache: {
		storage: {},
		has: function( url, key ) {
			if ( key instanceof FormData ) {
				key = new URLSearchParams( key ).toString();
			}

			return ( ( url in this.storage ) && ( key in this.storage[url] ) );
		},
		get: function( url, key ) {
			if ( key instanceof FormData ) {
				key = new URLSearchParams( key ).toString();
			}

			if ( ! this.has( url, key ) ) {
				return '';
			}

			return this.storage[url][key];
		},
		set: function( url, key, data ) {
			if ( key instanceof FormData ) {
				key = new URLSearchParams( key ).toString();
			}

			if ( ! ( url in this.storage ) ) {
				this.storage[url] = {};
			}

			this.storage[url][key] = data;
		}
	},
	jQuery: function() {
		if ( typeof window.cbjQuery !== 'undefined' ) {
			return window.cbjQuery;
		}

		return null;
	},
	price: function( form, target, mustUpdate ) {
		if ( ! form.dataset.url ) {
			return;
		}

		const post = new FormData();

		form.querySelectorAll( '.cbsubsPlanOptionsSelect,.cbsubsPlanOptionsInput,.cbsubsPlanPricesSelect,.cbsubsPlanPricesInput' ).forEach( ( item ) => {
			if ( ( item.nodeName === 'INPUT' ) && ( ( item.getAttribute( 'type' ) === 'checkbox' ) || ( item.getAttribute( 'type' ) === 'radio' ) ) && ( ! item.checked ) )  {
				return;
			}

			if ( item.value === '' ) {
				return;
			}

			if ( ( ! item.classList.contains( 'cbsubsPlanOptionsAvailable' ) ) && ( ! item.classList.contains( 'cbsubsPlanPricesAvailable' ) ) ) {
				mustUpdate = true;
			}

			post.append( item.name, item.value );
		});

		if ( ! mustUpdate ) {
			return;
		}

		const updatePrice = ( data ) => {
			if ( ! data ) {
				return;
			}

			target.innerHTML = data;

			const selector = target.querySelector( '.cbsubsPlanOptionsPrice' );

			if ( selector ) {
				const existingSelector = form.querySelector( '.cbsubsPlanOptionsPrice' );

				if ( existingSelector ) {
					existingSelector.innerHTML = selector.innerHTML;
				}

				selector.remove();
			}
		};

		if ( planOptions.cache.has( form.dataset.url, post ) ) {
			updatePrice( planOptions.cache.get( form.dataset.url, post ) );

			return;
		}

		fetch( form.dataset.url, {
			method: 'POST',
			body: post,
		}).then( response => {
			return response.text();
		}).then( data => {
			if ( ! data ) {
				return;
			}

			planOptions.cache.set( form.dataset.url, post, data );

			updatePrice( data );
		});
	},
	button: function( button ) {
		const form = button.closest( '.cbregPlan' ).querySelector( '.cbregButton > .cbregRenewButtonForm' );
		const submitButton = form.querySelector( 'button[type="submit"]' );
		const submitButtonHTML = submitButton.innerHTML;
		const changeButton = button.querySelector( '.cbsubsChangePlanOptionsBtn' );
		const cancelButton = button.querySelector( '.cbsubsCancelPlanOptionsBtn' );

		const getSiblings = ( e, filter ) => {
			let siblings = [];

			if ( ! e.parentElement ) {
				return siblings;
			}

			let sibling = e.parentElement.firstElementChild;

			while ( sibling ) {
				if ( ( sibling !== e ) && ( ( filter && ( sibling !== filter ) ) || ( ! filter ) ) ) {
					siblings.push( sibling );
				}

				sibling = sibling.nextElementSibling;
			}

			return siblings;
		};

		const insertOptions = ( data ) => {
			const html = document.createElement( 'div' );

			html.innerHTML = data;

			const options = form.insertBefore( html.firstElementChild, form.firstElementChild );

			cancelButton.parentElement.classList.remove( 'hidden' );

			getSiblings( button, form ).map( e => e.classList.add( 'hidden' ) );
			getSiblings( form.parentElement ).map( e => e.classList.add( 'hidden' ) );

			planOptions.form( options, submitButton );
		};

		changeButton.addEventListener( 'click', ( event ) => {
			event.preventDefault();

			if ( ! button.dataset.url ) {
				return;
			}

			changeButton.parentElement.classList.add( 'hidden' );

			if ( planOptions.cache.has( button.dataset.url, 'change' ) ) {
				insertOptions( planOptions.cache.get( button.dataset.url, 'change' ) );

				return;
			}

			fetch( button.dataset.url ).then( response => {
				return response.text();
			}).then( data => {
				if ( ! data ) {
					return;
				}

				planOptions.cache.set( button.dataset.url, 'change', data );

				insertOptions( data );
			});
		});

		cancelButton.addEventListener( 'click', ( event ) => {
			event.preventDefault();

			changeButton.parentElement.classList.remove( 'hidden' );
			cancelButton.parentElement.classList.add( 'hidden' );

			getSiblings( button, form ).map( e => e.classList.remove( 'hidden' ) );
			getSiblings( form.parentElement ).map( e => e.classList.remove( 'hidden' ) );

			form.querySelector( '.cbsubsPlanOptions' ).remove();

			submitButton.innerHTML = submitButtonHTML;
		});
	},
	form: function( form, target ) {
		const tick = form.closest( '.cbregPlan' ).querySelector( '.cbregTick' );

		if ( ! target ) {
			target = form.closest( '.cbregPlan' ).querySelector( '.cbregFee' );

			if ( ! target ) {
				target = form.closest( '.cbregPlan' ).querySelector( '.cbsubsPlanOptionsPrice' );
			}

			const toggle = ( form.classList.contains( 'cbsubsPlanOptionsToggle' ) ? form : form.querySelector( '.cbsubsPlanOptionsToggle' ) );
			const required = form.querySelectorAll( '.cbsubsPlanOptionsSelect.cbsubsPlanOptionRequired' );

			if ( tick && ( toggle || required.length ) ) {
				const toggleVisibility = function() {
					const checked = this.checked;

					if ( toggle ) {
						if ( checked ) {
							toggle.classList.remove( 'hidden' );
						} else {
							toggle.classList.add( 'hidden' );
						}
					}

					if ( required.length ) {
						required.forEach( ( item ) => {
							if ( checked ) {
								item.classList.add( 'required' );
							} else {
								item.classList.remove( 'required' );
							}
						});
					}
				};

				if ( planOptions.jQuery ) {
					planOptions.jQuery()( tick ).on( 'change', toggleVisibility );
				} else {
					tick.addEventListener( 'change', toggleVisibility );
				}
			}
		}

		form.querySelectorAll( '.cbsubsPlanOptionsSelect' ).forEach( ( item ) => {
			if ( tick ) {
				item.addEventListener( 'click', ( event ) => {
					if ( ! tick.checked ) {
						tick.click();
					}
				});
			}

			if ( form.dataset.url ) {
				item.addEventListener( 'change', ( event ) => {
					event.preventDefault();

					planOptions.price( form, target, true );
				});
			}
		});

		if ( form.dataset.url ) {
			planOptions.price( form, target );
		}
	},
	tickPrice: function( select ) {
		const tick = select.closest( '.cbregPlan' ).querySelector( '.cbregTick' );

		if ( ! tick ) {
			return;
		}

		select.addEventListener( 'click', () => {
			if ( ! tick.checked ) {
				tick.click();
			}
		});
	},
	tickPlan: function( tick ) {
		const selectPriceOption = () => {
			let sibling = tick.nextElementSibling;
			let option = null;

			while ( sibling ) {
				if ( sibling.classList.contains( 'cbregAfterSubDescription' ) ) {
					option = sibling.querySelector( '.cbsubsPlanOptionsPrice input.cbsubsPlanPricesSelect[type="radio"]' );
					break;
				}

				if ( sibling.classList.contains( 'cbregParagraph' ) ) {
					sibling = sibling.firstElementChild;
				} else {
					sibling = sibling.nextElementSibling;
				}
			}

			if ( ( ! option ) || option.checked ) {
				return;
			}

			option.click();
		};

		if ( ! tick.checked ) {
			tick.closest( '.cbregPlan' ).querySelectorAll( 'input.cbsubsPlanPricesSelect[type="radio"]' ).forEach( ( price ) => {
				price.checked = false;
			});
		} else {
			selectPriceOption();
		}

		const togglePrice = () => {
			if ( ! tick.checked ) {
				tick.closest( '.cbregPlan' ).querySelectorAll( 'input.cbsubsPlanPricesSelect[type="radio"]' ).forEach( ( price ) => {
					price.checked = false;
				});
			} else {
				selectPriceOption();
			}
		};

		if ( planOptions.jQuery ) {
			planOptions.jQuery()( tick ).on( 'change', togglePrice );
		} else {
			tick.addEventListener( 'change', togglePrice );
		}
	},
}

window.addEventListener( 'load', function() {
	document.querySelectorAll( '.cbsubsPlanOptions' ).forEach( ( form ) => { planOptions.form( form ); } );
	document.querySelectorAll( '.cbsubsChangePlanOptions' ).forEach( planOptions.button );
	document.querySelectorAll( '.cbsubsPlanOptionsPrice' ).forEach( planOptions.tickPrice );
	document.querySelectorAll( '.cbregPlan input.cbregTick' ).forEach( planOptions.tickPlan );
});