<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\PlanOptions\Entity;

use CBLib\Language\CBTxt;
use cbpaidSomething;

\defined('CBLIB') or die();

class PaidEntity
{
	/** @var string */
	protected string $title;
	/** @var array */
	protected array $value;
	/** @var cbpaidSomething */
	protected cbpaidSomething $subscription;

	/**
	 * @param string          $title
	 * @param array           $value
	 * @param cbpaidSomething $subscription
	 */
	public function __construct( string $title, array $value, cbpaidSomething $subscription )
	{
		$this->title			=	$title;
		$this->value			=	$value;
		$this->subscription		=	$subscription;
	}

	/**
	 * @return string
	 */
	public function getTitle(): string
	{
		return $this->subscription->getPersonalized( $this->title, false, false, null, false );
	}

	/**
	 * @return string
	 */
	public function getLabel(): string
	{
		return $this->subscription->getPersonalized( ( $this->value['label'] ?? '' ), false, false, null, false );
	}

	/**
	 * @return float
	 */
	public function getRate(): float
	{
		return ( $this->value['rate'] ?? 0.0 );
	}

	/**
	 * @return float
	 */
	public function getFirstRate(): float
	{
		return ( $this->value['first_rate'] ?? 0.0 );
	}

	/**
	 * @return string
	 */
	public function renderPrice(): string
	{
		if ( $this->subscription->getPlan()->getInt( 'first_different', 0 ) && ( $this->getRate() !== $this->getFirstRate() ) ) {
			$price	=	$this->subscription->getPlan()->renderPrice( $this->getFirstRate() ) . CBTxt::T( ', then ' ) . $this->subscription->getPlan()->renderPrice( $this->getRate() );
		} else {
			$price	=	$this->subscription->getPlan()->renderPrice( $this->getRate() );
		}

		return trim( \strip_tags( $price ) );
	}
}