<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\PlanOptions\Entity;

use CB\Plugin\PlanOptions\Helper;
use CBLib\Registry\ParamsInterface;
use cbpaidProduct;
use cbpaidSomething;

\defined('CBLIB') or die();

class PriceEntity
{
	/** @var cbpaidProduct */
	protected cbpaidProduct $plan;
	/** @var ParamsInterface */
	protected ParamsInterface $price;
	/** @var null|cbpaidSomething */
	protected ?cbpaidSomething $subscription	=	null;

	/**
	 * @param cbpaidProduct        $plan
	 * @param ParamsInterface      $price
	 */
	public function __construct( cbpaidProduct $plan, ParamsInterface $price, ?cbpaidSomething $subscription = null )
	{
		$this->plan				=	$plan;
		$this->price			=	$price;
		$this->subscription		=	$subscription;
	}

	/**
	 * @return cbpaidProduct
	 */
	public function getPlan(): cbpaidProduct
	{
		return $this->plan;
	}

	/**
	 * @return string
	 */
	public function getName(): string
	{
		return $this->price->getString( 'name', '' );
	}

	/**
	 * @return int
	 */
	public function getFirstDifferent(): int
	{
		return $this->price->getInt( 'first_different', 0 );
	}

	/**
	 * @return float
	 */
	public function getFirstRate(): float
	{
		return $this->price->getFloat( 'first_rate', 0.0 );
	}

	/**
	 * @return string
	 */
	public function getFirstValidity(): string
	{
		return $this->price->getString( 'first_validity', '0001-00-00 00:00:00' );
	}

	/**
	 * @return string
	 */
	public function getFirstCalStart(): string
	{
		return $this->price->getString( 'first_calstart', '01-01' );
	}

	/**
	 * @return float
	 */
	public function getRate(): float
	{
		return $this->price->getFloat( 'rate', 0.0 );
	}

	/**
	 * @return string
	 */
	public function getValidity(): string
	{
		return $this->price->getString( 'validity', '0001-00-00 00:00:00' );
	}

	/**
	 * @return string
	 */
	public function getCalStart(): string
	{
		return $this->price->getString( 'calstart', '01-01' );
	}

	/**
	 * @param bool $withHTML
	 * @return string
	 */
	public function renderPrice( bool $withHTML = false ): string
	{
		$price	=	Helper::renderPlanPeriodPrice( $this->plan, $this->subscription, $this, true );

		if ( $withHTML ) {
			return $price;
		}

		return trim( \strip_tags( $price ) );
	}
}