<?php
/**
* Community Builder (TM)
* @version $Id: $
* @package CommunityBuilder
* @copyright (C) 2004-2022 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

namespace CB\Plugin\PlanOptions\Trigger;

use CB\Database\Table\UserTable;
use CB\Plugin\PlanOptions\Helper;
use CB\Plugin\PlanOptions\TemplateHandler;
use CBLib\Application\Application;
use cbpaidSomething;
use cbpaidSomethingViewModel;
use cbpaidUsersubscriptionRecord;

\defined('CBLIB') or die();

class SubscriptionTrigger extends \cbPluginHandler
{
	/**
	 * Add the plan options to the subscription display just above the price
	 *
	 * @param cbpaidSomethingViewModel $viewModel
	 * @param cbpaidSomething          $subscription
	 * @return string
	 */
	public function onCPayBeforeDrawSubscription( cbpaidSomethingViewModel $viewModel, cbpaidSomething $subscription ): string
	{
		$plan		=	$subscription->getPlan();

		if ( ( ! $plan->getParam( 'options_display_subscriptions', 1, 'integrations' ) ) || ( ! Helper::getSelectedValues( $plan, $subscription ) ) ) {
			return '';
		}

		/** @var $viewer \cbpaidPlanOptionsView */
		$viewer		=	TemplateHandler::getViewer( null, 'planoptions' );

		return $viewer->drawDisplay( $plan, $subscription );
	}

	/**
	 * Handles displaying the change options button
	 *
	 * @param cbpaidUsersubscriptionRecord $subscription
	 * @param null|string                  $childrenRendering
	 * @param string                       $controlButtons
	 * @param bool                         $showRenewButtons
	 * @param bool                         $showUnsubscribeButtons
	 * @param int                          $now
	 * @param UserTable                    $user
	 * @return void
	 */
	public function onCPayBeforeDrawSomething( cbpaidUsersubscriptionRecord $subscription, ?string &$childrenRendering, string &$controlButtons, bool $showRenewButtons, bool $showUnsubscribeButtons, int $now, UserTable $user ): void
	{
		if ( ( ! $showRenewButtons ) || Application::Application()->isClient( 'administrator' ) || ( ! $subscription->checkIfRenewable( $now ) ) ) {
			return;
		}

		$plan			=	$subscription->getPlan();

		if ( ( ! Helper::hasPlanPrices( $plan ) ) && ( ! Helper::hasPlanOptions( $plan ) ) ) {
			return;
		}

		$changePrice	=	$plan->getParam( 'options_prices_changeable', 1, 'integrations' );
		$changeOptions	=	$plan->getParam( 'options_changeable', 1, 'integrations' );

		if ( ( ! $changePrice ) && ( ! $changeOptions ) ) {
			return;
		}

		/** @var $viewer \cbpaidPlanOptionsView */
		$viewer			=	TemplateHandler::getViewer( null, 'planoptions' );
		$insertAt		=	'</form>';

		$controlButtons	=	substr_replace( $controlButtons, $viewer->drawButton( $subscription, $changePrice, $changeOptions ), ( strpos( $controlButtons, $insertAt ) + \strlen( $insertAt ) ), 0 );
	}

	/**
	 * @param array           $extraStrings
	 * @param cbpaidSomething $subscription
	 * @param bool            $html
	 * @return void
	 */
	public function onCPaySubscriptionSubstitutionStrings( array &$extraStrings, cbpaidSomething $subscription, bool $html ): void
	{
		$plan					=	$subscription->getPlan();

		if ( ( ! Helper::hasPlanPrices( $plan ) ) && ( ! Helper::hasPlanOptions( $plan ) ) ) {
			return;
		}

		static $cache			=	[];

		$planId					=	$plan->getInt( 'id', 0 );

		if ( \array_key_exists( $planId, $cache ) ) {
			$extras				=	$cache[$planId];

			if ( $extras ) {
				$extraStrings	=	\array_merge( $extraStrings, $extras );
			}

			return;
		}

		$price					=	Helper::getSelectedPlanPrice( $plan, $subscription );

		$cache[$planId]['PLAN_OPTS_PRICE']				=	( $price ? $price->getName() : '' );

		// First set empty selection for all plan options to ensure substitutions don't just output their key if nothing is selected
		foreach ( Helper::getPlanOptions( $plan, $subscription ) as $option ) {
			$key				=	strtoupper( preg_replace( '/[^-a-zA-Z0-9_]/', '', $option->getName() ) );

			$cache[$planId]['PLAN_OPTS_OPTION_' . $key]	=	'';
		}

		// Now add replace the above substitutions for selected values with their actual values
		foreach ( Helper::getSelectedValues( $plan, $subscription, Helper::getSelectedPlanPrice( $plan, $subscription ) ) as $value ) {
			$key				=	strtoupper( preg_replace( '/[^-a-zA-Z0-9_]/', '', $value->getOption()->getName() ) );

			$cache[$planId]['PLAN_OPTS_OPTION_' . $key]	=	$value->getValue();
		}

		$extraStrings			=	\array_merge( $extraStrings, $cache[$planId] );
	}
}