<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2020 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

$tmplVersion	=	1;	// This is the template version that needs to match

/**
 * @var cbpaidPlanOptionsView $this
 */
?>
<div class="mb-1 d-flex flex-column cbsubsPlanOptionsValues">
	<?php if ( $this->description ) { ?>
	<div class="cbsubsPlanOptionsValuesDesc">
		<?php echo $this->description; ?>
	</div>
	<?php } ?>
	<?php foreach ( $this->values as $value ) {
		switch ( $value->getOption()->getDisplay() ) {
			case 5: // Inline
				?>
					<div class="d-flex cbft_select cbtt_select cb_form_line cbsubsPlanOptionsValue">
						<label for="<?php echo $value->getOption()->getInputId(); ?>" class="col-form-label"><?php echo $value->getOption()->getTitle(); ?></label>
						<div class="cb_field">
							<div id="<?php echo $value->getOption()->getInputId(); ?>" class="form-control-plaintext">
								<?php echo $value->renderLabel(); ?>
							</div>
						</div>
					</div>
				<?php
				break;
			case 4: // 1 Line without Title
				?>
					<div class="m-0 form-group row no-gutters cbft_select cbtt_select cb_form_line cbtwolinesfield cbsubsPlanOptionsValue">
						<div class="cb_field col-sm-12">
							<div class="form-control-plaintext">
								<?php echo $value->renderLabel(); ?>
							</div>
						</div>
					</div>
				<?php
				break;
			case 3: // 1 Line with Empty Title
				?>
					<div class="m-0 form-group row no-gutters cbft_select cbtt_select cb_form_line cbsubsPlanOptionsValue">
						<div class="cb_field col-sm-9 offset-sm-3">
							<div class="form-control-plaintext">
								<?php echo $value->renderLabel(); ?>
							</div>
						</div>
					</div>
				<?php
				break;
			case 2: // 2 Lines with Title
				?>
					<div class="m-0 form-group row no-gutters cbft_select cbtt_select cb_form_line cbtwolinesfield cbsubsPlanOptionsValue">
						<label for="<?php echo $value->getOption()->getInputId(); ?>" class="col-form-label col-sm-12"><?php echo $value->getOption()->getTitle(); ?></label>
						<div class="cb_field col-sm-12">
							<div id="<?php echo $value->getOption()->getInputId(); ?>" class="form-control-plaintext">
								<?php echo $value->renderLabel(); ?>
							</div>
						</div>
					</div>
				<?php
				break;
			case 1: // 1 Line with Title
			default:
				?>
					<div class="m-0 form-group row no-gutters cbft_select cbtt_select cb_form_line cbsubsPlanOptionsValue">
						<label for="<?php echo $value->getOption()->getInputId(); ?>" class="col-form-label col-sm-3 pr-sm-2"><?php echo $value->getOption()->getTitle(); ?></label>
						<div class="cb_field col-sm-9">
							<div id="<?php echo $value->getOption()->getInputId(); ?>" class="form-control-plaintext">
								<?php echo $value->renderLabel(); ?>
							</div>
						</div>
					</div>
				<?php
				break;
		}
	} ?>
</div>