<?php
/**
* CBSubs (TM): Community Builder Paid Subscriptions Plugin: cbsubspostafpro
* @version $Id: cbsubs.postafpro.php 1586 2012-12-26 16:52:06Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage cbsubs.postafpro.php
* @author Beat
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\UserTable;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_PLUGINS;
$_PLUGINS->registerFunction( 'onCPayBeforeStorePaymentBasketUpdated',	'onCPayBeforeStorePaymentBasketUpdated',	'getcbsubspostafproTab' );
$_PLUGINS->registerFunction( 'onCPayAfterPaymentStatusUpdateEvent',		'onCPayAfterPaymentStatusUpdateEvent',		'getcbsubspostafproTab' );

/**
 * CBSubs PostAfPro integration plugin class
 */
class getcbsubspostafproTab extends cbTabHandler {

	/**
	 * Event handler for onCPayBeforeStorePaymentBasketUpdated, called each time the basket has been stored after an update at ordering time
	 *
	 * @param  cbpaidPaymentBasket       $paymentBasket          Payment basket
	 * @param  cbpaidPaymentItem[]       $paymentItems           Payment items in the basket
	 * @param  cbpaidPaymentTotalizer[]  $paymentTotalizers      Payment totalizers in the basket
	 * @return void
	 */
	public function onCPayBeforeStorePaymentBasketUpdated( $paymentBasket, /** @noinspection PhpUnusedParameterInspection */ $paymentItems, /** @noinspection PhpUnusedParameterInspection */ $paymentTotalizers ) {
		$integrationParams	=	$paymentBasket->getParams( 'integrations' );
		$affiliateID		=	stripslashes( cbGetParam( $_COOKIE, 'PAPVisitorId', '' ) );

		if ( $affiliateID ) {
			$integrationParams->set( 'postafpro_affiliateid', $affiliateID );
		}

		$paymentBasket->storeParams( 'integrations' );
	}

	/**
	 * Event handler for onCPayAfterPaymentStatusUpdateEvent, called each time an update occurs to the payment status of the payment basket
	 *
	 * Paypal status mappings:
	 * CB Unified status				Paypal status
	 * Completed				<--		Completed
	 * Processed				<--		Processed, Canceled_Reversal
	 * Denied					<--		Denied, Expired, Failed, Voided
	 * Refunded					<--		Reversed, Refunded, Partially-Refunded
	 * Pending					<--		Pending, In-Progress
	 * RegistrationCancelled	<--		A new cb registration got cancelled by user (e.g. paypal cancel payment button)
	 *
	 * @param  UserTable           $user                   User paying the payment basket
	 * @param  cbpaidPaymentBasket $paymentBasket          Payment basket
	 * @param  cbpaidSomething[]   $subscriptions          Subscriptions in the basket
	 * @param  string              $unifiedStatus          New Unified status (see above)
	 * @param  string              $previousUnifiedStatus  Previous Unified status (see above)
	 * @param  string              $eventType              type of event (paypal type): 'web_accept', 'subscr_payment', 'subscr_signup', 'subscr_modify', 'subscr_eot', 'subscr_cancel', 'subscr_failed'
	 * @return void
	 */
	public function onCPayAfterPaymentStatusUpdateEvent( &$user, &$paymentBasket, /** @noinspection PhpUnusedParameterInspection */ &$subscriptions, $unifiedStatus, /** @noinspection PhpUnusedParameterInspection */ $previousUnifiedStatus, /** @noinspection PhpUnusedParameterInspection */ $eventType ) {
		global $_CB_framework;

		if ( ( ! ( ( $unifiedStatus == 'Completed' ) || ( $unifiedStatus == 'Processed' ) ) ) || ( ! is_object( $user ) ) ) {
			return;
		}

		$params							=	cbpaidApp::settingsParams();
		$installPath					=	$params->get( 'postafpro_install', null );

		if ( ( $installPath == null ) || ( $installPath == 'http://' ) ) {
			return;
		}

		$papFile						=	$_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/plugin/cbsubspostafpro/papapi.class.php';

		if ( ! file_exists( $papFile ) ) {
			return;
		}

		/** @noinspection PhpIncludeInspection */
		include_once( $papFile );

		$saleTracker					=	new Pap_Api_SaleTracker( $installPath . '/scripts/sale.php' );

		$integrationParams				=	$paymentBasket->getParams( 'integrations' );
		$affiliateID					=	$integrationParams->get( 'postafpro_affiliateid', null );
		$CustomAccount					=	$params->get( 'postafpro_account', 'default1' );
		$coupon							=	null;

		if ( $params->get( 'postafpro_coupons', 0 ) ) {
			if ( $params->get( 'postafpro_couponcode', 0 ) ) {
				$coupon					=	$this->getFieldValue( $user, (int) $params->get( 'postafpro_couponfield' ) );
			} else {
				$coupons				=	$integrationParams->get( 'promotions_coupons', null );

				if ( $coupons ) {
					$coupons			=	explode( '|*|', $coupons );
					$coupon				=	array_shift( $coupons );
				}
			}
		}

		if ( $affiliateID ) {
			$saleTracker->setCookieValue( $affiliateID );
		}

		if ( $CustomAccount ) {
			$saleTracker->setAccountId( $CustomAccount );
		}

		$paymentItems					=	$paymentBasket->loadPaymentItems();
		$registerSale					=	false;

		foreach ( $paymentItems as $item ) {
			$CustomAffiliate			=	$item->getPlanParam( 'postafpro_affiliate', null, 'integrations' );
			$CustomCampaign				=	$item->getPlanParam( 'postafpro_campaign', null, 'integrations' );
			$CustomChannel				=	$item->getPlanParam( 'postafpro_channel', null, 'integrations' );
			$CustomCommission			=	$item->getPlanParam( 'postafpro_commission', null, 'integrations' );
			$CustomCurrency				=	$item->getPlanParam( 'postafpro_currency', null, 'integrations' );
			$status						=	$item->getPlanParam( 'postafpro_status', 'A', 'integrations' );
			$update						=	(int) $item->getPlanParam( 'postafpro_update', 0, 'integrations' );
			$renewal					=	(int) $item->getPlanParam( 'postafpro_renewal', 1, 'integrations' );

			/** @var $sale Pap_Tracking_Action_RequestActionObject */
			$sale						=	$saleTracker->createSale();
			$price						=	$item->getPrice();
			$reason						=	$item->reason;
			$orderId					=	( (int) $user->id ) . '_' . ( (int) $item->plan_id );

			$sale->setTotalCost( $price );
			$sale->setOrderID( $orderId );
			$sale->setProductID( (int) $item->plan_id );
			$sale->setStatus( $status );

			if ( $CustomAffiliate || $affiliateID ) {
				$sale->setAffiliateID( ( $CustomAffiliate ? $CustomAffiliate : $affiliateID ) );
			}

			if ( $coupon ) {
				$sale->setCouponCode( $coupon );
			}

			if ( $CustomCampaign ) {
				$sale->setCampaignID( $CustomCampaign );
			}

			if ( $CustomChannel ) {
				$sale->setChannelID( $CustomChannel );
			}

			if ( $CustomCommission ) {
				$sale->setCustomCommission( $CustomCommission );
			}

			if ( $CustomCurrency ) {
				$sale->setCurrency( $CustomCurrency );
			}

			$data1						=	$this->getFieldValue( $user, (int) $params->get( 'postafpro_optfield1' ) );

			if ( $data1 ) {
				$sale->setData1( $data1 );
			}

			$data2						=	$this->getFieldValue( $user, (int) $params->get( 'postafpro_optfield2' ) );

			if ( $data2 ) {
				$sale->setData2( $data2 );
			}

			$data3						=	$this->getFieldValue( $user, (int) $params->get( 'postafpro_optfield3' ) );

			if ( $data3 ) {
				$sale->setData3( $data3 );
			}

			$data4						=	$this->getFieldValue( $user, (int) $params->get( 'postafpro_optfield4' ) );

			if ( $data4 ) {
				$sale->setData4( $data4 );
			}

			$data5						=	$this->getFieldValue( $user, (int) $params->get( 'postafpro_optfield5' ) );

			if ( $data5 ) {
				$sale->setData5( $data5 );
			}

			$registerRecurr				=	false;

			switch( $reason ) {
				case 'N':
					$registerSale		=	true;
				break;
				case 'U':
					if ( $update == 0 ) {
						$registerSale	=	true;
					} elseif ( ( $update == 1 ) && ( $status == 'A' ) ) {
						$registerRecurr	=	true;
					}
				break;
				case 'R':
					if ( $renewal == 0 ) {
						$registerSale	=	true;
					} elseif ( ( $renewal == 1 ) && ( $status == 'A' ) ) {
						$registerRecurr	=	true;
					}
				break;
			}

			if ( $registerRecurr ) {
				$session				=	new Gpf_Api_Session( $installPath . '/scripts/server.php' );
				$recurringCommission	=	new Pap_Api_RecurringCommission( $session );

				$recurringCommission->setOrderId( $orderId );
				$recurringCommission->createCommissions();
			}
		}

		if ( $registerSale ) {
			$saleTracker->register();
		}
	}

	/**
	 * Render field value from field id
	 *
	 * @param  UserTable  $user
	 * @param  int        $fieldId
	 * @return string
	 */
	protected function getFieldValue( $user, $fieldId ) {
		if ( $fieldId ) {
			$cbUser	=	CBuser::getInstance( (int) $user->id, false );
			$value	=	$cbUser->getField( (int) $fieldId, null, 'csv' );
			$format	=	htmlspecialchars( urlencode( trim( $value ) ) );
		} else {
			$format	=	null;
		}

		return $format;
	}

	/**
	 * Function for the backend XML
	 *
	 * @param  string  $name          Name of the control
	 * @param  string  $value         Current value
	 * @param  string  $control_name  Name of the controlling array (if any)
	 * @return string                 HTML for the control data part or FALSE in case of error
	 */
	protected function loadCookieTest( /** @noinspection PhpUnusedParameterInspection */ $name, $value, $control_name ) {
		global $_CB_framework;

		$img_path		=	$_CB_framework->getCfg( 'live_site' ) . '/components/com_comprofiler/images/';
		$set			=	'<img src="' . $img_path . 'approve.png" border="0" />';
		$notset			=	'<img src="' . $img_path . 'reject.png" border="0" />';
		$cookies		=	null;

		if ( isset( $_COOKIE['PAPVisitorId'] ) ) {
			$cookies	.=	'<div>' . $set . ' PAPVisitorId (Sales Tracking)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' PAPVisitorId (Sales Tracking)</div>';
		}

		if ( isset( $_COOKIE['PAPCookie_FirstClick'] ) ) {
			$cookies	.=	'<div>' . $set . ' PAPCookie_FirstClick (Click Tracking)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' PAPCookie_FirstClick (Click Tracking)</div>';
		}

		if ( isset( $_COOKIE['PAPCookie_LastClick'] ) ) {
			$cookies	.=	'<div>' . $set . ' PAPCookie_LastClick (Click Tracking)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' PAPCookie_LastClick (Click Tracking)</div>';
		}

		if ( isset( $_COOKIE['PAPCookie_Sale'] ) ) {
			$cookies	.=	'<div>' . $set . ' PAPCookie_Sale (Sales Tracking)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' PAPCookie_Sale (Sales Tracking)</div>';
		}

		if ( isset( $_COOKIE['PAPCookie_Time'] ) ) {
			$cookies	.=	'<div>' . $set . ' PAPCookie_Time (Click Tracking)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' PAPCookie_Time (Click Tracking)</div>';
		}

		if ( isset( $_COOKIE['RPC_pap_sid'] ) ) {
			$cookies	.=	'<div>' . $set . ' RPC_pap_sid (Admin Panel)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' RPC_pap_sid (Admin Panel)</div>';
		}

		if ( isset( $_COOKIE['M_auth'] ) ) {
			$cookies	.=	'<div>' . $set . ' M_auth (Merchant Panel Authentication)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' M_auth (Merchant Panel Authentication)</div>';
		}

		if ( isset( $_COOKIE['A_auth'] ) ) {
			$cookies	.=	'<div>' . $set . ' A_auth (Affiliate Panel Authentication)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' A_auth (Affiliate Panel Authentication)</div>';
		}

		if ( isset( $_COOKIE['M_pap_sid'] ) ) {
			$cookies	.=	'<div>' . $set . ' M_pap_sid (Merchant Panel Session)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' M_pap_sid (Merchant Panel Session)</div>';
		}

		if ( isset( $_COOKIE['A_pap_sid'] ) ) {
			$cookies	.=	'<div>' . $set . ' A_pap_sid (Affiliate Panel Session)</div>';
		} else {
			$cookies	.=	'<div>' . $notset . ' A_pap_sid (Affiliate Panel Session)</div>';
		}

		return $cookies;
	}
}
