<?php
/**
* @version $Id: cbsubs.promotion.php 1608 2012-12-29 04:12:52Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Plugin for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CB\Database\Table\PluginTable;
use CB\Database\Table\UserTable;
use CBLib\Application\Application;
use CBLib\Database\DatabaseDriverInterface;
use CBLib\Database\Table\TableInterface;
use CBLib\Language\CBTxt;
use CBLib\Registry\ParamsInterface;

/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

global $_CB_framework, $_PLUGINS;

/** @noinspection PhpIncludeInspection */
include_once( $_CB_framework->getCfg( 'absolute_path' ) . '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/cbpaidsubscriptions.class.php');

//$_PLUGINS->registerFunction( 'onxmlBeforeCbSubsDisplayOrSaveInvoice', 'onxmlBeforeCbSubsDisplayOrSaveInvoice', 'getcbsubspromotionTab' );
$_PLUGINS->registerFunction( 'onCbSubsBeforePaymentBasket', 'onCbSubsBeforePaymentBasket', 'getcbsubspromotionTab' );
$_PLUGINS->registerFunction( 'onCbSubsAfterPaymentBasket', 'onCbSubsAfterPaymentBasket', 'getcbsubspromotionTab' );
$_PLUGINS->registerFunction( 'onCPayEditBasketIntegration', 'onCPayEditBasketIntegration', 'getcbsubspromotionTab' );
$_PLUGINS->registerFunction( 'onCPayAfterDisplayProductPeriodPrice', 'onCPayAfterDisplayProductPeriodPrice', 'getcbsubspromotionTab' );
$_PLUGINS->registerFunction( 'onCPayBeforeDrawPlan', 'onCPayBeforeDrawPlan', 'getcbsubspromotionTab' );
$_PLUGINS->registerFunction( 'onCPayAfterDrawPlan', 'onCPayAfterDrawPlan', 'getcbsubspromotionTab' );
$_PLUGINS->registerFunction( 'onCPayBeforeDrawSomething', 'onCPayBeforeDrawSomething', 'getcbsubspromotionTab' );
$_PLUGINS->registerFunction( 'onCPayAfterDrawSomething', 'onCPayAfterDrawSomething', 'getcbsubspromotionTab' );
$_PLUGINS->registerFunction( 'onCPayPaymentItemEvent', 'onCPayPaymentItemEvent', 'getcbsubspromotionTab' );

/**
 * Class for promotion settings
 */
class cbpaidpromotionTotalizertype extends cbpaidTotalizertypeCompoundable {
	public $id;								// sql:int(11)
	public $name;							// sql:varchar(64)
	public $promotion_type;					// sql:varchar(16)  coupon,always
	public $coupon_code;					// sql:varchar(64)
	public $coupon_code_cbfield;			// sql:int(11)
	public $coupon_description;				// sql:varchar(512)
	public $discount_type;					// sql:varchar(16)  percentage,fixed
	public $rate;							// sql:decimal(16,8)  null="true"
	public $currency;						// sql:varchar(3)
	public $amount;							// sql:decimal(16,8)  null="true"
	public $rate_cbfield;					// sql:int(11)
	public $currency_cbfield;				// sql:int(11)
	public $amount_cbfield;					// sql:int(11)
	public $amount_cbfield_deduct;			// sql:tinyint(4)
	public $stages;							// sql:varchar(256)
	public $priority;						// sql:int(11)
	public $exclusive_within_priority;		// sql:tinyint(4)
	public $show_also_zero_values;			// sql:tinyint(4)
	public $applies_to_first_payment;		// sql:tinyint(4)
	public $applies_to_recurrings;			// sql:tinyint(4)
	public $applies_to_registrations;		// sql:tinyint(4)
	public $applies_to_upgrades;			// sql:tinyint(4)
	public $applies_to_renewals;			// sql:tinyint(4)
	public $max_uses_total;					// sql:int(11)
	public $max_uses_per_customer;			// sql:int(11)
	public $buyer_geo_zone_id;				// sql:int(20)
	public $applies_to_business_consumer;	// sql:char(1) default="A" B,C
	public $applies_to_items;				// sql:tinyint(4)
	public $plans_applied_to;				// sql:varchar(1024)
	public $plans_sametime_required;		// sql:varchar(1024)
	public $cal_proratatemporis;			// sql:tinyint(4)
	public $cal_periodmissed;				// sql:varchar(2)
	public $cal_fullmissed;					// sql:tinyint(4)
	public $cal_maxdperiodsmissed;			// sql:varchar(255)
	public $cal_catchuppromotion;			// sql:tinyint(4)
	public $cond_1_operator;				// sql:varchar(6)
	public $cond_1_plans_required;			// sql:varchar(1024)
	public $cond_1_plans_status;			// sql:varchar(40)
	public $cond_1_purchase_ok;				// sql:tinyint(4)
	public $cond_1_subscription_conditions;			// sql:tinyint(4)
	public $cond_1_subscription_autorecurring;		// sql:tinyint(4)	// 0: do not care, 1: yes, 2: no
	public $cond_1_subscription_regular_recurrings_used_min;		// sql:int(11)
	public $cond_1_subscription_regular_recurrings_used_max;		// sql:int(11)
	public $cond_1_basket_conditions;				// sql:tinyint(4)
	public $cond_1_basket_currencies;				// sql:varchar(1200)
	public $cond_1_basket_gatewayaccounts;			// sql:varchar(128)
	public $cond_1_basket_payment_methods;			// sql:varchar(256)
	public $cond_1_basket_payment_types;			// sql:varchar(256)
	public $cond_1_basket_autorecurring;			// sql:tinyint(4)	// 0: do not care, 1: yes, 2: no
	public $cond_1_basket_taxed;					// sql:tinyint(4)	// 0: do not care, 1: yes, 2: no
	public $cond_1_basket_address_country_codes;	// sql:varchar(1400)
	public $cond_1_date_1;					// sql:varchar(20)
	public $cond_1_date_cbfield_1;			// sql:int(11)
	public $cond_1_value_1;					// sql:varchar(1024)
	public $cond_1_dates_diff_a;			// sql:varchar(21)
	public $cond_1_dates_diff_b;			// sql:varchar(21)
	public $cond_1_date_2;					// sql:varchar(20)
	public $cond_1_date_cbfield_2;			// sql:int(11)
	public $cond_1_value_2;					// sql:varchar(1024)
	public $cond_2_operator;				// sql:varchar(6)
	public $cond_2_plans_required;			// sql:varchar(1024)
	public $cond_2_plans_status;			// sql:varchar(40)
	public $cond_2_purchase_ok;				// sql:tinyint(4)
	public $cond_2_subscription_conditions;			// sql:tinyint(4)
	public $cond_2_subscription_autorecurring;		// sql:tinyint(4)	// 0: do not care, 1: yes, 2: no
	public $cond_2_subscription_regular_recurrings_used_min;		// sql:int(11)
	public $cond_2_subscription_regular_recurrings_used_max;		// sql:int(11)
	public $cond_2_basket_conditions;				// sql:tinyint(4)
	public $cond_2_basket_currencies;				// sql:varchar(1200)
	public $cond_2_basket_gatewayaccounts;			// sql:varchar(128)
	public $cond_2_basket_payment_methods;			// sql:varchar(256)
	public $cond_2_basket_payment_types;			// sql:varchar(256)
	public $cond_2_basket_autorecurring;			// sql:tinyint(4)	// 0: do not care, 1: yes, 2: no
	public $cond_2_basket_taxed;					// sql:tinyint(4)	// 0: do not care, 1: yes, 2: no
	public $cond_2_basket_address_country_codes;	// sql:varchar(1400)
	public $cond_2_date_1;					// sql:varchar(20)
	public $cond_2_date_cbfield_1;			// sql:int(11)
	public $cond_2_value_1;					// sql:varchar(1024)
	public $cond_2_dates_diff_a;			// sql:varchar(21)
	public $cond_2_dates_diff_b;			// sql:varchar(21)
	public $cond_2_date_2;					// sql:varchar(20)
	public $cond_2_date_cbfield_2;			// sql:int(11)
	public $cond_2_value_2;					// sql:varchar(1024)
	public $published;						// sql:tinyint(4)
	public $start_date;						// sql:datetime null="false"
	public $stop_date;						// sql:datetime null="false"
	public $applies_to_blocked_users;		// sql:int(11)
	public $viewaccesslevel	=	1;			// sql:int(11)
	public $usergroups;						// sql:varchar(1024)
	public $user_ids;						// sql:varchar(1024)
	public $ordering;						// sql:int(11)
	public $cssclass;						// sql:varchar(48)
	public $owner	=	0;					// sql:int(11)
	public $override_plans_display;			// sql:tinyint(4)
	public $plan_name_descr_display_type;	// sql:tinyint(4)
	public $plan_name_display_text;			// sql:varchar(256)
	public $plan_description_display_text;	// sql:varchar(4096)
	public $plan_price_display_type;		// sql:tinyint(4)
	public $plan_price_display_saletext;	// sql:varchar(256)
	public $plan_price_display_text;		// sql:varchar(2048)
	public $params;							// sql:text
	public $integrations;					// sql:text

	public $_itemsUsingThisPromo			=	array();
	protected $_itemsDiscountRatio			=	array();
	protected $_amount_used_in_basket		=	0;
	/**
	 * @var int|null
	 */
	protected $_forUserId					=	null;
	/**
	 * @var cbpaidPaymentBasket
	 */
	protected $_paymentBasket;
	/**
	 * @var cbpaidPaymentItem
	 */
	protected $_paymentItem;
	/**
	 * Constructor
	 *
	 * @param  DatabaseDriverInterface  $db
	 */
	public function __construct( &$db = null ) {
		parent::__construct( '#__cbsubs_promotions', 'id', $db );
		$this->_historySetLogger();
	}

	/**
	 * Copies this record (no checks) (copied from FieldTable)
	 *
	 * @param  null|TableInterface|self  $object  The object being copied otherwise create new object and add $this
	 * @return self|boolean                       OBJECT: The new object copied successfully, FALSE: Failed to copy
	 */
	public function copy( $object = null ) {

		if ( $object === null ) {
			$object					=	clone $this;
		}

		//TODO: This algorithm below to determine the new name could be factored out as reusable:

		// Grab index of field from fields with same name
		$query					=	'SELECT ' . $this->_db->NameQuote( 'name' )
			.	"\n FROM "	   . $this->_db->NameQuote( $this->_tbl )
			.	"\n WHERE "    . $this->_db->NameQuote( 'name' ) . " REGEXP " . $this->_db->Quote( '^' . preg_quote( $object->name ) . '[0-9]*$' )
			.	"\n ORDER BY " . $this->_db->NameQuote( 'name' );
		$this->_db->setQuery( $query );
		$names						=	$this->_db->loadResultArray();
		$count						=	count( $names );

		// Only increment if there's something to increment as the name could be changed before copy is called, which would be a 0 count:
		if ( $count ) {
			$index					=	$count;

			// Loop through and make sure the index is unique; if not keep incrementing until it is:
			do {
				$changed			=	false;

				foreach ( $names as $v ) {
					if ( $v == $object->copyNumberText( $index ) ) {
						$index++;

						$changed	=	true;
					}
				}
			} while ( $changed );

			$object->name			=	$object->copyNumberText( $index );
		}

		return parent::copy( $object );
	}

	/**
	 * Utility function appending " (Copy $index)" to $this->name
	 *
	 * @param  string  $index
	 * @return string
	 */
	protected function copyNumberText( $index )
	{
		return $this->name . ' ' . CBTxt::T( 'COPY_NUMBER', '(Copy [NUMBER])', array( '[NUMBER]' => $index ) );
	}

	/**
	 * Singletons loader
	 *
	 * @param  boolean  $isPublished
	 * @param  boolean  $overridePlansDisplay
	 * @return cbpaidpromotionTotalizertype[]
	 */
	public static function getInstances( $isPublished = true, $overridePlansDisplay = false ) {
		static $cache				=	array();
		if ( ! isset( $cache[$isPublished] ) ) {
			$conditions				=	$isPublished ? array( 'published' => 1 ) : array();
			$me						=	new self();
			$cache[$isPublished]	=	$me->loadThisMatchingList( $conditions, array( 'priority' => 'ASC', 'ordering' => 'ASC' ) );
		}
		if ( $overridePlansDisplay ) {
			if ( ! ( isset( $cache['overrides'] ) && is_array( $cache['overrides'] ) ) ) {
				$cache['overrides']	=	array();
				foreach ( $cache[$isPublished] as $promo ) {
					if ( $promo->override_plans_display ) {
						$cache['overrides'][]		=	$promo;
					}
				}
			}
			return $cache['overrides'];
		}
		return $cache[$isPublished];
	}
	/**
	 * Singleton loader
	 *
	 * @param  int  $id
	 * @return cbpaidpromotionTotalizertype|boolean  false if not existent
	 */
	public static function getInstance( $id ) {
		$instances					=	self::getInstances();
		if ( isset( $instances[$id] ) ) {
			return $instances[$id];
		}
		return false;
	}
	/**
	 * Loads promotions of type coupon with matching $couponCode
	 *
	 * @param  string   $couponCode
	 * @param  int      $buyerUserId
	 * @param  boolean  $isPublished
	 * @return array of cbpaidpromotionTotalizertype
	 */
	public function loadCouponsWithCode( $couponCode, $buyerUserId, $isPublished = true ) {
		$conditions		=	array(	'promotion_type'	=>	'coupon',
									'coupon_code'		=>	array( 'IN', array( (string) $couponCode, '=' ) ) );
		if ( $isPublished ) {
			$conditions['published'] =	1;
		}
        /** @var $promos self[] */
		$promos			=	$this->loadThisMatchingList( $conditions, array( 'priority' => 'ASC', 'ordering' => 'ASC' ) );
		foreach ( $promos as $k => $promoCoupon ) {
			if ( $promoCoupon->checkCoupon( $couponCode, $buyerUserId ) === false ) {
				unset( $promos[$k] );
			}
		}
		return $promos;
	}
	/**
	 * loads and returns an array of geoZone ids to which a country/province/zip is part of
	 *
	 * @param  string  $buyerCountry
	 * @param  string  $buyerProvince
	 * @param  string  $buyerZip
	 * @return int[]
	 */
	private function _loadGeoZonesOfBuyer( $buyerCountry, $buyerProvince, $buyerZip ) {
		/* Query example:
			SELECT b.id FROM #__cbsubs_geo_zones b
			JOIN #__cbsubs_geo_zones_entries be ON
			     be.geo_zone_id = b.id
			 AND be.`country_iso_code2` = 'CH'
			 AND ( be.`province_iso_code` = '' OR be.`province_iso_code` = 'CH-VD' )
			 AND ( be.`zip_code_condition` = 0 OR ( be.`zip_code_condition` = 1 AND '1010' REGEXP be.`zip_code_regexp` ) OR ( be.`zip_code_condition` = 2 AND be.`zip_code_min` <= 1010 AND be.`zip_code_max` >= 1010 ) )
		 */
		$sql			=	'SELECT DISTINCT b.id FROM ' . $this->_db->NameQuote( '#__cbsubs_geo_zones' ) . ' AS b'
						.	"\n JOIN " . $this->_db->NameQuote( '#__cbsubs_geo_zones_entries' ) . ' AS be'
						.	"\n			  ON be.geo_zone_id = b.id"
						.	"\n 		 AND be." . $this->_db->NameQuote( 'country_iso_code2' ) . ' = ' . $this->_db->Quote( $buyerCountry )
						.	"\n 		 AND ( be." . $this->_db->NameQuote( 'province_iso_code' ) . ' = ' . $this->_db->Quote( '' )
						.	"\n 		    OR be." . $this->_db->NameQuote( 'province_iso_code' ) . ' = ' . $this->_db->Quote( $buyerProvince ) . ' )'
						.	"\n 		 AND ( be." . $this->_db->NameQuote( 'zip_code_condition' ) . ' = 0'
						.	"\n 		  OR ( be." . $this->_db->NameQuote( 'zip_code_condition' ) . ' = 1 AND ' . $this->_db->Quote( $buyerZip ) . ' REGEXP be.' . $this->_db->NameQuote( 'zip_code_regexp' ) . ' )'
						.	"\n 		  OR ( be." . $this->_db->NameQuote( 'zip_code_condition' ) . ' = 2'
						.	"\n 		 						 AND be." . $this->_db->NameQuote( 'zip_code_min' ) . ' <= ' . (int) $buyerZip
						.	"\n 		 						 AND be." . $this->_db->NameQuote( 'zip_code_max' ) . ' >= ' . (int) $buyerZip . ' ) )';
		$this->_db->setQuery( $sql );
		return $this->_db->loadResultArray();
	}
	/**
	 * UTF-8-aware case-insensitive string comparison in output Charset
	 *
	 * @param  string          $string1
	 * @param  string          $string2
	 * @return string|boolean  $string2 if same, FALSE different
	 */
	private function _strCompare( $string1, $string2 ) {
		if ( $string1 === $string2 ) {
			return $string2;
		}
		if ( is_callable( 'mb_strtoupper' ) ) {
			global $_CB_framework;
			$charset	=	$_CB_framework->outputCharset();
			if ( mb_strtoupper( $string1, $charset ) === mb_strtoupper( $string2, $charset ) ) {
				return $string2;
			}
		} else {
			if ( strtoupper( $string1 ) === strtoupper( $string2 ) ) {
				return $string2;
			}
		}
		return false;
	}
	/**
	 * Checks if $couponCode is valid for $this promotion for $buyerUserId (returns false if no user id)
	 *
	 * @param  string          $couponCode
	 * @param  int             $buyerUserId
	 * @return string|boolean  Coupon used with correct casing or FALSE
	 */
	protected function checkCoupon( $couponCode, $buyerUserId ) {
		if ( ( $this->coupon_code == '=' ) && $this->coupon_code_cbfield ) {
			if ( $buyerUserId ) {
				$cbUser	=	CBuser::getInstance( $buyerUserId );
				if ( $cbUser ) {
					$fieldV	=	cbpaidUserExtension::getInstance( $buyerUserId )->getFieldValue( (int) $this->coupon_code_cbfield, true );
					return $this->_strCompare( $couponCode, $fieldV );
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return $this->_strCompare( $couponCode, $this->coupon_code );
		}
	}
	/**
	 * loads a cache and returns an array of geoZone ids to which a country/province/zip is part of
	 *
	 * @param  string  $buyerCountry
	 * @param  string  $buyerProvince
	 * @param  string  $buyerZip
	 * @return int[]
	 */
	private function getGeoZonesOfBuyer( $buyerCountry, $buyerProvince, $buyerZip ) {
		static $geoZones	=	array();
		if ( ! isset( $geoZones[$buyerCountry][$buyerProvince][$buyerZip] ) ) {
			$geoZones[$buyerCountry][$buyerProvince][$buyerZip]		=	$this->_loadGeoZonesOfBuyer( $buyerCountry, $buyerProvince, $buyerZip );
		}
		return $geoZones[$buyerCountry][$buyerProvince][$buyerZip];
	}
	/**
	 * Checks if $viewaccesslevel is included in view access levels of $userId
	 *
	 * @param  int      $userId
	 * @param  int      $viewaccesslevel
     * @return boolean
     */
	private static function _checkUserViewAccessLevels( $userId, $viewaccesslevel ) {
		return Application::User( (int) $userId )->canViewAccessLevel( (int) $viewaccesslevel );
	}
	/**
	 * Checks if any of $userId's groups is within $allowedGroups
	 *
	 * @param  int    $userId
	 * @param  int[]  $allowedGroups
	 * @return boolean
	 */
	private static function _checkUserGroupsInAllowedGroups( $userId, $allowedGroups ) {
		global $_CB_framework;

		$user				=	CBuser::getUserDataInstance( $userId );

		$usersGids			=	$user->gids;
		if ( ( ! $userId ) && ! $usersGids ) {
			$usersGids		=	$_CB_framework->acl->mapGroupNamesToValues( array( 'Public' ) );
		}

		if ( $user->id ) {
			// add registered pseudo-group:
			array_unshift( $usersGids, -1 );
		}

		// add users pseudo-group:
		array_unshift( $usersGids, -2 );

		$allowedGroupsAndChildren	=	array();
		foreach ( $allowedGroups as $grp ) {
			$allowedGroupsAndChildren	=	array_merge( $allowedGroupsAndChildren, $_CB_framework->acl->get_group_parent_ids( $grp ) );
		}
		return ( count( array_intersect( $allowedGroupsAndChildren, $usersGids ) ) > 0 );
	}

	/**
	 * Checks if promotion applies for the $reason ('N'Registration/'U'pgrade/'R'enewal) and $occurrence (1 or >1) of the payment
	 *
	 * @param  string  $reason
	 * @param  array   $resultTexts  OUT
	 * @return boolean
	 */
	protected function checkIfAppliesToPaymentReason( $reason, &$resultTexts ) {
		switch ( $reason ) {
			case 'N':
				if ( $this->applies_to_registrations ) {
					return true;
				}
				$resultTexts[]	=	CBTxt::T("Promotion does not apply to new sign-ups.");
				break;
			case 'U':
				if ( $this->applies_to_upgrades ) {
					return true;
				}
				$resultTexts[]	=	CBTxt::T("Promotion does not apply to upgrades.");
				break;
			case 'R':
				if ( $this->applies_to_renewals ) {
					return true;
				}
				$resultTexts[]	=	CBTxt::T("Promotion does not apply to renewals.");
				break;

			default:
				;
			break;
		}
		return false;
	}
    /**
     * Checks if promotion applies for the $reason ('N'Registration/'U'pgrade/'R'enewal) and $occurrence (1 or >1) of the payment
     *
     * @param  cbpaidPaymentBasket  $paymentBasket
     * @param  string[]             $resultTexts  (output)
     * @return boolean
     */
	protected function checkIfAppliesToPaymentBasketAutoRecurring( $paymentBasket, &$resultTexts ) {
		if ( $this->applies_to_first_payment ) {
			return true;
		}
		if ( $this->applies_to_recurrings && $paymentBasket ) {
			if ( $paymentBasket->isAnyAutoRecurringPossibleWithThisBasket() ) {
				return true;
			} else {
				$resultTexts[]	=	CBTxt::T("Promotion does not apply to single payments but only to autorecurring payments.");
				return false;
			}
		}
		$resultTexts[]	=	CBTxt::T("Promotion does not apply to any payments (promotion configuration mistake).");
		return false;
	}
	/**
	 * Checks if promotion applies for the maximum uses in total as well as for $userId
	 *
	 * @param  int      $userId
	 * @return boolean
	 */
	protected function checkIfMaxDiscountUsesNotReached( $userId ) {
		if ( $this->max_uses_total ) {
			if ( cbpaidPromotionUse::countPromoUses( $this->id ) >= $this->max_uses_total ) {
				return false;
			}
		}
		if ( $this->max_uses_per_customer ) {
			if ( cbpaidPromotionUse::countPromoUses( $this->id, $userId ) >= $this->max_uses_per_customer ) {
				return false;
			}
		}
		return true;
	}
	/**
	 * checks in a cache if buyer country/province/zip is part of $this->buyer_geo_zone_id
	 *
	 * @param  string  $buyerCountry
	 * @param  string  $buyerProvince
	 * @param  string  $buyerZip
	 * @return boolean
	 */
	protected function checkBuyerGeoZone( $buyerCountry, $buyerProvince, $buyerZip ) {
		return ( $this->buyer_geo_zone_id == 0 ) || in_array( $this->buyer_geo_zone_id, $this->getGeoZonesOfBuyer( $buyerCountry, $buyerProvince, $buyerZip ) );
	}
	/**
	 * checks if the payment basket is_business '1' or '0' matches the $this->applies_to_business_consumer A,B,C rule
	 *
	 * @param  boolean  $is_business
	 * @return boolean
	 */
	protected function checkAppliesToBusinessCondition( $is_business ) {
		return ( $this->applies_to_business_consumer == 'A' ) || ( $is_business && ( $this->applies_to_business_consumer == 'B' ) ) || ( ( ! $is_business ) && ( $this->applies_to_business_consumer == 'C' ) );
	}
	/**
	 * Checks if $this promotion applies to a given $planId
	 *
	 * @param  int $planId
	 * @return boolean
	 */
	protected function checkIfAppliesToPlanId( $planId ) {
		return ( ( $this->plans_applied_to == '' ) || in_array( $planId, explode( '|*|', $this->plans_applied_to ) ) );
	}
	/**
	 * Checks if $this promotion applies based on $plansIds purchased same time that must ALL be purchased simultaneously
	 *
	 * @param  cbpaidPaymentBasket  $paymentBasket
	 * @return boolean
	 */
	protected function checkAllSameTimePlansRequired( $paymentBasket ) {
		if ( $this->plans_sametime_required && $paymentBasket ) {
			$plansIds			=	cbpaidCondition::getPlansQuantityofBasket( $paymentBasket );
			foreach ( explode( '|*|', $this->plans_sametime_required ) as $planIdRequired ) {
				if ( ! isset( $plansIds[$planIdRequired] ) ) {
					return false;
				}
			}
		}
		return true;
	}
	/**
	 * Checks if $this promotion applies based on $userId 's existing subscriptions and CB fields conditions 1 and 2.
	 *
	 * @param  int                       $userId
	 * @param  array                     $resultTexts  (returned appended)
	 * @param  cbpaidPaymentBasket       $paymentBasket
	 * @return boolean
	 */
	protected function checkActiveConditions( $userId, &$resultTexts, $paymentBasket ) {
		if ( $this->cond_1_operator ) {
			$r							=	cbpaidCondition::checkConditionsOfObject( $this, $userId, $resultTexts, $paymentBasket );
		} else {
			$r							=	true;
		}
		return $r;
	}

	/**
	 * Checks if the start published date matches $now time
	 *
	 * @param  int  $now  Unix-Time
	 * @return boolean
	 */
	protected function checkStartDate( $now ) {
		$nullDate			=	$this->_db->getNullDate( 'date' );
		$nullDateTime		=	$this->_db->getNullDate();
		if ( ( $this->start_date != $nullDate ) && ( $this->start_date != $nullDateTime ) ) {
			$nowDate		=	$this->_db->getUtcDateTime( $now );
			if ( $this->start_date > $nowDate ) {
				return false;
			}
		}
		return true;
	}

	/**
	 * Checks if the stop published date matches $now time
	 *
	 * @param  int  $now  Unix-Time
	 * @return boolean
	 */
	protected function checkStopDate( $now ) {
		$nullDate			=	$this->_db->getNullDate( 'date' );
		$nullDateTime		=	$this->_db->getNullDate();
		if ( ( $this->stop_date != $nullDate ) && ( $this->stop_date != $nullDateTime ) ) {
			if ( ! isset( $nowDate ) ) {
				$nowDate	=	$this->_db->getUtcDateTime( $now );
			}
			if ( $this->stop_date <= $nowDate ) {
				return false;
			}
		}
		return true;
	}
	/**
	 * Checks if promotion view access level is included in view access levels of $userId
	 *
	 * @param  int   $userId
	 * @return boolean
	 */
	protected function checkViewAccessLevel( $userId ) {
		return self::_checkUserViewAccessLevels( $userId, $this->viewaccesslevel );
	}
	/**
	 * Checks if promotion applies to groups to which $userId belongs
	 *
	 * @param  int   $userId
	 * @return boolean
	 */
	protected function checkUsergroups( $userId ) {
		return self::_checkUserGroupsInAllowedGroups( $userId, explode( '|*|', $this->usergroups ) );
	}
	/**
	 * Checks if promotion applies to groups to which $userId belongs
	 *
	 * @param  int   $userId
	 * @return boolean
	 */
	protected function checkUserId( $userId ) {
		return ( $this->user_ids === '' ) || ( $userId && in_array( (string) $userId, explode( ',', $this->user_ids ) ) );
	}
	/**
	 * Checks if promotion applies to the enabled/blocked state of the $userId (if guest returns true)
	 *
	 * @param  int      $userId
	 * @return boolean
	 */
	protected function checkUserEnabled( $userId ) {
		if ( $userId == 0 ) {
			return true;
		}

		$user				=	CBuser::getUserDataInstance( $userId );

		if ( ! $user) {
			return false;
		}

		switch ( $this->applies_to_blocked_users ) {
			case 1:
				// Only to enabled users:
				return ! $user->block;
			case 2:
				// Only to blocked users:
				return (bool) $user->block;
			case 3:
				// To all users:
				return true;
		}
		return false;
	}
	/**
	 * Checks if the owner of the promo corresponds to the $owner
	 *
	 * @param  int  $owner
	 * @return boolean
	 */
	protected function checkOwner( $owner ) {
		return ( $this->owner == 0 ) || ( $this->owner == $owner );
	}
	/**
	 * Check exclusivity of promo
	 *
	 * @param  string  $exclusivityMemoryFunction   'resetMemory' resets memory, 'memorize' memorizes result, applying exclusivity, 'checkOnly' checks only, not memorizing the exclusivity
	 * @param  array   $resultTexts                 RETURNED completed if needed
	 * @return boolean
	 */
	protected function checkExclusivity( $exclusivityMemoryFunction, &$resultTexts ) {

		$usedExclusivities			=&	self::resetExclusivityMemory( false );

		if ( $exclusivityMemoryFunction == 'resetMemory' ) {
			$usedExclusivities		=	array();
			return null;
		}

		if ( ! $this->exclusive_within_priority ) {
			// Not exclusive: so it's OK:
			return true;
		}

		if ( ! isset( $usedExclusivities[$this->priority] ) ) {
			// Exclusive but no other exclusive promotion of same priority used: we are first:
			if ( $exclusivityMemoryFunction == 'memorize' ) {
				// memorize and OK:
				$usedExclusivities[$this->priority]		=	$this->id;
			}
			return true;
		} elseif ( $usedExclusivities[$this->priority] == $this->id ) {
			// There is another exclusive promotion of same priority, but it's us ! : so it's still OK:
			return true;
		}
		// There is another exclusive promotion of same priority, but it's NOT us ! : so it's NOT OK:
		$resultTexts[]				=	CBTxt::T("Promotion does not apply because another exclusive promotion (id [PROMO_ID]) of same priority is already applied.", null, array( '[PROMO_ID]' => $usedExclusivities[$this->priority] ) );
		return false;
	}
	/**
	 * Checks if $this promotion applies to a given $planId
	 *
	 * @param  int                  $planId
	 * @param  cbpaidPaymentItem    $item
	 * @param  string               $reason
	 * @param  int                  $occurrence               0 = registration/upgrade to the subscription
	 * @param  int                  $startTime
	 * @return boolean
	 */
	protected function checkIfAppliesToTiming( $planId, $item, $reason, $occurrence, $startTime ) {
		$plan						=	cbpaidPlansMgr::getInstance()->loadPlan( $planId );

		// Calendar-validity and prorata-temporis ?
		if ( $this->cal_proratatemporis ) {
			$ratio					=	$this->getProRataTemporisPrice( $item, $plan, $reason, $occurrence, $startTime, 1 );
			if ( $ratio !== false ) {
				if ( $item ) {
					if ( ! isset( $this->_itemsDiscountRatio[$item->id] ) ) {
						$this->_itemsDiscountRatio[$item->id]		=	$ratio;
					} else {
						$this->_itemsDiscountRatio[$item->id]		=	$this->_itemsDiscountRatio[$item->id] * $ratio;
					}
				}
				return true;
			}
			return false;
		}
		return true;
	}
	/**
	 * Resets exclusivity memory for all checked promotions with checkPromotionApplicable()
	 *
	 * @param  boolean  $reset   TRUE (default): just resets memory (FALSE: for internal use only: returns the memory).
	 * @return null|array
	 */
	protected static function & resetExclusivityMemory( $reset = true ) {
		static $usedExclusivities	=	array();

		if ( $reset ) {
			$usedExclusivities		=	array();
			$null					=	null;
			return $null;
		} else {
			return $usedExclusivities;
		}
	}
	/**
	 * Check if a promotion is applicable, and if net returns the reason in $resultTexts
	 *
	 * @param  int                  $userId
	 * @param  int                  $planId
	 * @param  cbpaidPaymentBasket  $paymentBasket
	 * @param  cbpaidPaymentItem    $item
	 * @param  string               $reason
	 * @param  int                  $occurrence               0 = registration/upgrade to the subscription
	 * @param  boolean              $is_business
	 * @param  string               $buyerCountry
	 * @param  string               $buyerProvince
	 * @param  string               $buyerZip
	 * @param  int                  $sellerOwnerId
	 * @param  array                $couponsAlreadyInBasket
	 * @param  int                  $now
	 * @param  boolean              $isPublished
	 * @param  boolean              $alsoPossibleButUnusedCoupons
	 * @param  array                $resultTexts  (returned appended)
	 * @return boolean
	 */
	protected function checkPromotionApplicable( $userId, $planId, $paymentBasket, $item, $reason, $occurrence, $is_business, $buyerCountry, $buyerProvince, $buyerZip, $sellerOwnerId, $couponsAlreadyInBasket, $now, $isPublished, $alsoPossibleButUnusedCoupons, &$resultTexts ) {
		$r =	 (	(	$isPublished																		||(($resultTexts[$this->id][] =	CBTxt::T("Promotion is not active at this time.") ) && false			))
		&&	(	$this->checkStartDate( $now )																||(($resultTexts[$this->id][] =	CBTxt::T("Promotion is not yet applicable.") ) && false				))
		&&	(	$this->checkStopDate( $now )																||(($resultTexts[$this->id][] =	CBTxt::T("Promotion has expired.") ) && false							))
		&&	(	$this->checkIfAppliesToPlanId( $planId )													||(($resultTexts[$this->id][] =	CBTxt::T("Promotion does not apply to this item.") ) && false			))
		&&		$this->checkIfAppliesToPaymentReason( $reason, $resultTexts[$this->id] )
		&&		$this->checkIfAppliesToPaymentBasketAutoRecurring( $paymentBasket, $resultTexts[$this->id] )
		&&	(	$this->checkIfMaxDiscountUsesNotReached( $userId )											|| ($resultTexts[$this->id][] =	CBTxt::T("Maximum uses of this promotion has been reached.")			))
		&&	(	$this->checkBuyerGeoZone( $buyerCountry, $buyerProvince, $buyerZip )						|| ($resultTexts[$this->id][] =	CBTxt::T("Promotion does not apply to your geographic region.")		))
		&&	(	$this->checkAppliesToBusinessCondition( $is_business )										|| ($resultTexts[$this->id][] =	CBTxt::T("Promotion does not apply to your business customer status.")	))
		&&	(	$this->checkAllSameTimePlansRequired( $paymentBasket )										|| ($resultTexts[$this->id][] =	CBTxt::T("Promotion applies only if other items are purchased simultaneously.")	))
		&&		$this->checkActiveConditions( $userId, $resultTexts[$this->id], $paymentBasket )
		&&	(	$this->checkIfAppliesToTiming( $planId, $item, $reason, $occurrence, $now )					||(($resultTexts[$this->id][] =	CBTxt::T("Promotion does not apply to this item.") )					))
		&&	(	$this->checkViewAccessLevel( $userId )														|| ($resultTexts[$this->id][] =	CBTxt::T("Promotion does not apply to your view access level.")		))
		&&	(	$this->checkUsergroups( $userId )															|| ($resultTexts[$this->id][] =	CBTxt::T("Promotion does not apply to your user group.")				))
		&&	(	$this->checkUserId( $userId )																|| ($resultTexts[$this->id][] =	CBTxt::T("Promotion does not apply to your login.")					))
		&&	(	$this->checkUserEnabled( $userId )															|| ($resultTexts[$this->id][] =	CBTxt::T("Promotion does not apply to blocked users.")						))
		&&	(	$this->checkOwner( $sellerOwnerId )															|| ($resultTexts[$this->id][] =	CBTxt::T("Promotion does not apply to this merchant.")					))
		);
		if ( $r ) {
			// Promo is applicable if coupons and exclusivity are verified: Verify that needed coupons are already in basket first:
			if ( $this->checkPromotionCoupons( $couponsAlreadyInBasket, $userId ) ) {
				// Yes, they are in basket (or are not needed): Check exclusivity normally, memorizing this priority use if promo has exclusivity:
				$this->checkExclusivity( 'memorize', $resultTexts[$this->id] );
			} else {
				// No, required coupon is not in basket:
				if ( $alsoPossibleButUnusedCoupons ) {
					// We have been asked to also return promos that are possible if the buyer knows the coupon code:
					// Check exclusivity, but do not memorize in case it is exclusive, that way other promos with same priority can still apply (this fixes bug #2743):
					$this->checkExclusivity( 'checkOnly', $resultTexts[$this->id] );
				} else {
					// This is the real test: This promotion does not apply:
					$resultTexts[$this->id][]		=	CBTxt::T("Promotion does not apply without corresponding valid coupon code.");
				}
			}
		}
		return ( ! isset( $resultTexts[$this->id] ) );
	}
	/**
	 * Checks if one of the $couponCodes is corresponding to that promotion for that $buyerUserId
	 *
	 * @param  string|array  $couponCodes
	 * @param  int           $buyerUserId
	 * @return boolean|string  TRUE if not a coupon-based promotion, FALSE if couponCodes are not matching or (string) Valid Coupon Used
	 */
	public function checkPromotionCoupons( $couponCodes, $buyerUserId ) {
		if ( $this->promotion_type == 'coupon' ) {
			foreach ( (array) $couponCodes as $cc ) {
				if ( ( strlen( $cc ) > 0 ) && ( false !== ( $ccUsed = $this->checkCoupon( $cc, $buyerUserId ) ) ) ) {
					return $ccUsed;		// returns the coupon used.
				}
			}
			return false;
		}
		return true;
	}
	/**
     * Resets all totalizers, to be called before getPromotionsForItemWithoutCouponCodeCheck
     *
     * @param  boolean  $isPublished
     */
	public static function resetAllPromotionsTotalizers( $isPublished ) {
	$promotions		=	self::getInstances( $isPublished );
		foreach ( $promotions as $promo ) {
			$promo->resetTotalizer();
		}
	}

	/**
	 * loads and returns an array of potentially applicable cbpaidsalestaxTotalizertype for a given $taxRuleId
	 * filtered by all geographic zone settings and by published state
	 * BUT not by time: 'start_date' and 'stop_date' of each tax must still be evaluated properly
	 *
	 * @param  cbpaidPaymentItem    $item
	 * @param  cbpaidPaymentBasket  $paymentBasket
	 * @param  string               $reason
	 * @param  int                  $occurrence
	 * @param  int                  $now
	 * @param  boolean              $isPublished
	 * @param  boolean              $alsoPossibleButUnusedCoupons
	 * @param  array                $resultTexts  (returned)
	 * @return cbpaidpromotionTotalizertype[]  indexed by id, sorted by 'ordering'
	 */
	public static function getPromotionsForItemWithoutCouponCodeCheck( $item, $paymentBasket, $reason, $occurrence, $now, $isPublished, $alsoPossibleButUnusedCoupons, &$resultTexts ) {
		/** @var $applicablePromotions cbpaidpromotionTotalizertype[] */
		$applicablePromotions						=	array();

		$planId										=	$item->plan_id;

		$promotions									=	self::getInstances( $isPublished );

		// Resets the exclusivity memory for this item:
		self::resetExclusivityMemory();

		$couponsAlreadyInBasket						=	cbpaidPromotionCouponsHelper::getCouponsOfBasket( $paymentBasket );
		// Main pass: collects $applicablePromotions by priority and ordering:
		foreach ( $promotions as $promo ) {
			$checkResultTexts						=	null;
			if ( $promo->checkPromotionApplicable( $paymentBasket->user_id, $planId, $paymentBasket, $item, $reason, $occurrence, $paymentBasket->is_business, $paymentBasket->address_country_code, $paymentBasket->address_state, $paymentBasket->address_zip, $paymentBasket->owner, $couponsAlreadyInBasket, $now, $isPublished, $alsoPossibleButUnusedCoupons, $checkResultTexts ) ) {
				$applicablePromotions[$promo->id]	=	$promo;
			} else {
				self::array_merge_recursive_level0( $resultTexts, $checkResultTexts );
			}
		}

		// Second pass: if we were looking for applicable coupons that have not yet been applied, we need to recheck them a second time WITHOUT resetting exclusivity memory:
		if ( $alsoPossibleButUnusedCoupons ) {
			foreach ( $applicablePromotions as $k => $promo ) {
				if ( $promo->promotion_type == 'coupon' ) {
					$checkResultTexts				=	null;
					if ( ! $promo->checkPromotionApplicable( $paymentBasket->user_id, $planId, $paymentBasket, $item, $reason, $occurrence, $paymentBasket->is_business, $paymentBasket->address_country_code, $paymentBasket->address_state, $paymentBasket->address_zip, $paymentBasket->owner, $couponsAlreadyInBasket, $now, $isPublished, $alsoPossibleButUnusedCoupons, $checkResultTexts ) ) {
						// Unused coupon is not usable anymore
						self::array_merge_recursive_level0( $resultTexts, $checkResultTexts );
						unset( $applicablePromotions[$k] );
					}

				}
			}
		}
		return $applicablePromotions;
	}
	/**
	 * loads and returns an array of potentially applicable cbpaidsalestaxTotalizertype for a given $taxRuleId
	 * filtered by all geographic zone settings and by published state
	 * BUT not by time: 'start_date' and 'stop_date' of each tax must still be evaluated properly
	 *
	 * @param  cbpaidProduct           $plan
	 * @param  int                     $userId
	 * @param  string                  $reason
	 * @param  int                     $occurrence
	 * @param  cbpaidPaymentItem|null  $item
	 * @param  int                     $startTime
	 * @param  boolean                 $overridePlansDisplay
	 * @param  array|null|boolean      $resultTexts            (returned)
	 * @return cbpaidpromotionTotalizertype[]                  indexed by id, sorted by 'ordering'
	 */
	public static function getPromotionsApplicableForPlan( $plan, $userId, $reason, $occurrence, $item, $startTime = null, $overridePlansDisplay = false, &$resultTexts = false ) {
		global $_CB_framework;

		$applicablePromotions						=	array();

		$paymentBasket								=	null;
		if ( $startTime == null ) {
			$startTime								=	$_CB_framework->now();
		}
		$isPublished								=	true;
		$alsoPossibleButUnusedCoupons				=	true;

		$promotions									=	self::getInstances( $isPublished, $overridePlansDisplay );

		$cbpaidUser									=	cbpaidUserExtension::getInstance( $userId );

		/** @var $user cbpaidUserWithSubsFields */
		$is_business								=	( $cbpaidUser->getInvoiceAddressField( 'cb_subs_inv_vat_number' ) != '' ) || ( $cbpaidUser->getInvoiceAddressField( 'cb_subs_inv_payer_business_name' ) != '' );
		$address_country_code						=	$cbpaidUser->getInvoiceAddressField( 'cb_subs_inv_address_country' );
		$address_state								=	$cbpaidUser->getInvoiceAddressField( 'cb_subs_inv_address_state' );
		$address_zip								=	$cbpaidUser->getInvoiceAddressField( 'cb_subs_inv_address_state' );
		$planOwner									=	$plan->owner;

		// Resets the exclusivity memory for this plan:
		self::resetExclusivityMemory();

		$couponsAlreadyInBasket						=	array();		// later cbpaidPromotionCouponsHelper::getCouponsOfBasket( $paymentBasket );

		// Main pass: collects $applicablePromotions by priority and ordering:
		foreach ( $promotions as $promo ) {
			$promo->resetTotalizer();
			$checkResultTexts						=	null;
			if ( $promo->checkPromotionApplicable( $userId, $plan->id, $paymentBasket, $item, $reason, $occurrence, $is_business, $address_country_code, $address_state, $address_zip, $planOwner, $couponsAlreadyInBasket, $startTime, $isPublished, $alsoPossibleButUnusedCoupons, $checkResultTexts ) ) {
				$applicablePromotions[$promo->id]	=	$promo;
			} else {
				if ( $checkResultTexts ) {
					self::array_merge_recursive_level0( $resultTexts, $checkResultTexts );
				}
			}
		}
		// If we later take in account coupons in basket: this will be needed: Second pass: if we were looking for applicable coupons that have not yet been applied, we need to recheck them a second time WITHOUT resetting exclusivity memory-
		return $applicablePromotions;

	}
	/**
	 * Merges into $array1[$planId] = array( messages ) same from $array2
	 *
	 * @param  array|null of array of text  $array1  IN + OUT
	 * @param  array|null of array of text  $array2
	 */
	private static function array_merge_recursive_level0( &$array1, $array2 ) {
		if ( is_array( $array2 ) ) {
			foreach ( $array2 as $k => $v ) {
				if ( is_array( $v ) ) {
					foreach ( $v as $t ) {
						$array1[$k][]	=	$t;
					}
				}
			}
		}
	}
    /**
     * Gives pro-rata temporis price for plan if set so, otherwise full price same as $plan->get( $varRate );
     *
	 * @param  cbpaidPaymentItem  $item
     * @param  cbpaidProduct      $plan        Plan to check discount for
     * @param  string             $reason      Payment reason: 'N'=new subscription (default), 'R'=renewal, 'U'=update
     * @param  int                $occurrence  = 0 : first occurrence, >= 1: next occurrences
     * @param  int                $now         Unix time now
     * @param  float|int          $quantity    Quantity purchased
     * @return float                           Pro-rata-temporis price
     */
	protected function getProRataTemporisPrice( $item, $plan, $reason, $occurrence, $now, $quantity = 1 ) {
		global $_CB_framework;

		$ret							=	false;

		$varName						=	$plan->getPlanVarName( $reason, $occurrence, 'validity' );
		// Calendar-validity and prorata-temporis ?
		if ( $this->cal_proratatemporis && $plan->isCalendarValidity( $varName ) ) {
			// Ok we can now work on this:
			$maxdperiodsmissed			=	$this->cal_maxdperiodsmissed;
			$catchuppromotion			=	$this->cal_catchuppromotion;

			$periodmissed				=	$this->cal_periodmissed;
			$fullmissed					=	$this->cal_fullmissed;

			// Find out adjusted time of $now according to cal_fullmissed and cal_periodmissed:
			if ( preg_match( '/^U:\d{4}-00-00 00:00:00$/', $plan->get( $varName ) ) ) {
				// Calendar year:
				list( $mm, $dd )		=	explode( '-', $plan->calendarYearStart( $varName ) );
			} else {
				$mm						=	1;
				$dd						=	1;
			}
			$strtotimeStr	=	array(	'1S'	=>	array(	'1'	=>	'now',						 										'0'	=>	'now + 1 second' ),
										'1D'	=>	array(	'1'	=>	'today',					 										'0'	=>	'tomorrow' ),					// at midnight
										'1M'	=>	array(	'1'	=>	'this month +' . ($dd - 1 ) . ' days',								'0'	=>	'next month +' . ($dd - 1 ) . ' days' ),
										'1Y'	=>	array(	'1'	=>	'this year +' . ($mm - 1 ) . ' months +' . ($dd - 1 ) . ' days',	'0'	=>	'next year +' . ($mm - 1 ) . ' months +' . ($dd - 1 ) . ' days' ) );

			if ( $now == null ) {
				$now					=	$_CB_framework->now();
			}
            if ( isset( $strtotimeStr[$periodmissed][$fullmissed] ) ) {
				$nowAdjusted			=	cbpaidTimes::getInstance()->localStrToTime( $strtotimeStr[$periodmissed][$fullmissed], $now );
			} else {
				$nowAdjusted			=	$now;
			}

			// Get Real $startTime and $expiryTime of the full plan period:
			$startTime					=	$now;

			$status						=	'I';
			if ( $item ) {
				$subscription			=	$item->loadSubscription();
				if ( $subscription ) {
					$status				=	$subscription->status;
				}
			}
			// WARNING: This adjusts $startTime to the real Start-time, which is wanted here
			$expiryTime					=	$plan->getExpiryTime( $startTime, $varName, $quantity, $reason, $status );

			if ( $catchuppromotion == 2 ) {
				// Only catchup promo: either it's expired and discount is in full (1) or it's not expired and promo does not apply (FALSE):
				if ( $now > $expiryTime ) {
					$ret				=	1;
				} else {
					$ret				=	false;
				}
			} elseif ( ( $catchuppromotion == 0 ) && ( $now > $expiryTime ) ) {
				// NOT a catchup promo: if already expired, promo does not apply (FALSE)
				$ret					=	false;
			} elseif ( ( $now <= $startTime ) || ( $nowAdjusted <= $startTime ) ) {
				// This promotion can not be applied if the subscription can't start now or only starts now (FALSE):
				$ret					=	false;
			} else {
				// Pro-rate temporis the missed ratio:
				$ret					=	$this->_proportion( $startTime, $nowAdjusted, $expiryTime, $periodmissed, $maxdperiodsmissed );
			}
		}
		return $ret;
	}
	/**
	 * Calculates proportion ( $nowAdjusted - $startTime ) / ( $expiryTime - $startTime )
	 *
	 * @param  int     $startTime
	 * @param  int     $nowAdjusted
	 * @param  int     $expiryTime
	 * @param  string  $periodmissed
	 * @param  int     $maxdperiodsmissed
	 * @return float|boolean          INT: 0 before start, FLOAT 0.0 - 1.0: between $startTime and $expiryTime, BOOLEAN FALSE: after $startTime
	 */
	protected function _proportion( $startTime, $nowAdjusted, $expiryTime, $periodmissed, $maxdperiodsmissed ) {
		// Pro-rate temporis the missed ratio:
		if ( $nowAdjusted <= $startTime ) {
			$proportionMissed				=	0;
		} else {

			if ( $nowAdjusted > $expiryTime ) {
				$nowAdjusted				=	$expiryTime;
			}

			switch ( $periodmissed ) {
				case '1S':
					$periods				=	$nowAdjusted - $startTime;
					$totalPeriods			=	$expiryTime - $startTime;
					break;

				case '1D':
					$periods				=	round( ( $nowAdjusted - $startTime ) / ( 3600 * 24 ) );
					$totalPeriods			=	round( ( $expiryTime - $startTime ) / ( 3600 * 24 ) );
					break;

				case '1M':
				case '1Y':
				default:
					// Simplistic fully proportional one:		$missedRatio	=	( $nowAdjusted - $startTime ) / ( $expiryTime - $startTime );
					list($ys, $cs, /*$ds*/)	=	sscanf( gmdate( 'Y-m-d', $startTime + 1 ),  '%d-%d-%d %d:%d:%d' );
					list($yn, $cn, /*$dn*/)	=	sscanf( gmdate( 'Y-m-d', $nowAdjusted + 1 ),  '%d-%d-%d %d:%d:%d' );
					list($ye, $ce, /*$de*/)	=	sscanf( gmdate( 'Y-m-d', $expiryTime + 1 ),  '%d-%d-%d %d:%d:%d' );

					$periods				=	( ( $cn - $cs ) + ( 12 * ( $yn - $ys ) ) );
					$totalPeriods			=	( ( $ce - $cs ) + ( 12 * ( $ye - $ys ) ) );
					if ( $periodmissed == '1Y' ) {
						$periods			=	round( $periods / 12 );
						$totalPeriods		=	round( $totalPeriods / 12 );
					}
					;
					break;
			}
			if ( $maxdperiodsmissed && ( $periods > $maxdperiodsmissed ) ) {
				$periods					=	$maxdperiodsmissed;
			}
			$proportionMissed				=	min( $periods / $totalPeriods, 1.0 );
		}
		return $proportionMissed;
	}
	/**
	 * Reset totalizer compounders
	 *
	 * @return void
	 */
	public function resetTotalizer( ) {
		$this->_itemsUsingThisPromo			=	array();
		$this->_itemsDiscountRatio			=	array();
		$this->_amount_used_in_basket		=	0;
	}

	/**
	 * Sets the user id for the calculation functions below: getAmountBeforePercents, getPercents and getAmountAfterPercents
	 *
	 * @param int|null $userId
	 */
	public function setForUserId( $userId )
	{
		$this->_forUserId		=	$userId;
	}

	/**
	 * Sets the basket for the calculation functions below: getAmountBeforePercents, getPercents and getAmountAfterPercents
	 *
	 * @param cbpaidPaymentBasket $paymentBasket
	 */
	public function setBasket( $paymentBasket ) {
		$this->_paymentBasket	=	$paymentBasket;
	}
	/**
	 * Sets the basket item for the calculation functions below: getAmountBeforePercents, getPercents and getAmountAfterPercents
	 *
	 * @param cbpaidPaymentItem $item
	 */
	public function setPaymentItem( $item ) {
		$this->_paymentItem		=	$item;
	}
	/**
	 * Applies CB substitutions in $var, based on $this->setForUserId() or $this->_paymentBasket->user_id
	 * @param  string  $var  String to substitute
	 * @return string        Substituted string
	 */
	public function replaceUserVars( $var ) {
		if ( strpos( $var, '[' ) ) {
			$cbUserId				=	( $this->_forUserId ? $this->_forUserId : ( $this->_paymentBasket ? $this->_paymentBasket->user_id : null ) );
			$cbUser					=	CBuser::getInstance( (int) $cbUserId, false );
			$var				=	$cbUser->replaceUserVars( $var, false, false, null, false );
		}
		return $var;
	}
	/**
	 * Applies  $periodProrater
	 * Converts $discountAmount from $discountCurrency into $amountCurrency
	 * And applies all applicable maximums to $discountAmount (in $amountCurrency)
	 *
	 * @param  float|null  $discountAmount
	 * @param  string      $discountCurrency
	 * @param  float       $amountToDiscount (for the $periodProrater -ed period)
	 * @param  string      $amountCurrency
	 * @param  float       $periodProrater
	 * @return float|null
	 */
	private function _getAmountUpToMaxAllowedInAmountCurrency( $discountAmount, $discountCurrency, $amountToDiscount, $amountCurrency, $periodProrater ) {
		if ( $discountAmount ) {
			if ( $discountCurrency == $amountCurrency ) {
				$discountAmountInAmountCurr			=	$discountAmount * $periodProrater;
			} else {
				$_CBPAY_CURRENCIES					=	cbpaidApp::getCurrenciesConverter();
				$discountAmountInAmountCurr			=	$_CBPAY_CURRENCIES->convertCurrency( $discountCurrency, $amountCurrency, (float) ( $discountAmount * $periodProrater ) );		// null if cannot convert
			}

			if ( $this->applies_to_items == 1 ) {
				// Apply promotion amount to all applicable items in order until promotion amount is depleted:
				$usableDiscount						=	null;

				if ( $discountAmountInAmountCurr >= 0 ) {
					$availableDiscount				=	$discountAmountInAmountCurr - $this->_amount_used_in_basket;

					if ( $availableDiscount > 0 ) {
						// do not allow a discount to go further than value to discount, so that we don't go below zero:
						$usableDiscount				=	min( $availableDiscount, $amountToDiscount );
						$this->_amount_used_in_basket += $usableDiscount;
					}
				} else {
					$availableDiscount				=	$discountAmountInAmountCurr - $this->_amount_used_in_basket;

					if ( $availableDiscount < 0 ) {
						$usableDiscount				=	$availableDiscount;
						$this->_amount_used_in_basket += $usableDiscount;
					}
				}
			} else {
				// Apply full promotion amount multiple times to each applicable item line:

				// do not allow a discount to go further than value to discount, so that we don't go below zero:
				$usableDiscount						=	min( $discountAmountInAmountCurr, $amountToDiscount );
			}
		} else {
			$usableDiscount							=	$discountAmount;
		}
		return $usableDiscount;
	}
	/**
	 * Checks if $this promotion applies to this period (first period if $isFirstPeriod==true, otherwise next periods)
	 *
	 * @param  boolean  $isFirstPeriod  TRUE: first period, FALSE: followup renewals period
	 * @return boolean                  TRUE: Applies
	 */
	private function _appliesToIsFirst( $isFirstPeriod ) {
		return ( ( $this->applies_to_first_payment && $isFirstPeriod ) || ( $this->applies_to_recurrings && ! $isFirstPeriod ) );
	}
	/**
	 * Applies calendar year discount ratios to first period only
	 *
	 * @param  float|null  $amountOrPercents
	 * @param  boolean  $isFirstPeriod
	 * @return float|int|null
	 */
	private function _applyRatio( $amountOrPercents, $isFirstPeriod ) {
		if ( $isFirstPeriod ) {
			if ( $amountOrPercents && isset( $this->_itemsDiscountRatio[$this->_paymentItem->id] ) ) {
				return $amountOrPercents * $this->_itemsDiscountRatio[$this->_paymentItem->id];
			} else {
				return $amountOrPercents;
			}
		} elseif ( $this->cal_proratatemporis ) {		// adding this if fixes bug #3624 at computation time
			return null;
		} else {
			return $amountOrPercents;
		}
	}
	/**
	 * Computes fixed amount before percentage, or if only fixed amount, fixed amount
	 *
	 * @param  float    $amount
	 * @param  float    $amountTaxExcl
	 * @param  float    $periodProrater
	 * @param  boolean  $isFirstPeriod
	 * @param  string   $currency_code
	 * @return float|int|null
	 */
	public function getAmountBeforePercents( $amount, $amountTaxExcl, $periodProrater, $isFirstPeriod, $currency_code ) {
		/*
		<option value="percentage">A percentage of the item price</option>
		<option value="fixed">A fixed amount</option>
		<option value="fixed_percent">A fixed amount added/substracted from the item price, plus a percentage</option>
		<option value="percent_fixed">A percentage of the item price, added/substracted by a fixed amount</option>
		<option value="value_dependent">A fixed amount depending on the corresponding items price</option>
		*/
		$return							=	null;
		if ( $this->_appliesToIsFirst( $isFirstPeriod ) ) {
			if ( in_array( $this->discount_type, array( 'fixed', 'percent_fixed' ) ) ) {
				$settingCurrency			=	( $this->currency ? $this->currency : cbpaidApp::settingsParams()->get( 'currency_code', 'USD' ) );
				$discountAmount				=	$this->replaceUserVars( $this->amount );
				$return						=	- $this->_getAmountUpToMaxAllowedInAmountCurrency( $discountAmount, $settingCurrency, $amount, $currency_code, $periodProrater );
			} elseif ( $this->discount_type == 'value_dependent') {
				$step						=	$this->_findTaxStep( $amountTaxExcl, $this->stages );
				if ( $step && substr( $step, -1 ) !== '%' ) {
					$discountAmount			=	(float) $step;
					$settingCurrency		=	( $this->currency ? $this->currency : cbpaidApp::settingsParams()->get( 'currency_code', 'USD' ) );
					$return					=	- $this->_getAmountUpToMaxAllowedInAmountCurrency( $discountAmount, $settingCurrency, $amount, $currency_code, $periodProrater );
				}
			} elseif ( $this->discount_type == 'cbfield_amount') {
				if ( $isFirstPeriod || ! $this->amount_cbfield_deduct ) {			// deducting field amount on autorecurrings is not possible, as there is no way to change autorecurrings on most paymen processors.
					$cbUserId				=	( $this->_forUserId ? $this->_forUserId : ( $this->_paymentBasket ? $this->_paymentBasket->user_id : null ) );
					$cbUser					=	CBuser::getInstance( (int) $cbUserId );

					if ( $cbUser ) {
						if ( $this->currency_cbfield ) {
							$fieldCurrency	=	cbpaidUserExtension::getInstance( (int) $cbUserId )->getFieldValue( (int) $this->currency_cbfield, true );
						} else {
							$fieldCurrency	=	null;
						}
						if ( ! $fieldCurrency ) {
							$fieldCurrency	=	cbpaidApp::settingsParams()->get( 'currency_code', 'USD' );
						}

						$fieldAmount		=	cbpaidUserExtension::getInstance( (int) $cbUserId )->getFieldValue( (int) $this->amount_cbfield, true );
						if ( $fieldAmount !== null ) {
							$discountAmount	=	(float) $fieldAmount;
							if ( $discountAmount ) {
								$return		=	- $this->_getAmountUpToMaxAllowedInAmountCurrency( $discountAmount, $fieldCurrency, $amount, $currency_code, $periodProrater );
							} else {
								$return		=	0.0;
							}
						}

					}
				}
			}
		}
		return $this->_applyRatio( $return, $isFirstPeriod );
	}
	/**
	 * Computes the percentage on amount
	 *
	 * @param  float    $amount
	 * @param  float    $amountTaxExcl
	 * @param  float    $periodProrater
	 * @param  boolean  $isFirstPeriod
	 * @return float|int|null
	 */
	public function getPercents( $amount, $amountTaxExcl, $periodProrater, $isFirstPeriod ) {
		$return							=	null;
		if ( $this->_appliesToIsFirst( $isFirstPeriod ) ) {
			if ( in_array( $this->discount_type, array( 'percentage', 'percent_on_part', 'fixed_percent', 'percent_fixed' ) ) ) {
				$rate					=	$this->replaceUserVars( $this->rate );
				$return					=	- (float) $rate / 100;
			} elseif ( $this->discount_type == 'value_dependent') {
				$step					=	$this->_findTaxStep( $amountTaxExcl, $this->stages );
				if ( substr( $step, -1 ) === '%' ) {
					$return				=	- (float) substr( $step, 0, -1 ) / 100;
				}
			} elseif ( $this->discount_type == 'cbfield_percent') {
				$cbUserId				=	( $this->_forUserId ? $this->_forUserId : ( $this->_paymentBasket ? $this->_paymentBasket->user_id : null ) );
				$cbUser					=	CBuser::getInstance( (int) $cbUserId );

				if ( $cbUser ) {
					$value				=	cbpaidUserExtension::getInstance( (int) $cbUserId )->getFieldValue( (int) $this->rate_cbfield, true );
					if ( $value ) {
						$return			=	- ( (float) $value ) / 100;
					} else {
						$return			=	0;
					}
				}
			}
			if ( $return !== null ) {
				$return					*=	$periodProrater;
			}
		}
		return $this->_applyRatio( $return, $isFirstPeriod );
	}
	/**
	 * Computes the amount after percentage, only if it's combined
	 *
	 * @param  float    $amount
	 * @param  float    $amountTaxExcl
	 * @param  float    $periodProrater
	 * @param  boolean  $isFirstPeriod
	 * @param  string   $currency_code
	 * @return float|null
	 */
	public function getAmountAfterPercents( $amount, $amountTaxExcl, $periodProrater, $isFirstPeriod, $currency_code ) {
		$return						=	null;
		if ( $this->_appliesToIsFirst( $isFirstPeriod ) ) {
			if ( in_array( $this->discount_type, array( 'fixed_percent', 'percent_on_part' ) ) ) {
				$settingCurrency		=	( $this->currency ? $this->currency : cbpaidApp::settingsParams()->get( 'currency_code', 'USD' ) );
				$discountAmount			=	$this->replaceUserVars( $this->amount );
				$return					=	- $this->_getAmountUpToMaxAllowedInAmountCurrency( $discountAmount, $settingCurrency, $amount, $currency_code, $periodProrater );

				if ( $this->discount_type == 'percent_on_part' ) {
					$rate				=	$this->replaceUserVars( $this->rate );
					$return				=	( (float) $rate / 100 ) * $return;
				}
			}
		}
		return $this->_applyRatio( $return, $isFirstPeriod );
	}
}

/**
 * Model for Promotions Uses storage
 */
class cbpaidPromotionUse extends cbpaidTable {
	public $id;					// sql:int(11)
	public $time_completed;		// sql:datetime null="true"
	public $state;				// sql:char(1) default="I"nvalid, "A"ctive
	public $promotion_id;		// sql:int(11)
	public $user_id;			// sql:int(11)
	public $payment_basket_id;	// sql:bigint(20) unsigned="true"
	public $coupon_code;		// sql:varchar(64)
	public $currency;			// sql:varchar(3)
	public $order_amount;		// sql:decimal(16,8) null="true"
	public $discount_amount;	// sql:decimal(16,8) null="true"
	public $referrer;			// sql:varchar(256)
	public $integrations;		// sql:varchar(255)
	/**
	 * Constructor
	 *
	 * @param  DatabaseDriverInterface  $db
	 */
	public function __construct( &$db = null ) {
		parent::__construct( '#__cbsubs_promotions_uses', 'id', $db );
		$this->_historySetLogger();
	}
	/**
	 * Counts the promotions used by $userId (0 = all) for $promotionId
	 * @param  int  $promotionId  Promotion id
	 * @param  int  $userId       User id (Default: 0 = all users)
	 * @return int                Promotions uses
	 */
	public static function countPromoUses( $promotionId, $userId = 0 ) {
		$me		=	new self();
		$conditions		=	array( 'promotion_id = ' . (int) $promotionId,
								   'state = "A"' );
		if ( $userId ) {
			$conditions[]	=	'user_id = ' . (int) $userId;
		}
		return $me->countRows( implode( ' AND ', $conditions ) );
	}
	/**
	 * BACKEND RENDERING METHODS:
	 */
	/**
	 * USED by XML interface ONLY !!! Renders amount
	 *
	 * @param  string           $price
	 * @param  ParamsInterface  $params
	 * @return string                    HTML to display
	 */
	public function renderAmount( $price, $params ) {
		if ( $price ) {
			$cbpaidMoney			=	cbpaidMoney::getInstance();
			$priceRoundings			=	$params->get('price_roundings', 100 );
			$priceRounded			=	$cbpaidMoney->renderNumber( round( $price * $priceRoundings ) / $priceRoundings );
		} else {
			$priceRounded			= '-';
		}
		return $priceRounded;
	}
}
/**
 * This helper class handles the storage of coupons into basket's integrations.
 */
class cbpaidPromotionCouponsHelper {
	/**
	 * gets array of coupons texts stored in $paymentBasket
	 *
	 * @param  cbpaidPaymentBasket             $paymentBasket
	 * @return string[]
	 */
	public static function getCouponsOfBasket( $paymentBasket ) {
		$coupons		=	$paymentBasket->getParam( 'promotions_coupons', null, 'integrations' );
		if ( $coupons ) {
			$coupons	=	explode( '|*|', $coupons );
		} else {
			$coupons	=	array();
		}
		return $coupons;
	}

    /**
     * stores array of coupons into existing $paymentBasket
     *
     * @param  cbpaidPaymentBasket  $paymentBasket
     * @param  string[]             $coupons
     */
	public static function setCouponsOfBasket( &$paymentBasket, $coupons ) {
		$coupons		=	implode( '|*|', $coupons );
		$paymentBasket->setParam( 'promotions_coupons', $coupons, 'integrations' );
		if ( $paymentBasket->id ) {
			$paymentBasket->store();
		}
	}
}

/**
 * Class promotion totalizer storage in baskets (like payment items)
 */
class cbpaidPaymentTotalizer_promotion extends cbpaidPaymentTotalizerCompoundable {
/* Inherited:
	public $id					= null;
	public $payment_basket_id;
	public $ordering		=	0;
	public $totalizer_type;
	public $totalizer_id;
	public $quantity;
	public $unit;
	public $artnum;
	public $description;
	public $currency;
	public $rate;
	public $first_rate;
	public $tax_rule_id;

	protected $_itemIndexes;
*/
	/**
	 * @var cbpaidpromotionTotalizertype
	 */
	protected $_totalizertypeSettings;
	/**
	 * Constructor
	 *
	 * @param  DatabaseDriverInterface  $db
	 */
	public function __construct( &$db = null ) {
		parent::__construct( $db );
	}
	/** DEPRECATED?
	 *
	 * @param  cbpaidPaymentBasket  $paymentBasket
	private function getBasketGeoZone( $paymentBasket ) {
		$geoZone				=	new cbpaidGeoZone();
		$geoZone->loadGeoZonesList( $paymentBasket->address_country_code, $paymentBasket->address_state, $paymentBasket->address_zip );
	}
	 */
	/**
	 * Creates entries for totalizer
	 *
	 * @param  cbpaidPaymentBasket       $paymentBasket
	 * @param  cbpaidPaymentItem[]       $paymentItems
	 * @param  cbpaidPaymentTotalizer[]  $taxableTotalizers
	 * @param  string[]                  $newCouponCodes     (optional)
	 * @param  array|null                $resultTexts
	 * @return cbpaidpromotionTotalizertype[]
	 */
	public static function getApplicablePromotionsWithoutCouponsChecks( $paymentBasket, $paymentItems, /** @noinspection PhpUnusedParameterInspection */ $taxableTotalizers, $newCouponCodes, &$resultTexts ) {
		global $_CB_framework;

		$params											=	cbpaidApp::settingsParams();
		if ( $params->get( 'integration_cbsubspromotions_enabled', 1 ) != 1 ) {
			$resultTexts[0][]							=	CBTxt::T("Promotions are not enabled in general settings.");
			return array();
		}

		$now											=	$_CB_framework->now();

		$alsoPossibleButUnusedCoupons					=	( $newCouponCodes === null );
		// collect all promotions applicable to this payment basket items into $promotions:
		cbpaidpromotionTotalizertype::resetAllPromotionsTotalizers( true );
		$promotions												=	array();
		foreach ( $paymentItems as $paymentItemIndex => &$item ) {
			$subscription	=	$item->loadSubscription();
			if ( $subscription ) {
				$occurrence	=	$subscription->getOccurrence();
			} else {
				$occurrence	=	0;
			}
			$itemPromos		=	cbpaidpromotionTotalizertype::getPromotionsForItemWithoutCouponCodeCheck( $item, $paymentBasket, $item->reason, $occurrence, $now, true, $alsoPossibleButUnusedCoupons, $resultTexts );
			foreach ( $itemPromos as $promoid => $promo ) {
				if ( ( $newCouponCodes === null ) || $promo->checkPromotionCoupons( $newCouponCodes, $paymentBasket->user_id ) ) {
					if ( ! isset( $promotions[$promoid] ) ) {
						$promotions[$promoid]						=	$promo;
					}
					$promotions[$promoid]->_itemsUsingThisPromo[]	=	$paymentItemIndex;
				}
			}
		}
		unset( $item );		// was used as &$item
		unset( $promo );

		return $promotions;
	}
	/**
	 * Checks if $couponCode coupon is applicable to basket $paymentBasket and if not puts customer-displayable reasons in $resultTexts
	 *
	 * @param  string|array          $couponCodes
	 * @param  cbpaidPaymentBasket   $paymentBasket
	 * @param  array|null            $resultTexts
	 * @return boolean|string        Coupon used, or FALSE if $couponCodes are not applicable to basket
	 */
	public static function isCouponApplicableToBasket( $couponCodes, $paymentBasket, &$resultTexts ) {
		$isApplicable			=	false;
		$promotions				=	self::getApplicablePromotionsWithoutCouponsChecks( $paymentBasket, $paymentBasket->loadPaymentItems(), $paymentBasket->loadPaymentTotalizers(), null, $resultTexts );
		foreach ( $promotions as $promo ) {
			$couponUsed			=	$promo->checkPromotionCoupons( $couponCodes, $paymentBasket->user_id );
			if ( is_string( $couponUsed ) ) {
				$isApplicable	=	$couponUsed;
				break;
			}
		}
		return $isApplicable;
	}
	/**
	 * Creates entries for totalizer
	 *
	 * @param  cbpaidPaymentBasket       $paymentBasket
	 * @param  cbpaidPaymentItem[]       $paymentItems
	 * @param  cbpaidPaymentTotalizer[]  $taxableTotalizers
	 * @param  string                    $paymentTotalizerType
	 * @param  callable                  $addTotalizerToBasketFunc
	 */
	public static function createTotalizerEntries( $paymentBasket, $paymentItems, $taxableTotalizers, $paymentTotalizerType, $addTotalizerToBasketFunc ) {
		$myClassName									=	__CLASS__;			// 'cbpaidPaymentTotalizer_' . $paymentTotalizerType;

		$coupons										=	cbpaidPromotionCouponsHelper::getCouponsOfBasket( $paymentBasket );
		$resultTexts									=	null;
		$promotions										=	self::getApplicablePromotionsWithoutCouponsChecks( $paymentBasket, $paymentItems, $taxableTotalizers, $coupons, $resultTexts );

		//TODO Display resultsTexts[$promo_id][] to help debug conditions of promos!

		// collect all applicable promotions ordered by priority,ordering,id into $promotionsUsed:
		$promotionsUsed									=	array();
		foreach ( $promotions as $promo ) {
				$promotionsUsed[(int) $promo->priority][(int) $promo->ordering][(int) $promo->id]		=	$promo;
		}
		// now create one totalizer for each tax rate - taxing period
		$anyAutoRecurringInBasket						=	$paymentBasket->isAnyAutoRecurringPossibleWithThisBasket();

		foreach ( $promotionsUsed as $byPrio ) {
			foreach ( $byPrio as $byOrdering ) {
				foreach ($byOrdering as $promo ) {
					/** @var $promo cbpaidpromotionTotalizertype */

					// Now that we have listed all different taxRate periods, we create corresponding Tax Totalizers:
                    /** @var $salesTaxTotalizer cbpaidPaymentTotalizer_promotion */
					$salesTaxTotalizer					=	new $myClassName();
					$salesTaxTotalizer->totalizer_id	=	(int) $promo->id;
					$salesTaxTotalizer->totalizer_type	=	$paymentTotalizerType;
					$salesTaxTotalizer->artnum			=	null;
					$promo->setBasket( $paymentBasket );	// needed for $promo->replaceUserVars below:
					$salesTaxTotalizer->description		=	$promo->replaceUserVars( CBTxt::Th( $promo->name ) );
					$salesTaxTotalizer->currency		=	$paymentBasket->mc_currency;
					$salesTaxTotalizer->start_date		=	$promo->getDbo()->getNullDate();
					$salesTaxTotalizer->stop_date		=	$salesTaxTotalizer->start_date;
					if ( $anyAutoRecurringInBasket && ( $promo->applies_to_first_payment ) ) {
						$salesTaxTotalizer->first_rate				=	'0.0';
						$salesTaxTotalizer->first_item_days			=	0;
						$salesTaxTotalizer->first_totalizer_days	=	0;
						$salesTaxTotalizer->first_original_rate		=	0.0;
					}
					if ( ( ( ! $anyAutoRecurringInBasket ) && $promo->applies_to_first_payment )
					|| ( $anyAutoRecurringInBasket && $promo->applies_to_recurrings ) ) {
						$salesTaxTotalizer->rate					=	'0.0';
						$salesTaxTotalizer->item_days				=	0;
						$salesTaxTotalizer->totalizer_days			=	0;
						$salesTaxTotalizer->original_rate			=	0.0;
					}
					$salesTaxTotalizer->_itemIndexes	=	$promo->_itemsUsingThisPromo;
					if ( count( $promo->_itemsUsingThisPromo ) == 1 ) {
						$salesTaxTotalizer->setPaymentItemObject( $paymentItems[$promo->_itemsUsingThisPromo[0]] );
					}
					// Taxes are computed on net values ( rate - discount ) on items, thus no need to tax the totalizer:
					// $salesTaxTotalizer->tax_rule_id		=	$paymentItems[$promo->_itemsUsingThisPromo[0]]->tax_rule_id;
					$salesTaxTotalizer->_totalizertypeSettings		=	$promo;
					call_user_func_array( $addTotalizerToBasketFunc, array( $salesTaxTotalizer ) );
				}
			}
		}
	}
	/**
	 * Time-prorates a totalizer for an item
	 *
	 * @param  cbpaidPaymentItem  $item
	 * @param  boolean            $isTotalizerFirstPeriod
	 * @return float              a value between 0.0 and 1.0
	 */
	public function proRatePeriod( $item, $isTotalizerFirstPeriod ) {
		return 1;
	}
	/**
	 * Applies $this totalizer to the $paymentBasket
	 *
	 * @param  cbpaidPaymentBasket  $paymentBasket
	 * @param  boolean              $anyAutoRecurringInBasket
	 * @return boolean              TRUE: Totalizer applied, FALSE: remove $this totalizer from $paymentBasket
	 */
	public function applyThisTotalizerToBasket( $paymentBasket, $anyAutoRecurringInBasket ) {
		if ( ( $this->first_rate || $this->rate ) && ( ( $this->first_rate != 0 ) || ( $this->rate != 0 ) ) ) {
			if ( $anyAutoRecurringInBasket ) {

				if ( ( ! $paymentBasket->period1 ) && ( $this->first_rate != $this->rate ) ) {
					// create different first period in basket total, as discount won't apply same way:
					$paymentBasket->period1			=	$paymentBasket->period3;
					$paymentBasket->mc_amount1		=	$paymentBasket->mc_amount3;
				}

				if ( $paymentBasket->period1 ) {
					$paymentBasket->mc_amount1		+=	$this->first_rate;
					$paymentBasket->mc_gross		+=	$this->first_rate;
				} else {
					$paymentBasket->mc_gross		+=	$this->rate;
				}
				$paymentBasket->mc_amount3			+=	$this->rate;

			} else {
				$paymentBasket->mc_gross			+=	$this->rate;
			}
		} else {
			if ( $this->_totalizertypeSettings->show_also_zero_values ) {
				if ( $anyAutoRecurringInBasket && ( ! $paymentBasket->period1 ) && ( $this->first_rate == 0 ) ) {
					// avoid displaying "0.- then 0.-" if all items above this one have only one value:
					$this->first_rate				=	null;
					$this->first_item_days			=	null;
					$this->first_totalizer_days		=	null;
					$this->first_original_rate		=	null;
				}
			} else {
				return false;		// to unset( $taxableTotalizers[$k] );
			}
		}
		return true;
	}
	/**
	 * Notifies any IPN/PDT/status change
	 *
	 * @param  boolean                    $thisIsReferencePayment TRUE if this event stores the payment
	 * @param  string                     $unifiedStatus          Payment/Subscription status ('PaidSubscription', 'Denied', 'RegistrationCancelled', NOT allowed here: 'Completed', 'Processed', 'Pending', 'In-Progress'
	 * @param  string                     $previousUnifiedStatus  Payment/Subscription status ('PaidSubscription', 'Denied', 'RegistrationCancelled', NOT allowed here: 'Completed', 'Processed', 'Pending', 'In-Progress'
	 * @param  cbpaidPaymentBasket        $paymentBasket
	 * @param  cbpaidPaymentNotification  $notification           notification object of the payment
	 * @param  int                        $now
	 * @param  UserTable                  $user
	 * @param  string                     $eventType              type of event (paypal type): 'web_accept', 'subscr_payment', 'subscr_signup', 'subscr_modify', 'subscr_eot', 'subscr_cancel', 'subscr_failed'
	 * @param  string                     $paymentStatus          new status (Completed, RegistrationCancelled)
	 * @param  int                        $occurrences            renewal occurrences
	 * @param  int                        $autorecurring_type     0: not auto-recurring, 1: auto-recurring without payment processor notifications, 2: auto-renewing with processor notifications updating $expiry_date
	 * @param  int                        $autorenew_type         0: not auto-renewing (manual renewals), 1: asked for by user, 2: mandatory by configuration
	 * @param  boolean                    $txnIdMultiplePaymentDates   FALSE: unique txn_id for each payment, TRUE: same txn_id can have multiple payment dates
	 * @return void
	 */
	public function notifyPaymentStatus( $thisIsReferencePayment, $unifiedStatus, $previousUnifiedStatus, &$paymentBasket, &$notification, $now, &$user, $eventType, $paymentStatus, $occurrences, $autorecurring_type, $autorenew_type, $txnIdMultiplePaymentDates ) {
		static $storedUses						=	array();

		if ( ( $previousUnifiedStatus == 'NotInitiated' ) && ( $unifiedStatus != 'NotInitiated' ) ) {

			$promotion								=	$this->getPromotion();

			if ( $promotion &&
				( ( ( $promotion->discount_type == 'cbfield_amount' ) && $promotion->amount_cbfield_deduct )
			     || ( in_array( $promotion->discount_type, array( 'fixed', 'percent_on_part', 'fixed_percent', 'percent_fixed' ) ) && $promotion->amount_cbfield ) ) )
			{
				// remove amount used from CB field:
				$cbUser								=	CBuser::getInstance( (int) $paymentBasket->user_id );
				if ( $cbUser ) {
					$user							=	$cbUser->getUserData();
					if ( $user ) {

						if ( $promotion->currency_cbfield ) {
							$fieldCurrency			=	cbpaidUserExtension::getInstance( (int) $paymentBasket->user_id )->getFieldValue( (int) $promotion->currency_cbfield, true );
						} else {
							$fieldCurrency			=	null;
						}
						if ( ! $fieldCurrency ) {
							$fieldCurrency			=	cbpaidApp::settingsParams()->get( 'currency_code', 'USD' );
						}

						$fieldAmount				=	cbpaidUserExtension::getInstance( (int) $paymentBasket->user_id )->getFieldValue( (int) $promotion->amount_cbfield, true );
						$_CBPAY_CURRENCIES			=	cbpaidApp::getCurrenciesConverter();
						if ( $promotion->discount_type == 'cbfield_amount' ) {
							$usedValue				=	$_CBPAY_CURRENCIES->convertCurrency( $paymentBasket->mc_currency, $fieldCurrency, $paymentBasket->period1 ? $this->first_rate : $this->rate );		// null if cannot convert
						} else {
							$promoCurrency			=	$promotion->currency;
							if ( $promoCurrency == '' ) {
								$promoCurrency		=	cbpaidApp::settingsParams()->get( 'currency_code', 'USD' );
							}
							$valueInPromoCur		=	$_CBPAY_CURRENCIES->convertCurrency( $paymentBasket->mc_currency, $promoCurrency, - ( $paymentBasket->period1 ? $this->first_rate : $this->rate ) );	// null if cannot convert
							if ( $valueInPromoCur < $promotion->amount ) {
								$usedValue			=	$promotion->amount - $valueInPromoCur;
								$usedValue			=	$_CBPAY_CURRENCIES->convertCurrency( $promoCurrency, $fieldCurrency, $usedValue );		// null if cannot convert
							} else {
								$usedValue			=	null;
							}
						}
						if ( $usedValue ) {
							$usedValue				=	round( $usedValue, 2 );			//TBD: number of cents digits should come from currency...
							if ( $usedValue != 0 ) {
								cbpaidUserExtension::getInstance( (int) $paymentBasket->user_id )->setFieldValue( (int) $promotion->amount_cbfield, $fieldAmount + $usedValue, true );
								$oldPwd				=	$user->password;
								$user->password		=	null;		// don't update cleartext password in case of registration
								$user->store();
								$user->password		=	$oldPwd;	// restore plaintext password if password was cleartext
							}
						}
					}
				}
			}
		}
		if ( $thisIsReferencePayment && in_array( $unifiedStatus, array( 'FreeTrial', 'Completed', 'Processed' ) ) ) {
			// track use of promotion:
			if ( ! isset( $storedUses[$paymentBasket->id][$this->totalizer_id] ) ) {
				$promotionUse						=	new cbpaidPromotionUse();
				$promotionUse->time_completed		=	$paymentBasket->time_completed;
				$promotionUse->state				=	'A';
				$promotionUse->promotion_id			=	$this->totalizer_id;
				$promotionUse->user_id				=	$paymentBasket->user_id;
				$promotionUse->payment_basket_id	=	$paymentBasket->id;
				$couponCodes						=	cbpaidPromotionCouponsHelper::getCouponsOfBasket( $paymentBasket );
				$promotion							=	$this->getPromotion();
				if ( $promotion && ( false !== ( $couponUsed = $promotion->checkPromotionCoupons( $couponCodes, $paymentBasket->user_id ) ) ) ) {
					if ( is_string( $couponUsed ) ) {
						$promotionUse->coupon_code	=	$couponUsed;
					}
				}
				$promotionUse->currency				=	$paymentBasket->mc_currency;
				$promotionUse->order_amount			=	$paymentBasket->mc_gross;
				if ( $paymentBasket->period1 ) {
					$promotionUse->discount_amount	=	- $this->first_rate;
				} else {
					$promotionUse->discount_amount	=	- $this->rate;
				}
				// referer = ?
				// integrations = ?
				$promotionUse->historySetMessage( 'Basket with promotion use has been paid' );
				$promotionUse->store();
				$storedUses[$paymentBasket->id][$this->totalizer_id]	=	$promotionUse;
			} else {
				if ( $paymentBasket->period1 ) {
					$storedUses[$paymentBasket->id][$this->totalizer_id]->discount_amount	+=	- $this->first_rate;
				} else {
					$storedUses[$paymentBasket->id][$this->totalizer_id]->discount_amount	+=	- $this->rate;
				}
				/** @var cbpaidPromotionUse[][] $storedUses */
				/** @noinspection PhpUndefinedMethodInspection (due to IDE limitation) */
				$storedUses[$paymentBasket->id][$this->totalizer_id]->store();
			}
		}
	}
	/**
	 * Returns the totalizer type for $this
	 *
	 * @return cbpaidpromotionTotalizertype|boolean  false
	 */
	private function getPromotion( ) {
		return cbpaidpromotionTotalizertype::getInstance( $this->totalizer_id );
	}
}

/**
 * Class definition for the calculating promotion totalizer memory-only object
 */
class cbpaidCrossTotalizer_promotion extends cbpaidCrossTotalizer {
	/**
	 * Gives $item->first_rate or $item->rate of $item depending of $first
	 *
	 * @param  cbpaidPaymentItem  $item
	 * @param  boolean            $inclusive
	 * @param  boolean            $first
	 * @param  boolean            $itemHasReallyFirstRate
	 * @return float
	 */
	protected function _getItemAmount_first_incl( $item, $inclusive, $first, $itemHasReallyFirstRate = false ) {
		if ( $first ) {
			if ( $itemHasReallyFirstRate ) {
				$amt					=	$item->first_rate;
			} else {
				$amt					=	$item->rate;
			}
		} else {
			$amt						=	$item->rate;
		}
		if ( $inclusive ) {
			$amt						+=	$first ? $item->first_discount_amount : $item->discount_amount;
		}
		return $amt;
	}
	/**
	 * Returns name of totalizer total column in payment item
	 *
	 * @param  boolean  $first  If it's first amount
	 * @return string
	 */
	protected function _getItemTotalizerColumnName( $first ) {
		return $first ? 'first_discount_amount' : 'discount_amount';
	}
}
/**
* Paid Subscriptions Tab Class for handling the CB tab api
*/
class getcbsubspromotionTab extends cbTabHandler {
	/**
	 * Handles event onCbSubsBeforePaymentBasket to show coupons form
	 *
	 * @param  cbpaidPaymentBasket  $paymentBasket  Payment basket
	 * @param  string               $introText      IN+OUT: HTML introduction text for payment basket
	 * @param  string               $redirectNow    IN: Previous needs to display basket: 'display' or can redirect: NULL, +OUT: Rendered HTML for Terms and Conditions
	 * @return string                               HTML that will be prepended to $result by CBSubs
	 */
	public function onCbSubsBeforePaymentBasket( $paymentBasket, &$introText, &$redirectNow ) {
		if ( $redirectNow === 'display' ) {
			return null;
		}

		$params						=	cbpaidApp::settingsParams();
		if ( $params->get( 'integration_cbsubspromotions_enabled', 1 ) != 1 ) {
			return null;
		}

		$html_couponsDescriptions	=	array();
		if ( $this->checkIfCouponsPossible( $paymentBasket, $html_couponsDescriptions ) ) {
			// Force display of basket even if it would not be needed:
			$redirectNow			=	'display';
		}

		return null;
	}

	/**
	 * Handles event onCbSubsAfterPaymentBasket to show coupons form
	 *
	 * @param  cbpaidPaymentBasket  $paymentBasket  Payment basket
	 * @param  string               $result         IN+OUT: Rendered HTML for payment basket up to including invoicing address
	 * @param  string               $txtTerms       IN+OUT: Rendered HTML for Terms and Conditions
	 * @return string                               HTML that will be appended to $result by CBSubs
	 */
	public function onCbSubsAfterPaymentBasket( $paymentBasket, /** @noinspection PhpUnusedParameterInspection */ &$result, /** @noinspection PhpUnusedParameterInspection */ &$txtTerms ) {
		return $this->showCouponForm( $paymentBasket );
	}

	/**
	* Checks if $paymentBasket content is subject to coupons. That way we can display coupon form only if it is applicable to that basket.
	*
	* @param  cbpaidPaymentBasket  $paymentBasket
	* @param  string[]             $html_couponsDescriptions  OUTPUT: html
	* @return boolean
	*/
	protected function checkIfCouponsPossible( $paymentBasket, &$html_couponsDescriptions ) {
		$basketHasCoupons			=	false;
		$html_couponsDescriptions	=	array();
		$resultTexts				=	null;
		$promotions					=	cbpaidPaymentTotalizer_promotion::getApplicablePromotionsWithoutCouponsChecks( $paymentBasket, $paymentBasket->loadPaymentItems(), $paymentBasket->loadPaymentTotalizers(), null, $resultTexts );
		foreach ( $promotions as $promo ) {
			if ( $promo->promotion_type == 'coupon' ) {
				$basketHasCoupons	=	true;
				if ( $promo->coupon_description && ! $this->checkIfCouponInBasket( $promo, $paymentBasket ) ) {
					$promo->setBasket( $paymentBasket );
					$html_couponsDescriptions[]		=	$promo->replaceUserVars( $promo->coupon_description );
				}
			}
		}
		return $basketHasCoupons;
	}
	/**
	 * Gets coupon-type promotions used in basket
	 *
	 * @param   cbpaidPaymentBasket           $paymentBasket
	 * @return  cbpaidpromotionTotalizertype[]
	 */
	protected function getCouponsPromosUsedInBasket( $paymentBasket ) {
		static $couponsUsed				=	null;
		if ( $couponsUsed === null ) {
			$couponsUsed				=	array();
			foreach ( $paymentBasket->loadPaymentTotalizers() as $totalizer ) {
				if ( $totalizer->totalizer_type == 'promotion' ) {
					if ( $totalizer->getTotalizerParam( 'promotion_type', null, null ) === 'coupon' ) {
						$couponsUsed[]	=	$totalizer->loadTotalizerSettings();
					}
				}
			}
		}
		return $couponsUsed;
	}
	/**
	 * Checks if $promotion of type coupon is used in basket
	 *
	 * @param  cbpaidpromotionTotalizertype  $promotion
	 * @param  cbpaidPaymentBasket           $paymentBasket
	 * @return boolean
	 */
	protected function checkIfCouponInBasket( $promotion, $paymentBasket ) {
		$couponsUsed				=	$this->getCouponsPromosUsedInBasket( $paymentBasket );
		foreach ( $couponsUsed as $couponPromoUsed ) {
			if ( $promotion->id == $couponPromoUsed->id ) {
				return true;
			}
		}
		return false;
	}
	/**
	* Generates the coupons redemption form
	*
	* @param  cbpaidPaymentBasket  $paymentBasket
	* @return mixed                : either string HTML for tab content, or false if ErrorMSG generated
	*/
	protected function showCouponForm( $paymentBasket ) {
		$params						=	cbpaidApp::settingsParams();
		if ( $params->get( 'integration_cbsubspromotions_enabled', 1 ) != 1 ) {
			return null;
		}
		$html_couponsDescriptions	=	array();
		if ( ! $this->checkIfCouponsPossible( $paymentBasket, $html_couponsDescriptions ) ) {
			// do not display coupons form if no coupons are defined:
			return null;
		}
		$couponLabelText			=	$params->get( 'integration_cbsubspromotions_coupon_label_text', 'Enter Coupon Code', 'integrations' );		// CBTxt:T("Enter Coupon code if available:")
		$couponAddButtonText		=	$params->get( 'integration_cbsubspromotions_coupon_addbutton_text', 'Redeem Coupon', 'integrations' );						// CBTxt:T("Redeem Coupon")
		$couponDescription			=	$params->get( 'integration_cbsubspromotions_coupon_description', '', 'integrations' );
		$couponRemoveButtonText		=	$params->get( 'integration_cbsubspromotions_coupon_removebutton_text', 'remove', 'integrations' );							// CBTxt:T("remove")
		if ( $couponRemoveButtonText === '0' ) {
			$couponRemoveButtonText	=	null;
		}
		$couponsUsed				=	$this->getCouponsPromosUsedInBasket( $paymentBasket );
        /** @var $renderer cbpaidBasketView */
		$renderer					=	cbpaidTemplateHandler::getViewer( null, 'basket' );
		$renderer->setModel( $paymentBasket );
		$htmlInside					=	$renderer->drawCouponForm( $couponLabelText, $couponAddButtonText, $couponDescription, $html_couponsDescriptions, $couponRemoveButtonText, $couponsUsed );
		return $paymentBasket->displayIntegrationForm( $htmlInside, 'promotion', true );
	}
	/**
	 * Handles save and edit events for integration
	 *
	 * @param  string               $integration
	 * @param  string               $act
	 * @param  cbpaidPaymentBasket  $paymentBasket
	 * @return string
	 */
	public function onCPayEditBasketIntegration( $integration, /** @noinspection PhpUnusedParameterInspection */ $act, $paymentBasket ) {
		global $_POST;
		$return							=	null;
		if ( $integration == 'promotion' ) {
			// Removing coupons:
			$removeIds					=	cbGetParam( $_POST, 'deletecouponcode' );
			if ( is_array( $removeIds ) && count( $removeIds ) > 0 ) {
				foreach ( array_keys( $removeIds ) as $couponId ) {
					$couponId			=	(int) $couponId;
					$coupon				=	new cbpaidpromotionTotalizertype();
					$coupon->load( (int) $couponId );
					if ( $coupon->promotion_type == 'coupon' ) {
						$couponCode		=	$coupon->coupon_code;
						$coupons		=	cbpaidPromotionCouponsHelper::getCouponsOfBasket( $paymentBasket );
						$idxs			=	null;
						if ( in_array( $couponCode, $coupons ) ) {
							$idxs		=	array_keys( $coupons, $couponCode );
						} elseif ( in_array( strtoupper( $couponCode ), array_map('strtoupper', $coupons ) ) ) {
							$idxs		=	array_keys( array_map('strtoupper', $coupons ), strtoupper( $couponCode ) );
						}
						if ( $idxs ) {
							unset( $coupons[$idxs[0]] );
							cbpaidPromotionCouponsHelper::setCouponsOfBasket( $paymentBasket, $coupons );
							$paymentBasket->updatePaymentItems();
							$paymentBasket->updateBasketRecomputeTotalizers();
							$return		.=	'<div class="alert alert-info">' . sprintf( CBTxt::T("Removed coupon code %s"), htmlspecialchars( $couponCode ) ) . '</div> ';		//TBD add language strings of here and coupon.php
						}
					}
				}
			}
			// Adding coupons:
			if ( cbGetParam( $_POST, 'addcouponcode' ) ) {
				$couponCode				=	cbGetParam( $_POST, 'couponcode' );
				if ( $couponCode ) {
					$resultTexts		=	null;
					$couponUsed			=	cbpaidPaymentTotalizer_promotion::isCouponApplicableToBasket( $couponCode, $paymentBasket, $resultTexts );
					if ( $couponUsed ) {
						$coupons		=	cbpaidPromotionCouponsHelper::getCouponsOfBasket( $paymentBasket );
						if ( ! in_array( $couponUsed, $coupons ) ) {
							$coupons[]	=	$couponUsed;
							cbpaidPromotionCouponsHelper::setCouponsOfBasket( $paymentBasket, $coupons );
							$paymentBasket->updatePaymentItems();
							$paymentBasket->updateBasketRecomputeTotalizers();
							$return		=	'<div class="alert alert-info">' . sprintf( CBTxt::T("Redeemed coupon code %s"), htmlspecialchars( $couponUsed ) ) . '</div>';
						} else {
							$return		=	'<div class="alert alert-danger">' . sprintf( CBTxt::T("Coupon code %s is already redeemed"), htmlspecialchars( $couponUsed ) ) . '</div>';
						}
					} else {
						$couponPromoLoader	=	new cbpaidpromotionTotalizertype();
						$promosWithCoupon	=	$couponPromoLoader->loadCouponsWithCode( $couponCode, $paymentBasket->user_id );

						$reasonTexts		=	array();
						if ( isset( $resultTexts[0] ) ) {
							$reasonTexts	=	array_merge( $reasonTexts, $resultTexts[0] );
						}
						if ( count( $promosWithCoupon ) > 0 ) {
							foreach ( $promosWithCoupon as $promo ) {
								if ( isset( $resultTexts[$promo->id] ) ) {
									$reasonTexts	=	array_merge( $reasonTexts, $resultTexts[$promo->id] );
								}
							}
							$reasonTexts =	array_unique( $reasonTexts );
							$reason		=	( count( $reasonTexts ) > 0 ? implode( ' ', $reasonTexts ) : CBTxt::T("Invalid") . '.' );
							$return		=	'<div class="alert alert-danger">' . sprintf( CBTxt::T("Coupon code %s is not applicable: %s"), htmlspecialchars( $couponCode ), htmlspecialchars( $reason ) ) . '</div>';
						} else {
							$reasonTexts =	array_unique( $reasonTexts );
							$return		=	'<div class="alert alert-danger">' . sprintf( CBTxt::T("Coupon code %s does not exist."), htmlspecialchars( $couponCode ) )
										.	( count( $reasonTexts ) > 0 ? ' ' . implode( ' ', $reasonTexts ) : '' ) . '</div>';
						}
					}
				}
			}
		}
		return $return;
	}
	/**
	 * Called after rendering of plan price
	 *
	 * @param  cbpaidProduct      $plan     Plan being rendered
	 * @param  string             $ret      Normal Price and period (IN/OUT
	 * @param  array              $method   Method that heas been called to render (renderPeriodPrice)
	 * @param  array              $args     Arguments for the rendering method array( 0 $price, 1 $firstPeriodFullPrice, 2 $firstPeriodPrice, 3 $prorateDiscount, 4 $expiryTime, 5 $startTime,
	 *                                                                            6 $autorecurring, 7 $recurring_max_times, 8 $reason, 9 $occurrence, 10 $html, 11 $roundings, 12 $displayPeriod, 13 $displaySecondaryCurrency )
	 * @param  int                $userId                 User id for whom this product is displayed
	 * @param  cbpaidPaymentItem  $paymentItem   If called from a basket or an invoice, it is the payment item, otherwise it is null
	 * @return void
	 */
	public function onCPayAfterDisplayProductPeriodPrice( $plan, &$ret, $method, $args, $userId, $paymentItem = null ) {
		global $_CB_database;

		// args					=	array( $price, $firstPeriodFullPrice, $firstPeriodPrice, $prorateDiscount, $expiryTime, $startTime,
		//								   $autorecurring, $recurring_max_times, $reason, $occurrence, $html, $roundings, $displayPeriod, $displaySecondaryCurrency );

		if ( $paymentItem ) {
			return;
		}

		$cbUser					=	CBuser::getInstance( $userId, false );

		$startTime				=	$args[5];
		$reason					=	$args[8];
		$occurrence				=	$args[9];

		$normalPriceWithoutPeriod	=	$this->displayOrginalPriceOnly( $method, $args[0], $args[10] );
		if ( $reason == 'R' ) {
			// For renewals it is only a button:
			$normalPriceWithPeriod	=	$normalPriceWithoutPeriod;
		} else {
			$normalPriceWithPeriod	=	$this->displayOrginalPeriodPriceOnly( $method, $args );
		}

		$resultTexts		=	array();
		$item				=	new cbpaidPaymentItem( $_CB_database );
		$item->id			=	0;
		$promotions			=	cbpaidpromotionTotalizertype::getPromotionsApplicableForPlan( $plan, $userId, $reason, $occurrence, $item, $startTime, true, $resultTexts );

		/*
		 //TODO: LATER MAKE THIS A FEATURE:
		if ( cbpaidApp::settingsParams()->get( 'promotions_debug', 0 ) && $resultTexts ) {
			$debug					=	'<div class="message"><h2>' . CBTxt::Th("Promotions debug for Plan: [PLAN_NAME]:", null, array( '[PLAN_NAME]' => $plan->get( 'name' ) ) ) . '</h2>';
			foreach ( $resultTexts as $promoId => $texts ) {
				$debug				.=	'<h3>' . CBTxt::Th("Promotion NOT applicable: [PROMOTION_NAME]:", null, array( '[PROMOTION_NAME]' => CBTxt::Th( cbpaidpromotionTotalizertype::getInstance( $promoId )->name ) ) ) . '</h3>';
				$debug				.=	'<div>' . implode( '</div><div>', $texts ) . '</div>';
			}
			foreach ( $promotions as $promo ) {
				$debug				.=	'<h3>' . CBTxt::Th("Promotion is applicable: [PROMOTION_NAME]", null, array( '[PROMOTION_NAME]' => CBTxt::Th( $promo->name ) ) ) . '</h3>';
			}
			$debug					.=	'</div>';
			echo $debug;
		}
		*/

		foreach ( $promotions as $promo ) {
			if ( $promo->plan_price_display_type > 0 ) {
				$promo->setPaymentItem( $item );
				$discountPercents	=	null;
				$discountedPriceWithoutPeriod	=	null;
				$discountedPrice	=	$this->discountedPriceDisplay( $promo, $method, $args, $plan->currency(), $plan, $discountPercents, $discountedPriceWithoutPeriod, $userId );
				if ( $discountedPrice === null ) {
					// don't override if there is no discount:
					continue;
				}
				switch ($promo->plan_price_display_type ) {
					case '1':
						if ( $discountedPrice != $ret ) {
							$saleText		=	$promo->plan_price_display_saletext;

							if ( ! $saleText ) {
								$saleText	=	'SALE!'; // For Translations: CBTxt::Th( 'SALE!' )
							}

							$ret	=	'<span class="cpayPromotionPrice cpayPromotionId' . ( (int) $promo->id ) . ' cpayPromotionPlanId' . ( (int) $plan->id ) . '">'
									.	'<span class="cpayPromotionRegularPrice text-muted">'
									.	$normalPriceWithoutPeriod		// $ret (later when compounding works in these pre-sales calculations)
									.	'</span>'
									.	' <span class="cpayPromotionSaleText text-danger">'
									.	$cbUser->replaceUserVars( CBTxt::Th( $saleText ), true, false, array(), false )
									.	'</span> '
									.	'<span class="cpayPromotionSpecialPrice">'
									.	$discountedPrice
									.	'</span>'
									.	'</span>'
									;
						}
						break;
					case '2':
						if ( $promo->plan_price_display_text && ( trim( strip_tags( $promo->plan_price_display_text ) ) != '[NORMAL_PRICE]' ) ) {
							$html			=	$args[10];
							$extraStrings	=	array( 'NORMAL_PRICE'	=>	$ret, 'NORMAL_PRICE_WITH_DURATION'	=>	$normalPriceWithPeriod, 'NORMAL_PRICE_NO_DURATION'	=>	$normalPriceWithoutPeriod, 'DISCOUNTED_PRICE'	=>	$discountedPrice, 'DISCOUNTED_PRICE_NO_DURATION'	=>	$discountedPriceWithoutPeriod, 'DISCOUNT_PERCENTS'	=>	$discountPercents );
							$ret			=	$plan->getPersonalized( $promo->plan_price_display_text, $userId, $html, true, $extraStrings, false );
						}
						break;
					default:
						break;
				}
			}
		}
	}
	/**
	 * Before Draws the plan
	 *
	 * @param  cbpaidProduct  $plan
	 * @param  string[]       $childPlans           HTML
	 * @param  string         $reason               payment reason: 'N'=new subscription (default), 'R'=renewal, 'U'=update
	 * @param  boolean        $drawOnlyAsContainer
	 * @param  int            $userId               User id for whom this product is displayed
	 * @return string         HTML
	 */
	public function onCPayBeforeDrawPlan( &$plan, /** @noinspection PhpUnusedParameterInspection */ &$childPlans, $reason, /** @noinspection PhpUnusedParameterInspection */ $drawOnlyAsContainer, $userId ) {
		global $_CB_framework;

		$occurrence		=	0;
		$startTime		=	$_CB_framework->now();
		$this->doBeforeDrawPlan( $plan, null, $reason, $userId, $occurrence, $startTime, true );

		return null;
	}

	/**
	 * Has drawn the plan
	 *
	 * @param  cbpaidProduct  $plan
	 * @param  string         $rendered
	 * @return void
	 */
	public function onCPayAfterDrawPlan( $plan, /** @noinspection PhpUnusedParameterInspection */ &$rendered )
	{
		$this->doAfterDrawPlan( $plan );

	}

	/**
	 * Payment item event handler:
	 *
	 * @param  string                    $event
	 * @param  cbpaidSomething           $something
	 * @param  cbpaidPaymentBasket|null  $paymentBasket
	 * @param  cbpaidPaymentItem         $paymentItem
	 * @return void
	 */
	public function onCPayPaymentItemEvent( $event, $something, /** @noinspection PhpUnusedParameterInspection */ $paymentBasket, /** @noinspection PhpUnusedParameterInspection */ $paymentItem )
	{
		global $_CB_framework;

		switch ( $event ) {
			case 'beforeCreatePaymentItem':
				$plan		=	$something->getPlan();
				$reason		=	$something->_reason;
				$userId		=	$something->user_id;
				$occurrence	=	$something->getOccurrence();
				$startTime	=	$_CB_framework->now();
				$this->doBeforeDrawPlan( $plan, null, $reason, $userId, $occurrence, $startTime, false );
				return;

			case 'afterCreatePaymentItem':
				$this->doAfterDrawPlan( $something->getPlan() );
				return;

			default:
				return;
		}
	}

	/**
	 * Internal function that sets overrides for $plan name and description
	 *
	 * @param  cbpaidProduct         $plan
	 * @param  cbpaidSomething|null  $subscription
	 * @param  string                $reason              payment reason: 'N'=new subscription (default), 'R'=renewal, 'U'=update
	 * @param  int|null              $userId
	 * @param  int                   $occurrence
	 * @param  int                   $startTime
	 * @param  boolean               $html
	 * @return void
	 */
	protected function doBeforeDrawPlan( $plan, $subscription, $reason, $userId, $occurrence, $startTime, $html ) {
		$item						=	null;

		$resultTexts				=	null;
		$promotions					=	cbpaidpromotionTotalizertype::getPromotionsApplicableForPlan( $plan, $userId, $reason, $occurrence, $item, $startTime, true, $resultTexts );

		/*
		 //TODO: LATER MAKE THIS A FEATURE:
		if ( cbpaidApp::settingsParams()->get( 'promotions_debug', 0 ) && $resultTexts ) {
			$debug					=	'<div class="message"><h2>' . CBTxt::Th("Promotions debug for Plan: [PLAN_NAME]:", null, array( '[PLAN_NAME]' => $plan->get( 'name' ) ) ) . '</h2>';
			foreach ( $resultTexts as $promoId => $texts ) {
				$debug				.=	'<h3>' . CBTxt::Th("Promotion NOT applicable: [PROMOTION_NAME]:", null, array( '[PROMOTION_NAME]' => CBTxt::Th( cbpaidpromotionTotalizertype::getInstance( $promoId )->name ) ) ) . '</h3>';
				$debug				.=	'<div>' . implode( '</div><div>', $texts ) . '</div>';
			}
			foreach ( $promotions as $promo ) {
				$debug				.=	'<h3>' . CBTxt::Th("Promotion is applicable: [PROMOTION_NAME]", null, array( '[PROMOTION_NAME]' => CBTxt::Th( $promo->name ) ) ) . '</h3>';
			}
			$debug					.=	'</div>';
			echo $debug;
		}
		 */

		$name						=	$plan->name;
		$description				=	$plan->description;

		foreach ( $promotions as $promo ) {
			if ( $promo->plan_name_descr_display_type > 0 ) {
				$extraStrings		=	array( 'NORMAL_NAME'		=>	$plan->getPersonalized( 'name', $userId, $html ),
											   'NORMAL_DESCRIPTION'	=>	$plan->getPersonalized( 'description', $userId, $html ) );
				if ( $subscription ) {
					$nameSubstTransl	=	$subscription->getPersonalized( $promo->plan_name_display_text,        $html, true, $extraStrings, false );
					$descrSubstTransl	=	$subscription->getPersonalized( $promo->plan_description_display_text, $html, true, $extraStrings, false );
				} else {
					$nameSubstTransl	=	$plan->getPersonalized( $promo->plan_name_display_text,        $userId, $html, true, $extraStrings, false );
					$descrSubstTransl	=	$plan->getPersonalized( $promo->plan_description_display_text, $userId, $html, true, $extraStrings, false );
				}

				if ( $html ) {
					$nameOver		=	'<span class="cpayPromotionPlanNameOverride cpayPromotionId' . ( (int) $promo->id ) . ' cpayPromotionPlanId' . ( (int) $plan->id ) . '">' . $nameSubstTransl . '</span>';
				} else {
					$nameOver		=	$nameSubstTransl;
				}

				if ( $promo->plan_name_descr_display_type == 1 ) {
					$name			.=	' ' . $nameOver;
					$description	.=	' ' . $descrSubstTransl;
				} elseif ( $promo->plan_name_descr_display_type == 2 ) {
					$name			=	$nameOver;
					$description	=	$descrSubstTransl;
				}

				$plan->setOverride( 'name', $name );
				$plan->setOverride( 'description', $description );
			}
		}
	}

	/**
	 * Internal function that removes overrides set for $plan name and description
	 *
	 * @param  cbpaidProduct  $plan
	 * @return void
	 */
	protected function doAfterDrawPlan( $plan )
	{
		// Reset override, so the get() below has original value if it was overridden, then overrides again:
		$plan->setOverride( 'name', null );
		$plan->setOverride( 'description', null );

	}

	/**
	 * Before Draws the subscription
	 *
	 * @param  cbpaidSomething  $subscription
	 * @param  string           $childrenRendered
	 * @param  string           $controlButtonsRendered
	 * @param  boolean          $showRenewButtons
	 * @param  boolean          $showUnsubscribeButtons
	 * @param  int              $startTime
	 * @param  UserTable        $user
	 * @return void
	 */
	public function onCPayBeforeDrawSomething(
												$subscription,
												/** @noinspection PhpUnusedParameterInspection */ &$childrenRendered,
												/** @noinspection PhpUnusedParameterInspection */ &$controlButtonsRendered,
												/** @noinspection PhpUnusedParameterInspection */ $showRenewButtons,
												/** @noinspection PhpUnusedParameterInspection */ $showUnsubscribeButtons,
												$startTime,
												$user )
	{
		$this->doBeforeDrawPlan( $subscription->getPlan(), $subscription, 'R', $user->id, $subscription->getOccurrence(), $startTime, true );
	}
	/**
	 * Has drawn the subscription
	 *
	 * @param  cbpaidSomething  $subscription
	 * @param  string           $rendered
	 * @param  int              $startTime
	 * @param  UserTable        $user
	 * @return void
	 */
	public function onCPayAfterDrawSomething( &$subscription, &$rendered, /** @noinspection PhpUnusedParameterInspection */ $startTime, /** @noinspection PhpUnusedParameterInspection */ $user ) {
		$plan						=	$subscription->getPlan();
		$this->onCPayAfterDrawPlan( $plan, $rendered );
	}
	/**
	 * Displays original price and period only
	 *
	 * @param  callable  $method  self::displayOrginalPriceOnly
	 * @param  array     $args    array( $price, $firstPeriodFullPrice, $firstPeriodPrice, $prorateDiscount, $expiryTime, $startTime, $autorecurring, $recurring_max_times, $reason, $occurrence, $html, $roundings, $displayPeriod, $displaySecondaryCurrency )
	 * @return string             HTML
	 */
	protected function displayOrginalPeriodPriceOnly( $method, $args ) {
		list( $price, , , , $expiryTime, $startTime, $autorecurring, $recurring_max_times, $reason, $occurrence, $html, $roundings, , $displaySecondaryCurrency, $status )		=	$args;
		$displayPeriod				=	false;
		$prorateDiscount			=	false;
		$firstPeriodFullPrice		=	null;
		$firstPeriodPrice			=	null;
		return call_user_func_array( $method, array( $price, $firstPeriodFullPrice, $firstPeriodPrice, $prorateDiscount, $expiryTime, $startTime,
									 $autorecurring, $recurring_max_times, $reason, $occurrence, $html, $roundings, $displayPeriod, $displaySecondaryCurrency, $status ) );
	}
	/**
	 * Displays original prices only
	 *
	 * @param  callable  $method  array( 'cbpaidProduct', 'renderPricesWithConversion' )
	 * @param  float     $price   Price to display
	 * @param  boolean   $html    Display in HTML or text
	 * @return string             HTML
	 */
	protected function displayOrginalPriceOnly( $method, $price, $html )
	{
		return call_user_func_array( array( $method[0], 'renderPricesWithConversion' ), array( $price, $html ) );
	}
	/**
	 * Gets discounted price display
	 *
	 * @param  cbpaidpromotionTotalizertype  $promo
	 * @param  array                         $method
	 * @param  array                         $args                          IN+OUT
	 * @param  string                        $currency_code
	 * @param  cbpaidProduct                 $plan
	 * @param  string                        $discountPercents              OUT
	 * @param  string                        $discountedPriceWithoutPeriod  OUT
	 * @param  int            $userId   User id for whom this product is displayed
	 * @return string|null
	 */
	protected function discountedPriceDisplay( $promo, $method, &$args, $currency_code, $plan, &$discountPercents, &$discountedPriceWithoutPeriod, $userId ) {
		list( $price, $firstPeriodFullPrice, $firstPeriodPrice, , /* $expiryTime */ , , , $recurring_max_times, $reason, , , , ,  )		=	$args;

		$regularPrice				=	$price;

		$promo->setForUserId( $userId );

		if ( ( $firstPeriodFullPrice !== null ) && ( $firstPeriodPrice !== null ) ) {
			$firstPeriodDiscount	=	$this->calculateDiscount( $promo, $firstPeriodPrice, true, $currency_code, $plan );
			$firstPeriodPrice		+=	$firstPeriodDiscount;
			$firstPeriodFullPrice	=	$firstPeriodPrice;			// We do not want the text "The first payment of the upgrade, taking in account your current membership"
			$secondPeriodDiscount	=	$this->calculateDiscount( $promo, $price, false, $currency_code, $plan );
			$price					+=	$secondPeriodDiscount;
			$nextReducedPrice		=	$firstPeriodPrice;
		} else {
			$firstPriceToUse		=	( $firstPeriodPrice === null ) ? $price : $firstPeriodPrice;
			$firstPeriodDiscount	=	$this->calculateDiscount( $promo, $firstPriceToUse, true, $currency_code, $plan );
			$secondPeriodDiscount	=	$this->calculateDiscount( $promo, $price, false, $currency_code, $plan );
			if ( ( $firstPeriodDiscount == $secondPeriodDiscount ) /* || ( ! $expiryTime ) */ || ( $reason == 'R' ) || ( $recurring_max_times == 1 ) ) {
				// For products without expiry time and for renewals and plans with only 1 recurring, we only show price of next renewal period (price is inside a button):
				$price				+=	$firstPeriodDiscount;
				$nextReducedPrice	=	$price;
				$firstPeriodFullPrice	=	null;
				$firstPeriodPrice	=	$price;
			} else {
				$firstPeriodPrice	=	$firstPriceToUse + $firstPeriodDiscount;
				// $firstPeriodFullPrice	=	$firstPeriodPrice;			// We do not want the text "The first payment of the upgrade, taking in account your current membership"
				$price				=	$price + $secondPeriodDiscount;
				$nextReducedPrice	=	$firstPeriodPrice;
			}
		}

		$promo->setForUserId( null );

		if ( ( round( $firstPeriodDiscount, 2 ) == 0 ) && ( round( $secondPeriodDiscount, 2 ) == 0 ) ) {
			return null;
		}

		$args[0]					=	$price;
		$args[1]					=	$firstPeriodFullPrice;
		$args[2]					=	$firstPeriodPrice;

		if ( $regularPrice != 0 ) {
			$discountPercents		=	round( ( ( - $firstPeriodDiscount ) / $regularPrice ) * 100 );
		} else {
			$discountPercents		=	'-';
		}

		$html							=	$args[10];

		$discountedPriceWithoutPeriod	=	$this->displayOrginalPriceOnly( $method, $nextReducedPrice, $html );

		return call_user_func_array( $method, $args );
	}
    /**
     * Calculates discount amount
     *
     * @param  cbpaidpromotionTotalizertype  $promo
     * @param  float                         $amountTaxExcl
     * @param  boolean                       $isFirstPeriod
     * @param  string                        $currency_code
     * @param  cbpaidProduct                 $plan
     * @return float
     */
	protected function calculateDiscount( $promo, $amountTaxExcl, $isFirstPeriod, $currency_code, /** @noinspection PhpUnusedParameterInspection */ $plan ) {
		$amount				=	$amountTaxExcl;
		$periodProrater		=	1;
		$extraAmountBefore	=	$promo->getAmountBeforePercents( $amount, $amountTaxExcl, $periodProrater, $isFirstPeriod, $currency_code );
		$extraPercents		=	$promo->getPercents( $amount, $amountTaxExcl, $periodProrater, $isFirstPeriod );
		$extraAmountAfter	=	$promo->getAmountAfterPercents( $amount, $amountTaxExcl, $periodProrater, $isFirstPeriod, $currency_code );
		$discountAmount		=	( ( ( $amount + $extraAmountBefore ) * ( 1 + $extraPercents ) ) + $extraAmountAfter ) - $amount;
		return $discountAmount;
	}
	/**
	 * Integration when a new payment item is added to a basket
	 *
	 * @param  string                    $event
	 * @param  cbpaidSomething           $something
	 * @param  cbpaidPaymentBasket|null  $paymentBasket
	 * @param  cbpaidPaymentItem         $paymentItem
	 *
	public function onCPayPaymentItemEvent( $event, &$something, &$paymentBasket, &$paymentItem ) {
		if ( $event == 'addSomethingToBasket' ) {
		}
	}
	/**
	 * Extends the XML invoice address in params
	 *
	 * @param  CBSimpleXMLElement   $param
	 * @param  PluginTable          $pluginObject
	 * @param  cbpaidPaymentBasket  $paymentBasket  (the data being displayed)
	 * @param  boolean              $isSaving
	 * @return CBSimpleXMLElement[]
	 *
	public function onxmlBeforeCbSubsDisplayOrSaveInvoice( $param, $pluginObject, $paymentBasket, $isSaving ) {
		global $_CB_framework, $_PLUGINS;

		$paymentItems			=	$paymentBasket->loadPaymentItems();
		$taxableTotalizers		=	$paymentBasket->loadPaymentTotalizers();

		$_PLUGINS->loadPluginGroup( 'user/plug_cbpaidsubscriptions/plugin/cbsubstax/validations', null, ( $_CB_framework->getUi() == 2 ? 0 : 1 ) );

		$taxRulesRates				=	cbpaidPaymentTotalizer_promotion::getApplicablePromotionsWithoutCouponsChecks( $paymentBasket, $paymentItems, $taxableTotalizers );
		$fromXml					=	array();
		foreach ( $taxRulesRates as $AllTaxRates ) {
			foreach ( $AllTaxRates as $taxRate ) {
				//$taxRate	= NEW cbpaidsalestaxTotalizertype();

				$business_check		=	$taxRate->business_check;
				if ( $business_check ) {
					$absoluteValidationsPath	=	$_CB_framework->getCfg('absolute_path') . '/'. $_PLUGINS->getPluginRelPath( $pluginObject ) . '/plugin/cbsubstax/validations/' . $business_check;
					$valphp		=	$absoluteValidationsPath . '/validation.php';
					if ( is_readable( $valphp ) ) {
						include_once $valphp;
						// $className	=	'cbpaidValidate_' . $tax->business_check;
					}
					$fromFile		=	$absoluteValidationsPath . '/xml/edit.invoice.xml';
					if ( is_readable( $fromFile ) ) {
						$fromRoot	=	new CBSimpleXMLElement( $fromFile, LIBXML_NONET | ( defined('LIBXML_COMPACT') ? LIBXML_COMPACT : 0 ), true );
						$fromXml	=	array_merge( $fromXml, $fromRoot->xpath( '/ * / editinvoicevalidationintegration/*' ) );		!!!!!!!!!! ADDED spaces for comment, remove if needed
					}
				}
			}
		}
		return $fromXml;
	}
	*/
}
