<?php
/**
* CBSubs (TM): Community Builder Paid Subscriptions Plugin: ciccreditmutuel
* @version $Id: notif.php 1465 2012-07-10 17:37:13Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage CICCreditMutuel - notif.php
* @author Krileon
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

global $_REQUEST, $_GET, $_SERVER;

$path									=	'/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/processors/ciccreditmutuel';
$root									=	str_replace( [ $path . '/notif.php', '/' ], [ '', DIRECTORY_SEPARATOR ], ( $_SERVER['SCRIPT_FILENAME'] ?? str_replace( DIRECTORY_SEPARATOR, '/', '' ) ) );

if ( ! $root ) {
	// Fallback just encase, but this won't work with any installs using symlinks
	$root								=	str_replace( str_replace( '/', DIRECTORY_SEPARATOR, $path ), '', __DIR__ );
}

if ( file_exists( $root . DIRECTORY_SEPARATOR . 'index.php' ) ) {
	$gateway							=	(int) ( explode( '-', ( $_REQUEST['reference'] ?? '0' ), 2 )[0] ?? 0 );

	if ( $gateway ) {
		// We need the unaltered payload depending on the request method as this is very very important for HMAC validation and we can't risk any outside source (e.g. joomla plugin) altering it
		// We have to support GET and POST here as if IPN fails the account owner is emailed a link to retry manually which is GET
		$_REQUEST['payload']			=	( $_SERVER['REQUEST_METHOD'] === 'GET' ? $_GET : $_POST );

		$_REQUEST['option']				=	'com_comprofiler';
		$_REQUEST['view']				=	'pluginclass';
		$_REQUEST['plugin']				=	'cbpaidsubscriptions';
		$_REQUEST['cbpgacctno']			=	$gateway;
		$_REQUEST['result']				=	'notify';
		$_REQUEST['format']				=	'raw';

		$_GET['option']					=	'com_comprofiler';
		$_GET['view']					=	'pluginclass';
		$_GET['plugin']					=	'cbpaidsubscriptions';
		$_GET['cbpgacctno']				=	$gateway;
		$_GET['result']					=	'notify';
		$_GET['format']					=	'raw';

		foreach ( $_GET as $k => $v ) {
			$_POST[$k]					=	$v;
		}

		$index							=	$root . DIRECTORY_SEPARATOR . 'index.php';

		$_SERVER['SCRIPT_FILENAME']		=	$index;
		$_SERVER['REQUEST_URI']			=	str_replace( $path . '/notif.php', '/', $_SERVER['REQUEST_URI'] );
		$_SERVER['SCRIPT_NAME']			=	str_replace( $path . '/notif.php', '/index.php', $_SERVER['SCRIPT_NAME'] );
		$_SERVER['PHP_SELF']			=	str_replace( $path . '/notif.php', '/index.php', $_SERVER['PHP_SELF'] );

		require_once( $index );
	} else {
		header( 'HTTP/1.0 501 Not Implemented' );
	}
} else {
	header( 'HTTP/1.0 404 Not Found' );
	exit();
}
