<?php
/**
* @version $Id: payradio.php 1465 2012-07-10 17:37:13Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/
/** ensure this file is being included by a parent file */
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

$tmplVersion	=	1;	// This is the template version that needs to match

$cssId			=	'paym' . $this->radioValue;
$cssClass		=	'cbregCCselInput';

if ( $this->payNameForCssClass ) {
	$cssClass	.=	' ' . $this->payNameForCssClass;
}
?>
	<div class="form-check <?php echo htmlspecialchars( $cssClass ); ?>">
		<input type="radio" class="align-middle form-check-input cbpaidCCpaymethod" id="<?php echo htmlspecialchars( $cssId ); ?>" <?php if ( $this->selected ) { ?>checked="checked"<?php } ?> />
		<label for="<?php echo htmlspecialchars( $cssId ); ?>" title="<?php echo htmlspecialchars( $this->altText ); ?>" class="align-middle form-check-label">
			<?php if ( $this->brandLabelHtml ) { ?>
				<div class="<?php echo ( $this->cardTypes ? 'mb-1 ' : '' ); ?>cbregCCselLabel">
					<?php
					if ( $this->cardTypes || $this->selected ) {
						echo $this->brandLabelHtml;
					} else {
					?>
						<input type="submit" class="p-0 btn btn-link text-body" value="<?php echo htmlspecialchars( $this->brandLabelHtml ); ?>" />
					<?php
					}
					?>
				</div>
			<?php } ?>
			<?php
			foreach ( $this->cardTypes as $cardType => $cardImg ) {
				$cardTypeCSSClass		=	$this->cardTypesCSS;

				if ( ( ! $cardTypeCSSClass ) && ( strpos( $cardImg, '/plug_cbpaidsubscriptions/icons/cards/' ) !== false ) && ( strpos( $cardImg, 'cc_' ) === false ) ) {
					// Style default card images as buttons:
					$cardTypeCSSClass	=	'p-1 rounded-0 btn btn-sm btn-light border shadow-none disabled cbpaidCCimageIcon';

					// Check if we're a pseudo pay now or subscribe button so we can point to the original image:
					if ( strpos( $cardImg, '_pay.png' ) !== false ) {
						$cardImg		=	str_replace( '_pay.png', '.png', $cardImg );
					} elseif ( strpos( $cardImg, '_subscribe.png' ) !== false ) {
						$cardImg		=	str_replace( '_subscribe.png', '.png', $cardImg );
					} elseif ( strpos( $cardImg, '_checkout.png' ) !== false ) {
						$cardImg		=	str_replace( '_checkout.png', '.png', $cardImg );
					} elseif ( ( strpos( $cardImg, '_cards' ) !== false ) && preg_match('/_cards(?:_[a-zA-Z_]+)?\.png/', $cardImg ) ) {
						$cardImg		=	preg_replace( '/_cards(?:_[a-zA-Z_]+)?\.png/', '.png', $cardImg );
					}
				}

				if ( preg_match( "/(\\.jpg|\\.png|\\.gif)\$/i", $cardImg ) ) {
					if ( $cardTypeCSSClass ) {
					?>
						<button type="<?php echo ( $this->selected ? 'button' : 'submit' ); ?>" class="<?php echo htmlspecialchars( $cardTypeCSSClass ) . ' '; ?>cbpaidCCimageInput" title="<?php echo htmlspecialchars( $this->altText ); ?>">
							<img src="<?php echo htmlspecialchars( $cardImg ); ?>" alt="<?php echo htmlspecialchars( $cardType ); ?>" />
						</button>
					<?php
					} else {
					?>
						<input type="image" src="<?php echo htmlspecialchars( $cardImg ); ?>" class="cbpaidCCimageInput" alt="<?php echo htmlspecialchars( $this->altText ); ?>" title="<?php echo htmlspecialchars( $this->altText ); ?>" />
					<?php
					}
				} else {
				?>
					<input type="<?php echo ( $this->selected ? 'button' : 'submit' ); ?>" class="<?php echo ( $cardTypeCSSClass ? htmlspecialchars( $cardTypeCSSClass ) . ' ' : '' ); ?>cbpaidCCbuttonInput" value="<?php echo htmlspecialchars( $cardImg ); ?>" title="<?php echo htmlspecialchars( $this->altText ); ?>" />
				<?php
				}
			}
			?>
<?php	if ( $this->brandDescriptionHtml && $this->selected ) { ?>
	<div class="pt-1 text-small cbregCCselDescription">
		<?php echo $this->brandDescriptionHtml; ?>
	</div>
<?php	}	?>
		</label>
	</div>