<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/
/** ensure this file is being included by a parent file */

use CBLib\Application\Application;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

$tmplVersion				=	1;	// This is the template version that needs to match
$cssLocation				=	( Application::Cms()->getClientId() ? 'cbreg_admin_' : 'cbreg_' );

if ( strpos( $this->cssclass, $cssLocation . 'green' ) !== false ) {
	if ( strpos( $this->cssclass, 'bg-success' ) ===  false ) {
		$this->cssclass		.=	' bg-success';
	}

	if ( strpos( $this->cssclass, 'text-white' ) ===  false ) {
		$this->cssclass		.=	' text-white';
	}
} elseif ( strpos( $this->cssclass, $cssLocation . 'red' ) !== false ) {
	if ( strpos( $this->cssclass, 'bg-danger' ) === false ) {
		$this->cssclass		.=	' bg-danger';
	}

	if ( strpos( $this->cssclass, 'text-white' ) ===  false ) {
		$this->cssclass		.=	' text-white';
	}
} elseif ( strpos( $this->cssclass, $cssLocation . 'blue' ) !== false ) {
	if ( strpos( $this->cssclass, 'bg-primary' ) ===  false ) {
		$this->cssclass		.=	' bg-primary';
	}

	if ( strpos( $this->cssclass, 'text-white' ) ===  false ) {
		$this->cssclass		.=	' text-white';
	}
} elseif ( strpos( $this->cssclass, $cssLocation . 'cyan' ) !== false ) {
	if ( strpos( $this->cssclass, 'bg-info' ) ===  false ) {
		$this->cssclass		.=	' bg-info';
	}

	if ( strpos( $this->cssclass, 'text-white' ) ===  false ) {
		$this->cssclass		.=	' text-white';
	}
} elseif ( strpos( $this->cssclass, $cssLocation . 'yellow' ) !== false ) {
	if ( strpos( $this->cssclass, 'bg-white' ) ===  false ) {
		$this->cssclass		.=	' bg-white';
	}
}
?>
<div class="mb-3 cbregPlan cbregPlan_default cbregPlanSelector cbregPlanSelector_default<?php echo $this->cssclass; ?>" id="<?php echo $this->cssid; ?>">
	<div class="m-0 form-check cbRegNameDesc">
		<?php echo $this->_tick; ?>
		<div class="form-check-label mb-1 font-weight-bold cbregName<?php echo $this->cssclass; ?>">
			<?php echo $this->_labelledName; ?>
		</div>
		<div class="cbregParagraph<?php echo $this->cssclass; ?>">
			<?php if ( $this->description != null ) { ?>
				<div class="cbregDescription">
					<?php echo $this->description; ?>
				</div>
			<?php } ?>

			<?php if ( $this->_insertBeforePrice ) { ?>
				<div class="cbregAfterSubDescription">
					<?php echo $this->_insertBeforePrice; ?>
				</div>
			<?php } ?>

			<?php if ( $this->periodPrice != null ) { ?>
				<div class="cbregFee">
					<?php echo $this->periodPrice; ?>
				</div>
			<?php } ?>

			<?php if ( $this->_insertAfterDescription ) { ?>
				<div class="mt-2 cbregSubPlanSelector">
					<?php echo $this->_insertAfterDescription; ?>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
