<?php
/**
* @version $Id: default.php 1465 2012-07-10 17:37:13Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/
/** ensure this file is being included by a parent file */

use CBLib\Application\Application;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

$tmplVersion	=	1;	// This is the template version that needs to match
$iconClass			=	$this->_model->getParam( 'template_rounded_icon', '' );

if ( $iconClass ) {
	$iconClass		=	' cbregPlanIcon_' . $iconClass;
}

$cssLocation		=	( Application::Cms()->getClientId() ? 'cbreg_admin_' : 'cbreg_' );
$panelClass			=	null;
$headerClass		=	null;

if ( strpos( $this->cssclass, $cssLocation . 'green' ) !== false ) {
	$panelClass		=	' border-success';
	$headerClass	=	' bg-success text-white';
} elseif ( strpos( $this->cssclass, $cssLocation . 'red' ) !== false ) {
	$panelClass		=	' border-danger';
	$headerClass	=	' bg-danger text-white';
} elseif ( strpos( $this->cssclass, $cssLocation . 'blue' ) !== false ) {
	$panelClass		=	' border-primary';
	$headerClass	=	' bg-primary text-white';
} elseif ( strpos( $this->cssclass, $cssLocation . 'cyan' ) !== false ) {
	$panelClass		=	' border-info';
	$headerClass	=	' bg-info text-white';
} elseif ( strpos( $this->cssclass, $cssLocation . 'yellow' ) !== false ) {
	$panelClass		=	' border-warning';
	$headerClass	=	' bg-warning text-white';
}
?>
<div class="mb-3 align-top cbregPlan cbregPlan_rounded cbregPlanSelector cbregPlanSelector_rounded<?php echo $this->cssclass . $iconClass; ?>" id="<?php echo $this->cssid; ?>">
	<div class="card<?php echo $panelClass; ?> cbRegNameDesc">
		<?php if ( $this->periodPrice == null ) { ?>
			<div class="card-header<?php echo $headerClass; ?> p-2">
				<div class="m-0 form-check">
					<?php echo $this->_tick; ?>
					<div class="form-check-label font-weight-bold cbregName<?php echo $this->cssclass; ?>">
						<?php echo $this->_labelledName; ?>
					</div>
				</div>
			</div>
		<?php } else { ?>
			<div class="card-header<?php echo $headerClass; ?> p-2 font-weight-bold cbregName<?php echo $this->cssclass; ?>">
				<?php echo $this->_labelledName; ?>
			</div>
		<?php } ?>

		<div class="card-body p-0 cbregParagraph<?php echo $this->cssclass; ?>">
			<?php if ( $this->description != null ) { ?>
				<div class="m-2 cbregDescription">
					<?php echo $this->description; ?>
				</div>
			<?php } ?>

			<?php if ( $this->_insertBeforePrice ) { ?>
				<div class="m-2 cbregAfterSubDescription">
					<?php echo $this->_insertBeforePrice; ?>
				</div>
			<?php } ?>

			<?php if ( $this->periodPrice != null ) { ?>
				<div class="m-2 form-check">
					<?php echo $this->_tick; ?>
					<div class="form-check-label font-weight-bold cbregFee">
						<?php echo $this->periodPrice; ?>
					</div>
				</div>
			<?php } ?>

			<?php if ( $this->_insertAfterDescription ) { ?>
				<div class="m-2 cbregSubPlanSelector">
					<?php echo $this->_insertAfterDescription; ?>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
