<?php
/**
* @version $Id: default.php 1465 2012-07-10 17:37:13Z beat $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/
/** ensure this file is being included by a parent file */

use CBLib\Application\Application;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

$tmplVersion		=	1;	// This is the template version that needs to match
$cssClass			=	trim( $this->_model->cssclass );
$iconClass			=	$this->_model->subscription->getPlan()->getParam( 'template_rounded_icon', '', 'params' );

if ( $cssClass ) {
	$cssClass		=	' ' . $cssClass;
}

if ( $iconClass ) {
	$cssClass		.=	' cbregPlanIcon_' . $iconClass;
}

$cssLocation		=	( Application::Cms()->getClientId() ? 'cbreg_admin_' : 'cbreg_' );
$panelClass			=	null;
$headerClass		=	null;

if ( strpos( $cssClass, $cssLocation . 'green' ) !== false ) {
	$panelClass		=	' border-success';
	$headerClass	=	' bg-success text-white';
} elseif ( strpos( $cssClass, $cssLocation . 'red' ) !== false ) {
	$panelClass		=	' border-danger';
	$headerClass	=	' bg-danger text-white';
} elseif ( strpos( $cssClass, $cssLocation . 'blue' ) !== false ) {
	$panelClass		=	' border-primary';
	$headerClass	=	' bg-primary text-white';
} elseif ( strpos( $cssClass, $cssLocation . 'cyan' ) !== false ) {
	$panelClass		=	' border-info';
	$headerClass	=	' bg-info text-white';
} elseif ( strpos( $cssClass, $cssLocation . 'yellow' ) !== false ) {
	$panelClass		=	' border-warning';
	$headerClass	=	' bg-warning text-white';
}
?>
<div class="mb-2 cbregPlan cbregPlan_rounded cbregPlanStatus cbregPlanStatus_rounded<?php echo $cssClass; ?>">
	<div class="card<?php echo $panelClass; ?> cbRegNameDesc">
		<div class="card-header<?php echo $headerClass; ?> p-2">
			<div class="m-0 form-check">
				<div class="bg-none w-auto h-auto border-0 form-check-input mt-0 cbregTick">
					<?php echo $this->_icon; ?>
				</div>
				<div class="form-check-label font-weight-bold cbregName">
					<?php echo $this->_model->get( 'name' ); ?>
				</div>
			</div>
		</div>

		<div class="card-body p-0 cbregParagraph">
			<?php if ( $this->_model->get( 'description' ) != null ) { ?>
				<div class="m-2 cbregDescription">
					<?php echo $this->_model->get( 'description' ); ?>
				</div>
			<?php } ?>

			<?php if ( $this->_insertBeforeValidity ) { ?>
				<div class="m-2 cbregAfterSubDescription">
					<?php echo $this->_insertBeforeValidity; ?>
				</div>
			<?php } ?>

			<?php if ( $this->_model->get( 'validity' ) || $this->_model->get( 'stateText' ) ) { ?>
				<div class="m-2 cbregValExp">
					<?php if ( $this->_model->get( 'validity' ) ) { ?>
						<span class="cbregValidity">
							<?php echo $this->_model->get( 'validity' ); ?>
						</span>
					<?php } ?>

					<?php if ( $this->_model->get( 'stateText' ) ) { ?>
						<span class="cbregExpiring">
							<?php echo $this->_model->get( 'stateText' ); ?>
						</span>
					<?php } ?>
				</div>
			<?php } ?>

			<?php if ( $this->_insertAfterDescription ) { ?>
				<div class="m-2 cbregSubPlanSelector">
					<?php echo $this->_insertAfterDescription; ?>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
