<?php
/**
* CBLib, Community Builder Library(TM)
* @version $Id: 6/18/14 3:18 PM $
* @copyright (C) 2004-2023 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

defined('CBLIB') or die();

/**
 * cbPMSHandler Class implementation
 * PMS Class for handling the CB PMS api
 */
class cbPMSHandler extends cbTabHandler
{
	/**
	 * Constructor (needed for PHP 7 so that we can keep the old PHP4-type constructor until CB 3.0)
	 */
	public function __construct()
	{
		parent::__construct();
	}

	/**
	 * Old-fashioned constructor (for UddeIM temporary compatibility:
	 * @deprecated 2.0 Use parent::__construct();
	 */
	public function cbPMSHandler()
	{
		self::__construct();
	}

	/**
	 * Sends a PMS message (HTML)
	 *
	 * @param  int     $toUserId        UserId of receiver
	 * @param  int     $fromUserId      UserId of sender
	 * @param  string  $subject         Subject of PMS message in HTML format
	 * @param  string  $message         Body of PMS message in HTML format
	 * @param  boolean $systemGenerated False: real user-to-user message; True: system-Generated by an action from user $fromid (if non-null)
	 * @param  string  $fromName        The name of the public sender
	 * @param  string  $fromEmail       The email address of the public sender
	 * @return string|boolean           Either string HTML for tab content, or false if ErrorMSG generated
	 */
	public function sendUserPMS( $toUserId, $fromUserId, $subject, $message, $systemGenerated = false, $fromName = null, $fromEmail = null )
	{
	}

	/**
	 * returns all the parameters needed for a hyperlink or a menu entry to do a pms action
	 *
	 * @param  int     $toUserId     UserId of receiver
	 * @param  int     $fromUserId   UserId of sender
	 * @param  string  $subject      Subject of PMS message
	 * @param  string  $message      Body of PMS message
	 * @param  int     $kind         kind of link: 1: link to compose new PMS message for $toid user. 2: link to inbox of $fromid user; 3: outbox, 4: trashbox, 5: link to edit pms options
	 * @return array|boolean         Array of string {"caption" => menu-text ,"url" => NON-cbSef relative url-link, "tooltip" => description} or false and errorMSG
	 */
	public function getPMSlink( $toUserId, $fromUserId, $subject, $message, $kind )
	{
	}

	/**
	 * gets PMS system capabilities
	 *
	 * @return mixed array of string {'subject' => boolean ,'body' => boolean} or false if ErrorMSG generated
	 */
	public function getPMScapabilites( )
	{
	}

	/**
	 * gets PMS unread messages count
	 *
	 * @param  int          $userId  User id
	 * @return int|boolean           Number of messages unread by user $userid or false if ErrorMSG generated
	 */
	public function getPMSunreadCount( $userId )
	{
	}
}
