<?php
/**
 * Paid Subscriptions Module
 *
 * @version $Id: mod_cbsubscriptions.php 1608 2012-12-29 04:12:52Z beat $
 * @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
 * @subpackage Plugin for Paid Subscriptions
 * @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Language\CBTxt;
use Joomla\Registry\Registry as JRegistry;		// For php-doc comments only, as not J 2.5-compatible!

// make sure file is inclded correctly:
if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

{
	// debug mode handling:
	global $_CBSUBS_DEBUG;
	if ( isset( $_CBSUBS_DEBUG ) && $_CBSUBS_DEBUG ) {
		global $_CB_PAID_MOD_OLD_ERRORS;
		$_CB_PAID_MOD_OLD_ERRORS			=	error_reporting(E_ALL);
		$_CB_PAID_MOD_OLD_DISPLAY_ERRORS	=	ini_get( 'display_errors' );
		ini_set('display_errors',true);
	} else {
		$_CB_PAID_MOD_OLD_ERRORS			=	null;
		$_CB_PAID_MOD_OLD_DISPLAY_ERRORS	=	null;
	}

	// Version variables:
	$cbpaidModuleVersion				=	'4.6.1+build.2023.03.27.21.31.22.c7790254e';	//CBSUBS_VERSION_AUTOMATICALLY_SET_DO_NOT_EDIT!!!
	$cbpaidplugin						=	'cbpaidsubscriptions';

	// Load CB framework:
	global $_CB_framework, $ueConfig, $_SERVER;
	$_CB_cms_adminpath				=	JPATH_ADMINISTRATOR;

	$_CB_adminpath						=	$_CB_cms_adminpath. '/components/com_comprofiler';

	if ( ! file_exists( $_CB_adminpath . '/plugin.foundation.php' ) ) {
		echo 'CB not installed';
		return;
	}
	/** @noinspection PhpIncludeInspection */
	include_once( $_CB_adminpath . '/plugin.foundation.php' );

	$absolute_path						=	$_CB_framework->getCfg( 'absolute_path' );
	$live_site							=	$_CB_framework->getCfg( 'live_site' );
	$now								=	$_CB_framework->now();

	// Check that CBSubs is installed:
	if ( ! file_exists( $absolute_path . '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/cbpaidsubscriptions.class.php' ) ) {
		echo "CBSubs CB plugin is not installed";
		return;
	}

	// Get module params:
	// $params is defined by include: ignore these warnings:
	/** @var $params JRegistry */
	$moduleclass_sfx					=	$params->get( 'moduleclass_sfx', '');
	$pretext 							=	trim( $params->get( 'pretext', '' ) );
	$posttext 							=	trim( $params->get( 'posttext', '' ) );
	$greeting 							=	$params->def( 'greeting', 1 );
	$display_current 					=	$params->def( 'display_current', 1 );
	$display_unpaid_invoices			=	$params->def( 'display_unpaid_invoices', 1 );
	$display_current_pretext 			=	trim( $params->def( 'display_current_pretext', '' ) );
	$display_upgrades		 			=	$params->def( 'display_upgrades', 1 );
	$display_upgrades_children 			=	$params->def( 'display_upgrades_children', 0 );
	$display_upgrades_pretext 			=	trim( $params->def( 'display_upgrades_pretext', '' ) );
	$name 								=	trim( $params->def( 'name', 0 ) );
	$linkItemId							=	(int) $params->def( 'linkitemid', 0 );
	$messagesArray						=	array();
	$messagesArray['register']			=	$params->get( 'register_messages', '' );
	$messagesArray['subscribe']			=	$params->get( 'subscribe_messages', '' );
	$messagesArray['upgrade']			=	$params->get( 'upgrade_messages', '' );
	$messagesArray['renew']				=	$params->get( 'renew_messages', '' );
	$messagesArray['thanks']			=	$params->get( 'thanks_messages', '' );
	$messagesArray['pay']				=	$params->get( 'pay_messages', '' );

	$anythingToDisplay					=	false;

	// These 2 CB libs are needed because of at least cbTemplateHandler:
	/** @noinspection PhpIncludeInspection */
	include_once( $absolute_path . '/administrator/components/com_comprofiler/plugin.class.php');
	/** @noinspection PhpIncludeInspection */
	include_once( $absolute_path . '/administrator/components/com_comprofiler/comprofiler.class.php');

	// CBSubs lib:
	/** @noinspection PhpIncludeInspection */
	include_once( $absolute_path . '/components/com_comprofiler/plugin/user/plug_cbpaidsubscriptions/cbpaidsubscriptions.class.php' );		// needed for language strings
	// CBSubs language:
	cbpaidApp::loadLang();

	// Check that versions match:
	if ( ! is_callable( array( 'cbpaidApp', 'version' ) ) || ! cbStartOfStringMatch( cbpaidApp::version(), $cbpaidModuleVersion ) ) {
		echo '<div class="error">Module Version <> CBSubs version.</div>';
	}


	if ( $_CB_framework->myId() ) {

		// Logged-in user:

		// cbsubs debugger on:
		cbpaidErrorHandler::install();
		cbpaidErrorHandler::on();

		global $_CB_database, $_PLUGINS;

		// Get CBSubs settings:
		$cbpaidParams					=	cbpaidApp::settingsParams();
		$showRenewButtons				=	( $cbpaidParams->get( 'showRenewButtons', '1' )		== '1' );

		// checks if subscription is valid, expires subscription and redirects if no valid access:
		$_PLUGINS->trigger( 'onCBSubsCheckExpireMe', array( 'mod_subscriptions' ) );

		// compute greating name:
		if ( $name ) {
			if ($name == 2) {
				$query					=	'SELECT firstname FROM #__comprofiler WHERE id = '. (int) $_CB_framework->myId();
			} else {
				$query					=	'SELECT name FROM #__users WHERE id = '. (int) $_CB_framework->myId();
			}
			$_CB_database->setQuery( $query );
			$name						=	htmlspecialchars( $_CB_database->loadResult() );
		} else {
			$name						=	htmlspecialchars( $_CB_framework->myUsername() );
		}

		// load active subscriptions into $activeSubscriptions and plans to which user can upgrade into $upgradePlans
		$activeSubscriptions			=	array();
		$upgradePlans					=	cbpaidSubscriptionsMgr::getInstance()->getUpgradeAndRenewalPossibilities( 1, $_CB_framework->myId(), $now, $activeSubscriptions );

		// go through subscriptions to see possible action items for the logged-in user:
		$one_sub_active					=	false;
		$one_sub_to_be_paid				=	false;
		$one_sub_renewable				=	false;
		$one_sub_upgradable				=	false;

		// $inactiveSubscriptions		=	array();
		foreach ( $activeSubscriptions as $k => $s ) {
			// 		if ( $activeSubscriptions[$k]->checkIfThisAndParentSubscriptionIsValid() ) {
			/** @var $s cbpaidSomething */
			$activeSubscriptions[$k]->_plan_name	=	$s->getPlan()->getPersonalized( 'name', $s->user_id, true );

			$realStatus					=	( is_callable( array( $s, 'realStatus' ) ) ? $s->realStatus( $now ) : $s->status );		// method added in CBsubs 1.3.0: avoid crashing site if previous version
			$isRenewable				=	$s->checkIfRenewable();
			if ( $isRenewable ) {
				$one_sub_renewable		=	true;
			}
			if ( $realStatus == 'A' ) {
				$one_sub_active			=	true;
			} elseif ( $realStatus == 'R' && $display_unpaid_invoices ) {
				$one_sub_to_be_paid		=	true;
			} elseif ( in_array( $realStatus, array( 'X', 'C' ) ) && $showRenewButtons && $isRenewable && $display_unpaid_invoices ) {
				// $one_sub_renewable	=	true;	// done already above
			} else {
				// $inactiveSubscriptions[$k]	=	$s;
				// unset( $activeSubscriptions[$k] );
			}
		}

		// find if one subscription is upgradable:
		$one_sub_upgradable				=	false;
		foreach ( $upgradePlans as $k => $v ) {
			if ( ! ( isset( $v->_drawOnlyAsContainer ) && $v->_drawOnlyAsContainer ) ) {
				if ( $display_upgrades_children || ( $v->parent == 0 ) ) {
					$one_sub_upgradable	=	true;
					break;
				}
			}
		}

		// compute most appropriate marketing message type:
		if ( $one_sub_to_be_paid ) {
			$marketMessages				=	'pay';
		} elseif ( ! $one_sub_active ) {
			$marketMessages				=	'subscribe';
		} elseif ( $one_sub_active && $one_sub_upgradable ) {
			$marketMessages				=	'upgrade';
		} elseif ( $showRenewButtons && $one_sub_renewable ) {
			$marketMessages				=	'renew';
		} elseif ( $one_sub_active ) {
			$marketMessages				=	'thanks';
		} else {
			$marketMessages				=	null;
		}

		$anythingToDisplay				=	( ( $display_current && $one_sub_active )
											||	( $display_upgrades && ( $one_sub_upgradable || $one_sub_renewable ) ) );
											// below we do ||	$messageToDisplay );


	} else {

		// Guest / User not logged in:

		// only "register" marketing message type applies:
		$marketMessages					=	'register';

	}

	// pick a message randomly:
	$messageToDisplay					=	'';
	if ( ( $marketMessages != null ) && ( $messagesArray[$marketMessages] != '' ) ) {
		$theseMessages					=	explode( "[OR_MESSAGE]", $messagesArray[$marketMessages] );
		$nbrMessages					=	count( $theseMessages );
		if ( $nbrMessages > 0 ) {
			$random						=	mt_rand( 0, $nbrMessages - 1 );
			$messageToDisplay			=	$theseMessages[$random];
		}
	}
	$anythingToDisplay					=	$anythingToDisplay || ( $messageToDisplay != '' );



	// outputs module, if anything to display:
	if ( $anythingToDisplay ) {

		$modulePath						=	$absolute_path . '/modules/mod_cbsubscriptions/';
		$liveModulePath					=	$_CB_framework->getCfg( 'live_site' ) . '/modules/mod_cbsubscriptions/';

		$hiName							=	CBuser::getMyInstance()->replaceUserVars( CBTxt::T( 'Hi, [formatname]' ) );

		// check if the message to display is a picture:
		if ( preg_match( '/(\.jpg|\.png|\.gif)$/i', $messageToDisplay ) ) {
			$messageToDisplay			=	'<img src="' . htmlspecialchars( $_CB_framework->getCfg( 'live_site' ) . $messageToDisplay ) . '" alt="" />';
		}

		$actionLink						=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'display_subscriptions' ), false );

		/** @noinspection SpellCheckingInspection */
		/** @noinspection PhpIncludeInspection */
		include $modulePath . '/mod_cbsubscriptions.view.php';
	}

	if ( $_CB_framework->myId() ) {
		cbpaidErrorHandler::off();
		cbpaidErrorHandler::uninstall();
	}
	// debug mode off:
	global $_CBSUBS_DEBUG;
	if ( isset( $_CBSUBS_DEBUG ) && $_CBSUBS_DEBUG ) {
		ini_set('display_errors', $_CB_PAID_MOD_OLD_DISPLAY_ERRORS);
		error_reporting( $_CB_PAID_MOD_OLD_ERRORS );
	}
}
