<?php
/**
 * Paid Subscriptions Module View file
 *
 * @version $Id: mod_cbsubscriptions.view.php 1465 2012-07-10 17:37:13Z beat $
 * @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
 * @subpackage Plugin for Paid Subscriptions
 * @copyright (C) 2007-2022 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Language\CBTxt;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }

/** @var $anythingToDisplay boolean */
/** @var $_CB_framework CBframework */
/** @var $liveModulePath string */
/** @var $pretext string */
/** @var $greeting boolean */
/** @var $moduleclass_sfx string */
/** @var $hiName string */
/** @var $display_current boolean */
/** @var $display_upgrades boolean */
/** @var $display_upgrades_children boolean */
/** @var $one_sub_upgradable boolean */
/** @var $display_current_pretext string */
/** @var $display_upgrades_pretext string */
/** @var $activeSubscriptions cbpaidSomething[] */
/** @var $upgradePlans cbpaidProduct[] */
/** @var $now int */
/** @var $showRenewButtons boolean */
/** @var $actionLink string */
/** @var $messageToDisplay string */
/** @var $marketMessages string */
/** @var $posttext string */

if ( $anythingToDisplay ) {
	$_CB_framework->document->addHeadStyleSheet( $liveModulePath . 'mod_cbsubscriptions.view.css' );
?>

	<div class="modcbsubEncl">

<?php
		echo CBTxt::Th($pretext);

		if ( $_CB_framework->myId() && $greeting ) {
?>
		<div class="modcbsubGreeting<?php echo $moduleclass_sfx; ?>"><?php echo $hiName; ?></div>
<?php
	}
?>
<?php
		if ( $_CB_framework->myId() && $display_current && ( count( $activeSubscriptions ) > 0 ) ) {
?>
		<div class="modcbsubCurrent<?php echo $moduleclass_sfx; ?>">
			<?php echo ( $display_current_pretext ? "<div>" . CBTxt::Th( $display_current_pretext ) . "</div>" : "" ); ?>
			<ul>
<?php
			foreach ( $activeSubscriptions as $sub ) {
				$realStatus					=	( is_callable( array( $sub, 'realStatus' ) ) ? $sub->realStatus( $now ) : $sub->status );		// method added in CBsubs 1.3.0: avoid crashing site if previous version
				
				if ( ( ! isset( $sub->_plan_name ) ) || ( in_array( $realStatus, array( 'X', 'C' ) ) && ! ( $sub->checkIfRenewable() && $showRenewButtons ) ) ) {
					continue;
				}
				if ( $realStatus == 'A' ) {
?>
				<li id="modsubCurrent<?php echo $sub->plan_id; ?>"><?php
					echo $sub->_plan_name;
					if ( $sub->checkIfRenewable() ) {
						echo ': ';
						echo '<span class="modsubActive' . htmlspecialchars( $moduleclass_sfx ) . '">';
						echo CBTxt::Th( 'active' ) . '. ';
						echo '</span>';
						echo '&nbsp; <a href="' . htmlspecialchars( $actionLink ) . '" class="mod_login' . htmlspecialchars( $moduleclass_sfx ) . '">';
						echo CBTxt::Th( 'Renew Now' );
						echo "</a>";
					}
				?></li>
<?php
				} else {
					switch ( $realStatus ) {
						case 'R':

							$txtUnpaid		=	"unpaid";			// CBTxt::Th("unpaid");
							$txtPayNow		=	"Pay Now";			// CBTxt::Th("Pay Now");
							break;
						case 'X':
							$txtUnpaid		=	"expired";			// CBTxt::Th("expired");
							$txtPayNow		=	"Renew Now";		// CBTxt::Th("Renew Now");
							break;
						case 'C':
							$txtUnpaid		=	"cancelled";		// CBTxt::Th("cancelled");
							$txtPayNow		=	"Resubscribe Now";	// CBTxt::Th("Resubscribe Now");
							break;
						default:
							// really an error condition:
							$txtUnpaid		=	"";
							$txtPayNow		=	"Check Now";		// CBTxt::Th("Check Now");
							break;
					}
?>
				<li id="modsubPay<?php echo $sub->plan_id; ?>"><?php
					echo $sub->_plan_name;
					echo ': ';
					echo '<span class="modsubUnpaid' . htmlspecialchars( $moduleclass_sfx ) . '">';
					echo CBTxt::Th( $txtUnpaid ) . '. ';
					echo '</span>';
					echo '&nbsp; <a href="' . htmlspecialchars( $actionLink ) . '" class="mod_login' . htmlspecialchars( $moduleclass_sfx ) . '">';
					echo CBTxt::Th( $txtPayNow );
					echo "</a>";
				?></li>
<?php
				}
			}
?>
			</ul>
		</div>
<?php
	}

	if ( $_CB_framework->myId() && $display_upgrades && $one_sub_upgradable ) {
?>
		<div class="modcbsubUpgrades<?php echo htmlspecialchars( $moduleclass_sfx ); ?>">
			<?php echo ( $display_upgrades_pretext ? "<div>" . CBTxt::Th($display_upgrades_pretext) . "</div>" : "" ); ?>
			<ul>
			<?php
			foreach ( $upgradePlans as $plan ) {
				if ( ! ( isset( $plan->_drawOnlyAsContainer ) && $plan->_drawOnlyAsContainer ) ) {
					if ( $display_upgrades_children || ( $plan->parent == 0 ) ) {
			?>
				<li id="modsubUpgrade<?php echo (int) $plan->id; ?>"><?php
					echo '<a href="' . htmlspecialchars( $actionLink ) . '" class="mod_login' . htmlspecialchars( $moduleclass_sfx ) . '">';
					echo $plan->getPersonalized( 'name', $_CB_framework->myId(), true );
					echo "</a>";
				?></li>
<?php
					}
				}
			}
?>
			</ul>
		</div>
<?php
	}
	
	if ( $messageToDisplay ) {
		?><div class="modcbsubMessage<?php echo htmlspecialchars( $moduleclass_sfx ); ?>" id="modcbsub<?php echo $marketMessages; ?>"><?php
		echo '<a href="' . htmlspecialchars( $actionLink ) . '">';
		if ($messageToDisplay[0] == "<" ) {
			echo CBTxt::Th($messageToDisplay);
		} else {
			echo "<span>" . CBTxt::Th($messageToDisplay) . "</span>";
		}
		echo '</a>';
		?></div><?php
	}
	echo CBTxt::Th($posttext);
?>
	</div>

	
<?php
}
