<?php
/**
 * @package         Snippets
 * @version         8.4.7
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use Joomla\CMS\Language\Text as JText;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\EditorButtonPlugin as RL_EditorButtonPlugin;
use RegularLabs\Library\Extension as RL_Extension;
use RegularLabs\Library\Parameters as RL_Parameters;

defined('_JEXEC') or die;

if ( ! is_file(JPATH_LIBRARIES . '/regularlabs/regularlabs.xml')
    || ! class_exists('RegularLabs\Library\Parameters')
    || ! class_exists('RegularLabs\Library\DownloadKey')
    || ! class_exists('RegularLabs\Library\EditorButtonPlugin')
)
{
    return;
}

if ( ! RL_Document::isJoomlaVersion(4))
{
    RL_Extension::disable('snippets', 'plugin', 'editors-xtd');

    return;
}

if (true)
{
    class PlgButtonSnippets extends RL_EditorButtonPlugin
    {
        protected $main_type       = 'component';
        protected $check_installed = ['component', 'plugin'];
        protected $button_icon     = '<svg viewBox="0 0 24 24" style="fill:none;" width="24" height="24" fill="none" stroke="currentColor">'
        . '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.121 14.121L19 19m-7-7l7-7m-7 7l-2.879 2.879M12 12L9.121 9.121m0 5.758a3 3 0 10-4.243 4.243 3 3 0 004.243-4.243zm0-5.758a3 3 0 10-4.243-4.243 3 3 0 004.243 4.243z" />'
        . '</svg>';

        protected function getPopupOptions()
        {
            $options = parent::getPopupOptions();

            $options['confirmCallback'] = 'RegularLabs.SnippetsButton.insertText(\'' . $this->editor_name . '\')';
            $options['confirmText']     = JText::_('RL_INSERT');

            return $options;
        }

        protected function loadScripts()
        {
            $params = RL_Parameters::getComponent($this->_name);

            RL_Document::scriptOptions([
                'syntax_word'              => $params->tag,
                'tag_characters'           => explode('.', $params->tag_characters),
            ], 'snippets_button');

            RL_Document::script('snippets.button');
        }
    }
}
