<?php
/**
 * @package         Snippets
 * @version         8.4.7
 * 
 * @author          Peter van Westen <info@regularlabs.com>
 * @link            http://regularlabs.com
 * @copyright       Copyright © 2023 Regular Labs All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use Joomla\CMS\Factory as JFactory;
use Joomla\CMS\HTML\HTMLHelper as JHtml;
use Joomla\CMS\Language\Text as JText;
use Joomla\CMS\Layout\LayoutHelper as JLayout;
use RegularLabs\Library\Article;
use RegularLabs\Library\Document as RL_Document;
use RegularLabs\Library\Language as RL_Language;
use RegularLabs\Library\Parameters as RL_Parameters;
use RegularLabs\Library\RegEx as RL_RegEx;
use RegularLabs\Library\StringHelper as RL_String;

defined('_JEXEC') or die;

RL_Document::style('regularlabs.admin-form');
RL_Language::load('com_snippets');

$params = RL_Parameters::getComponent('snippets');

$request = JFactory::getApplication()->input->getBase64('request');
if ($request)
{
    $request = json_decode(base64_decode($request));
}

$listOrder = RL_String::escape($this->state->get('list.ordering'));
$listDirn  = RL_String::escape($this->state->get('list.direction'));
$ordering  = ($listOrder == 'a.ordering');

$article_id  = JFactory::getApplication()->input->getInt('article_id');
$editor_name = JFactory::getApplication()->input->getString('editor', 'text');
// Remove any dangerous character to prevent cross site scripting
$editor_name = RL_RegEx::replace('[\'\";\s]', '', $editor_name);

$has_descriptions = false;
$has_categories   = false;

$category_id = JFactory::getApplication()->getUserState('com_content.edit.article.data.catid');
if (empty($category_id))
{
    $article     = Article::get($article_id);
    $category_id = $article->catid ?? JFactory::getApplication()->getUserState('com_content.articles.filter.category_id');
}

foreach ($this->items as $i => $item)
{
    if ($item->published !== 1)
    {
        unset($this->items[$i]);
        continue;
    }


    if ($item->description)
    {
        $has_descriptions = true;
    }

    if ($item->category)
    {
        $has_categories = true;
    }
}

$cols = 3;
$cols += ($has_descriptions ? 1 : 0);
$cols += ($has_categories ? 1 : 0);

?>

<form action="index.php" id="adminForm" name="adminForm" method="post" class="rl-form labels-sm">
    <?php
    // Search tools bar
    echo JLayout::render('joomla.searchtools.default', ['view' => $this]);
    ?>
    <table class="table table-striped" id="itemList">
        <thead>
            <tr>
                <th scope="col" class="w-1 text-nowrap text-center d-none d-md-table-cell">
                    <?php echo JHtml::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" class="w-20">
                    <?php echo JHtml::_('searchtools.sort', 'JFIELD_ALIAS_LABEL', 'a.alias', $listDirn, $listOrder); ?>
                </th>
                <th scope="col" class="w-20">
                    <?php echo JHtml::_('searchtools.sort', 'JGLOBAL_TITLE', 'a.name', $listDirn, $listOrder); ?>
                </th>
                <?php if ($has_descriptions) : ?>
                    <th scope="col" class="d-none d-md-table-cell">
                        <?php echo JHtml::_('searchtools.sort', 'JGLOBAL_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?>
                    </th>
                <?php endif; ?>
                <?php if ($has_categories) : ?>
                    <th scope="col" class="w-3 text-nowrap d-none d-md-table-cell">
                        <?php echo JHtml::_('searchtools.sort', 'JCATEGORY', 'a.category', $listDirn, $listOrder); ?>
                    </th>
                <?php endif; ?>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($this->items)): ?>
                <tr>
                    <td colspan="<?php echo $cols; ?>">
                        <?php echo JText::_('RL_NO_ITEMS_FOUND'); ?>
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($this->items as $i => $item) : ?>
                    <?php
                    $vars = '[]';
                    ?>
                    <tr class="row<?php echo $i % 2; ?>">
                        <td class="text-center text-nowrap d-none d-md-table-cell">
                            <button onclick="parent.RegularLabs.SnippetsButton.insertById('<?php echo $editor_name; ?>', <?php echo (int) $item->id; ?>, <?php echo $vars; ?>);"
                                    type="button" class="btn btn-secondary btn-sm text-left">
                                <span class="fa fa-file-code me-1" aria-hidden="true"></span>
                                <?php echo (int) $item->id; ?>
                            </button>
                        </td>
                        <td class="text-nowrap">
                            <button onclick="parent.RegularLabs.SnippetsButton.insertByAlias('<?php echo $editor_name; ?>', '<?php echo RL_String::escape($item->alias); ?>', <?php echo $vars; ?>);"
                                    type="button" class="btn btn-secondary btn-sm text-left">
                                <span class="fa fa-file-code me-1" aria-hidden="true"></span>
                                <?php echo RL_String::escape($item->alias); ?>
                            </button>
                        </td>
                        <td>
                            <button onclick="parent.RegularLabs.SnippetsButton.insertByTitle('<?php echo $editor_name; ?>', '<?php echo RL_String::escape($item->name); ?>', <?php echo $vars; ?>);"
                                    type="button" class="btn btn-secondary btn-sm text-left">
                                <span class="fa fa-file-code me-1" aria-hidden="true"></span>
                                <?php echo RL_String::escape($item->name); ?>
                            </button>
                        </td>
                        <?php if ($has_descriptions) : ?>
                            <?php
                            $description = explode('---', $item->description);
                            ?>
                            <td class="d-none d-md-table-cell">
                                <span><?php echo nl2br(RL_String::escape(trim($description[0]))); ?></span>
                                <?php if ( ! empty($description[1])) : ?>
                                    <div role="tooltip"><?php echo nl2br(RL_String::escape(trim($description[1]))); ?></div>
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                        <?php if ($has_categories) : ?>
                            <td class="d-none d-md-table-cell">
                                <?php
                                $category      = $item->category;
                                $category_icon = '';

                                if (strpos($category, '::'))
                                {
                                    [$category, $category_icon] = explode('::', $category, 2);
                                    $category_icon = '<span class="icon-' . $category_icon . '"></span>';
                                }

                                echo $category ? '<span class="badge rl-bg-teal">' . $category_icon . $category . '</span>' : '';
                                ?>
                            </td>
                        <?php endif; ?>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>

    <?php echo $this->pagination->getListFooter(); ?>

    <input type="hidden" name="rl_qp" value="1">
    <input type="hidden" name="tmpl" value="component">
    <input type="hidden" name="class" value="Plugin.EditorButton.Snippets.Popup">
    <input type="hidden" name="editor" value="<?php echo $editor_name; ?>">
    <input type="hidden" name="request" value="<?php echo JFactory::getApplication()->input->getBase64('request'); ?>">
    <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>">
    <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>">
</form>
