<?php
/**
 * CBLib, Community Builder Library(TM)
 *
 * @version       $Id: 23.12.16 18:05 $
 * @package       ${NAMESPACE}
 * @copyright (C) 2004-2014 www.joomlapolis.com / Lightning MultiCom SA - and its licensors, all rights reserved
 * @license       http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
 */

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CBLib\Registry\GetterInterface;

defined( 'CBLIB' ) or die();

class cbpaidControllerPaymentsHistory
{
	/**
	 * @param UserTable|null $user
	 * @return string|boolean
	 */
	public static function showPaymentsList( $user )
	{
		global $_CB_framework, $_CB_database;

		$params				=	cbpaidApp::settingsParams();

		if ( ! $params->get( 'show_payments_history', false, GetterInterface::BOOLEAN ) ) {
			return false;
		}

		$userId				=	Application::Input()->get( 'user', 0, GetterInterface::INT );

		if ( ! $userId ) {
			$user			=	\CBuser::getMyUserDataInstance();
		} else {
			$user			=	\CBuser::getUserDataInstance( $userId );
		}

		if ( ! $user->get( 'id', 0, GetterInterface::INT ) ) {
			return false;
		}

		if ( ( Application::MyUser()->getUserId() != $user->get( 'id', 0, GetterInterface::INT ) )
			 && ( ! cbpaidApp::authoriseAction( 'cbsubs.sales' ) )
			 && ( ! cbpaidApp::authoriseAction( 'cbsubs.financial' ) )
		) {
			return false;
		}

		$showPeriod			=	self::getPeriodDatetime();

		/** @var $viewer cbpaidPaymentsListView */
		$viewer				=	cbpaidTemplateHandler::getViewer( null, 'paymentslist' );

		$prefix				=	'payments_';
		$limit				=	(int) 30;
		$limitstart			=	$_CB_framework->getUserStateFromRequest( $prefix . 'limitstart{com_comprofiler}', $prefix . 'limitstart' );

		$query				=	"SELECT COUNT(*)"
							.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_payments' ) . " AS p"
							.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__cbsubs_payment_baskets' ) . " AS b"
							.	" ON b." . $_CB_database->NameQuote( 'id' ) . " = p." . $_CB_database->NameQuote( 'payment_basket_id' )
							.	"\n WHERE p." . $_CB_database->NameQuote( 'by_user_id' ) . " = " . $user->get( 'id', 0, GetterInterface::INT );
		if ( $showPeriod ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'time_created' ) . " > " . $_CB_database->Quote( $showPeriod );
		}
		$_CB_database->setQuery( $query );
		$total				=	(int) $_CB_database->loadResult();

		$pageNav			=	new cbPageNav( $total, $limitstart, $limit );

		$pageNav->setInputNamePrefix( $prefix );
		$pageNav->setStaticLimit( true );

		if ( Application::MyUser()->getUserId() != $user->get( 'id', 0, GetterInterface::INT ) ) {
			$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showpaymentslist', 'user' => $user->get( 'id', 0, GetterInterface::INT ) ), false ) );
		} else {
			$pageNav->setBaseURL( $_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showpaymentslist' ), false ) );
		}

		$query				=	"SELECT p.*"
							.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_payments' ) . " AS p"
							.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__cbsubs_payment_baskets' ) . " AS b"
							.	" ON b." . $_CB_database->NameQuote( 'id' ) . " = p." . $_CB_database->NameQuote( 'payment_basket_id' )
							.	"\n WHERE p." . $_CB_database->NameQuote( 'by_user_id' ) . " = " . $user->get( 'id', 0, GetterInterface::INT );
		if ( $showPeriod ) {
			$query			.=	"\n AND p." . $_CB_database->NameQuote( 'time_created' ) . " > " . $_CB_database->Quote( $showPeriod );
		}
		$query				.=	"\n ORDER BY p." . $_CB_database->NameQuote( 'time_created' ) . " DESC";
		$_CB_database->setQuery( $query, $pageNav->limitstart, $pageNav->limit );
		$rows				=	$_CB_database->loadObjectList( null, 'cbpaidPayment' );

		$viewer->setModel( $rows );

		return $viewer->drawPaymentsHistoryList( $user, $pageNav );
	}

	/**
	 * @param UserTable $user
	 * @return int
	 */
	public static function getPayments( $user )
	{
		global $_CB_database;

		$params			=	cbpaidApp::settingsParams();

		if ( ! $params->get( 'show_payments_history', false, GetterInterface::BOOLEAN ) ) {
			return 0;
		}

		$showPeriod		=	self::getPeriodDatetime();

		$query			=	"SELECT COUNT(*)"
						.	"\n FROM " . $_CB_database->NameQuote( '#__cbsubs_payments' ) . " AS p"
						.	"\n INNER JOIN " . $_CB_database->NameQuote( '#__cbsubs_payment_baskets' ) . " AS b"
						.	" ON b." . $_CB_database->NameQuote( 'id' ) . " = p." . $_CB_database->NameQuote( 'payment_basket_id' )
						.	"\n WHERE p." . $_CB_database->NameQuote( 'by_user_id' ) . " = " . $user->get( 'id', 0, GetterInterface::INT );
		if ( $showPeriod ) {
			$query		.=	"\n AND p." . $_CB_database->NameQuote( 'time_created' ) . " > " . $_CB_database->Quote( $showPeriod );
		}
		$_CB_database->setQuery( $query );

		return (int) $_CB_database->loadResult();
	}

	/**
	 * @return string|null
	 */
	private static function getPeriodDatetime()
	{
		global $_CB_database;

		$showPeriod		=	cbpaidApp::settingsParams()->get( 'payments_history_show_period', '0000-06-00 00:00:00', GetterInterface::STRING );

		if ( ( ! $showPeriod ) || ( $showPeriod == '0000-00-00 00:00:00' ) ) {
			return null;
		}

		$duration		=	cbpaidTimes::getInstance()->dateInterval( $showPeriod );
		$systemTimeZone	=	new DateTimeZone( cbpaidTimes::getInstance()->systemTimeZone() );
		$endDate		=	new DateTime( '@' . Application::Application()->getStartTime(), $systemTimeZone );

		$endDate->setTimezone( $systemTimeZone );

		$startDate		=	$endDate->sub( $duration );

		return $_CB_database->getUtcDateTime( $startDate->getTimestamp() );
	}
}
