<?php
/**
* @version $Id: $
* @package CBSubs (TM) Community Builder Plugin for Paid Subscriptions (TM)
* @subpackage Template for Paid Subscriptions
* @copyright (C) 2007-2020 and Trademark of Lightning MultiCom SA, Switzerland - www.joomlapolis.com - and its licensors, all rights reserved
* @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL version 2
*/

use CBLib\Application\Application;
use CB\Database\Table\UserTable;
use CBLib\Registry\GetterInterface;

if ( ! ( defined( '_VALID_CB' ) || defined( '_JEXEC' ) || defined( '_VALID_MOS' ) ) ) { die( 'Direct Access to this location is not allowed.' ); }


class cbpaidPaymentsListView extends cbpaidTemplateHandler
{
	/** @var cbpaidPayment[]  */
	public $_model			=	array();
	/** @var UserTable */
	public $user			=	null;
	/** @var cbPageNav */
	public $paging			=	null;
	/** @var string */
	public $title			=	null;
	/** @var array */
	public $items			=	array();
	/** @var array */
	public $invoices		=	array();
	/** @var array */
	public $amounts			=	array();
	/** @var string */
	public $paymentsListUrl	=	null;

	/**
	 * @param array $payments
	 */
	public function __construct( $payments )
	{
		parent::__construct();

		$this->_model	=	$payments;
	}

	/**
	 * @return int
	 */
	public function version()
	{
		return 1;
	}

	/**
	 * @param int       $paymentsNumber
	 * @param UserTable $user
	 * @return string
	 */
	public function drawProfilePaymentsLink( $paymentsNumber, $user )
	{
		global $_CB_framework;
		
		if ( Application::MyUser()->getUserId() != $user->get( 'id', 0, GetterInterface::INT ) ) {
			$this->paymentsListUrl	=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showpaymentslist', 'user' => $user->get( 'id', 0, GetterInterface::INT ) ) );
		} else {
			$this->paymentsListUrl	=	$_CB_framework->pluginClassUrl( array( 'plugin' => 'cbpaidsubscriptions', 'do' => 'showpaymentslist' ) );
		}

		$this->user					=	$user;
		$this->title				=	$this->_paymentsTitle( $paymentsNumber, $user );

		return $this->display( 'paymentslistlink' );
	}

	/**
	 * @param UserTable $user
	 * @param cbPageNav $paging
	 * @return string
	 */
	public function drawPaymentsHistoryList( $user, $paging )
	{
		$this->user						=	$user;
		$this->paging					=	$paging;
		$this->title					=	$this->_paymentsTitle( $paging->total, $user );

		$params							=	cbpaidApp::settingsParams();
		$showInvoices					=	( $params->get( 'invoice_number_format', null, GetterInterface::STRING ) && $params->get( 'show_invoices', true, GetterInterface::BOOLEAN ) );

		$baseClass						=	cbpaidApp::getBaseClass();
		$cbpaidMoney					=	cbpaidMoney::getInstance();

		static $invoices				=	array();

		foreach ( $this->_model as $i ) {
			$name						=	htmlspecialchars( $i->get( 'item_name', null, GetterInterface::STRING ) );

			if ( $showInvoices ) {
				$invoice				=	$i->get( 'payment_basket_id', 0, GetterInterface::INT );

				if ( ! isset( $invoices[$invoice] ) ) {
					$paymentBasket		=	new cbpaidPaymentBasket( $_CB_database );

					$paymentBasket->load( $invoice );

					$invoices[$invoice]	=	$baseClass->getInvoiceUrl( $paymentBasket );
				}

				$name					=	'<a onclick="window.open( \'' . $invoices[$invoice] . '\', \'cbinvoice\', \'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no\' ); return false;" target="_blank" href="' . $invoices[$invoice] . '">'
										.		$name
										.	'</a>';
			}

			$this->items[$i->id]		=	$name;
			$this->amounts[$i->id]		=	$cbpaidMoney->renderPrice( $i->get( 'mc_gross', null, GetterInterface::FLOAT ), $i->get( 'mc_currency', null, GetterInterface::STRING ) );
		}

		return $this->display( 'default' );
	}

	/**
	 * @param int       $invoicesNumber
	 * @param UserTable $user
	 * @return string
	 */
	protected function _paymentsTitle( $invoicesNumber, $user )
	{
		global $ueConfig;

		$paymentsShowPeriod			=	cbpaidApp::settingsParams()->get( 'payments_history_show_period', '0000-06-00 00:00:00', GetterInterface::STRING );

		if ( $paymentsShowPeriod && ( $paymentsShowPeriod != '0000-00-00 00:00:00' ) ) {
			$periodText				=	cbpaidTimes::getInstance()->renderPeriod( $paymentsShowPeriod, 1, false );
		} else {
			$periodText				=	'';
		}

		if ( Application::MyUser()->getUserId() == $user->get( 'id', 0, GetterInterface::INT ) ) {
			if ( $periodText ) {
				$plansTitle 		=	sprintf( CBPTXT::Th( 'Your payments of last %s' ), htmlspecialchars( $periodText ) );
			} else {
				if ( $invoicesNumber == 1 ) {
					$plansTitle		=	CBPTXT::Th( 'Your payment' );
				} else {
					$plansTitle		=	CBPTXT::Th( 'Your payments' );
				}
			}
		} else {
			if ( $periodText ) {
				$plansTitle			=	sprintf( CBPTXT::Th( "%s's payments of last %s" ), getNameFormat( $user->name, $user->username, $ueConfig['name_format'] ), htmlspecialchars( $periodText ) );
			} else {
				$plansTitle 		=	sprintf( CBPTXT::Th( "%s's payments" ), getNameFormat( $user->name, $user->username, $ueConfig['name_format'] ) );
			}
		}

		return $plansTitle;
	}
}
